/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.general.ChaCha7539Engine;
import com.aspose.html.internal.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSymmetricStreamOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.general.VariantKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.StreamCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.security.SecureRandom;

public final class ChaCha20 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ChaCha20");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters STREAM;

    private ChaCha20() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n2 = validatedSymmetricKey.getKeySizeInBits();
        if (ChaCha20.invalidKeySize(n2)) {
            throw new IllegalKeyException("ChaCha20 key must be 256 bits");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n2) {
        return n2 != 256;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        STREAM = new Parameters(ALGORITHM);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    implements com.aspose.html.internal.ms.core.bc.crypto.internal.EngineProvider<StreamCipher> {
        static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        static final byte[] output = Hex.decode("39ec094e9d907f1d0524a9cc7401a4b6");
        static final byte[] iv = Hex.decode("000000000000000000000000");
        static final byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");

        private EngineProvider() {
        }

        @Override
        public StreamCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new ChaCha7539Engine(), new VariantKatTest<ChaCha7539Engine>(){

                @Override
                public void evaluate(ChaCha7539Engine chaCha7539Engine) {
                    byte[] byArray = new byte[input.length];
                    chaCha7539Engine.init(true, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    chaCha7539Engine.processBytes(input, 0, input.length, byArray, 0);
                    if (!Arrays.areEqual(output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                    chaCha7539Engine.init(false, new ParametersWithIV(new KeyParameterImpl(key), iv));
                    chaCha7539Engine.processBytes(output, 0, output.length, byArray, 0);
                    if (!Arrays.areEqual(input, byArray)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private static final int keySizeInBits = 256;
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 256));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricStreamOperatorFactory<Parameters> {
        @Override
        protected StreamCipher createCipher(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            StreamCipher streamCipher = ENGINE_PROVIDER.createEngine();
            KeyParameter keyParameter = Utils.getKeyParameter(ChaCha20.validateKey(symmetricKey, parameters.getAlgorithm()));
            if (parameters.iv == null || parameters.iv.length != 12) {
                throw new IllegalArgumentException("IV must be 12 bytes long");
            }
            streamCipher.init(bl2, new ParametersWithIV(keyParameter, parameters.iv));
            return streamCipher;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 12, byArray);
            if (byArray != null && byArray.length != 12) {
                throw new IllegalArgumentException("IV must be 12 bytes long");
            }
        }

        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        public Parameters withIV(SecureRandom secureRandom) {
            byte[] byArray = new byte[12];
            secureRandom.nextBytes(byArray);
            return this.create((GeneralAlgorithm)this.getAlgorithm(), byArray);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }
}

