/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.modes;

import com.aspose.html.internal.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.StreamBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.modes.CFBBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;

public class GCFBBlockCipher
extends StreamBlockCipher {
    private static final byte[] C = new byte[]{105, 0, 114, 34, 100, -55, 4, 35, -115, 58, -37, -106, 70, -23, 42, -60, 24, -2, -84, -108, 0, -19, 7, 18, -64, -122, -36, -62, -17, 76, -87, 43};
    private final CFBBlockCipher cfbEngine;
    private KeyParameter key;
    private long counter = 0L;
    private boolean forEncryption;

    public GCFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cfbEngine = new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.counter = 0L;
        this.cfbEngine.init(bl2, cipherParameters);
        this.forEncryption = bl2;
        if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.key = (KeyParameter)cipherParameters;
    }

    public String getAlgorithmName() {
        String string = this.cfbEngine.getAlgorithmName();
        return string.substring(0, string.indexOf(47) - 1) + "/G" + string.substring(string.indexOf(47) + 1);
    }

    public int getBlockSize() {
        return this.cfbEngine.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.cfbEngine.getBlockSize(), byArray2, n3);
        return this.cfbEngine.getBlockSize();
    }

    protected byte calculateByte(byte by2) {
        if (this.counter > 0L && this.counter % 1024L == 0L) {
            BlockCipher blockCipher = this.cfbEngine.getUnderlyingCipher();
            blockCipher.init(false, this.key);
            byte[] byArray = new byte[32];
            blockCipher.processBlock(C, 0, byArray, 0);
            blockCipher.processBlock(C, 8, byArray, 8);
            blockCipher.processBlock(C, 16, byArray, 16);
            blockCipher.processBlock(C, 24, byArray, 24);
            this.key = new KeyParameterImpl(byArray);
            blockCipher.init(true, this.key);
            byte[] byArray2 = this.cfbEngine.getCurrentIV();
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
            this.cfbEngine.init(this.forEncryption, new ParametersWithIV(this.key, byArray2));
        }
        ++this.counter;
        return this.cfbEngine.calculateByte(by2);
    }

    public void reset() {
        this.counter = 0L;
        this.cfbEngine.reset();
    }
}

