/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.jcajce.BCLoadStoreParameter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvBCFKS;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvJKS;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

class ProvFipsKS
extends AlgorithmProvider {
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.FipsKS.";

    ProvFipsKS() {
    }

    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.FIPS", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.FipsKS.FIPSKeyStore", new EngineCreator(){

            public Object createInstance(Object object) {
                return new FIPSKeyStore(false, bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IFIPS", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.FipsKS.IFIPSKeyStore", new EngineCreator(){

            public Object createInstance(Object object) {
                return new FIPSKeyStore(true, bouncyCastleFipsProvider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.FIPS-DEF", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.FipsKS.FIPSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new FIPSKeyStore(false, null);
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IFIPS-DEF", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.FipsKS.IFIPDefSKeyStore", new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new FIPSKeyStore(true, null);
                }
            }));
        }
    }

    private static class FIPSKeyStore
    extends KeyStoreSpi {
        private final boolean isImmutable;
        private final BouncyCastleFipsProvider provider;
        private KeyStoreSpi keyStore;

        public FIPSKeyStore(boolean bl2, BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.isImmutable = bl2;
            this.provider = bouncyCastleFipsProvider;
        }

        public Enumeration engineAliases() {
            return this.keyStore.engineAliases();
        }

        public boolean engineContainsAlias(String string) {
            return this.keyStore.engineContainsAlias(string);
        }

        public void engineDeleteEntry(String string) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("delete operation not supported in immutable mode");
            }
            this.keyStore.engineDeleteEntry(string);
        }

        public Certificate engineGetCertificate(String string) {
            return this.keyStore.engineGetCertificate(string);
        }

        public String engineGetCertificateAlias(Certificate certificate) {
            return this.keyStore.engineGetCertificateAlias(certificate);
        }

        public Certificate[] engineGetCertificateChain(String string) {
            return this.keyStore.engineGetCertificateChain(string);
        }

        public Date engineGetCreationDate(String string) {
            return this.keyStore.engineGetCreationDate(string);
        }

        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            return this.keyStore.engineGetKey(string, cArray);
        }

        public boolean engineIsCertificateEntry(String string) {
            return this.keyStore.engineIsCertificateEntry(string);
        }

        public boolean engineIsKeyEntry(String string) {
            return this.keyStore.engineIsKeyEntry(string);
        }

        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetCertificateEntry(string, certificate);
        }

        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(string, byArray, certificateArray);
        }

        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(string, key, cArray, certificateArray);
        }

        public int engineSize() {
            return this.keyStore.engineSize();
        }

        public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetEntry(string, entry, protectionParameter);
        }

        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (loadStoreParameter == null) {
                throw new IllegalArgumentException("'param' arg cannot be null");
            }
            if (!(loadStoreParameter instanceof BCLoadStoreParameter)) {
                throw new IllegalArgumentException("no support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
            BCLoadStoreParameter bCLoadStoreParameter = (BCLoadStoreParameter)loadStoreParameter;
            this.engineLoad(bCLoadStoreParameter.getInputStream(), Utils.extractPassword(loadStoreParameter));
        }

        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (inputStream == null) {
                this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                this.keyStore.engineLoad(null, cArray);
                return;
            }
            byte[] byArray = Streams.readAll(inputStream);
            if (this.isImmutable) {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSImmutableKeyStoreSpi(this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
                catch (Exception exception) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
            } else {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
                catch (Exception exception) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
            }
        }

        public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            this.keyStore.engineStore(loadStoreParameter);
        }

        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
            this.keyStore.engineStore(outputStream, cArray);
        }
    }
}

