/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mime;

import com.aspose.html.internal.ms.core.bc.mime.Headers;
import com.aspose.html.internal.ms.core.bc.mime.smime.SMimeParserContext;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CanonicalOutputStream
extends FilterOutputStream {
    protected int lastb = -1;
    protected static byte[] newline = new byte[2];
    private final boolean is7Bit;

    public CanonicalOutputStream(SMimeParserContext sMimeParserContext, Headers headers, OutputStream outputStream) {
        super(outputStream);
        this.is7Bit = headers.getContentType() != null ? headers.getContentType() != null && !headers.getContentType().equals("binary") : sMimeParserContext.getDefaultContentTransferEncoding().equals("7bit");
    }

    public void write(int n2) throws IOException {
        if (this.is7Bit) {
            if (n2 == 13) {
                this.out.write(newline);
            } else if (n2 == 10) {
                if (this.lastb != 13) {
                    this.out.write(newline);
                }
            } else {
                this.out.write(n2);
            }
        } else {
            this.out.write(n2);
        }
        this.lastb = n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = n2; i2 != n2 + n3; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public void writeln() throws IOException {
        this.out.write(newline);
    }

    static {
        CanonicalOutputStream.newline[0] = 13;
        CanonicalOutputStream.newline[1] = 10;
    }
}

