/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.helpers.info;

import com.aspose.html.internal.ms.helpers.info.formatters.IMembersFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

public class ReflectionUtil {
    public static Set<String> getMembers(Class clazz, IMembersFormatter iMembersFormatter) {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(ReflectionUtil.getFields(clazz, iMembersFormatter));
        treeSet.addAll(ReflectionUtil.getConstructors(clazz, iMembersFormatter));
        treeSet.addAll(ReflectionUtil.getMethods(clazz, iMembersFormatter));
        return treeSet;
    }

    public static Set<String> getConstructors(Class clazz, IMembersFormatter iMembersFormatter) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Constructor<?> constructor : constructorArray) {
            if (constructor.getParameterTypes().length == 0 || !ReflectionUtil.a(constructor.getModifiers())) continue;
            treeSet.add(iMembersFormatter.formatCtor(constructor));
        }
        return treeSet;
    }

    public static Set<String> getMethods(Class clazz, IMembersFormatter iMembersFormatter) {
        Method[] methodArray = clazz.getDeclaredMethods();
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Method method : methodArray) {
            if (!ReflectionUtil.a(method.getModifiers())) continue;
            treeSet.add(iMembersFormatter.formatMethod(method));
        }
        return treeSet;
    }

    public static Set<String> getFields(Class clazz, IMembersFormatter iMembersFormatter) {
        Field[] fieldArray = clazz.getDeclaredFields();
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Field field : fieldArray) {
            if (!ReflectionUtil.a(field.getModifiers())) continue;
            treeSet.add(iMembersFormatter.formatField(field));
        }
        return treeSet;
    }

    private static boolean a(int n2) {
        return Modifier.isPublic(n2);
    }
}

