/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.p124.z4;
import com.aspose.html.net.ContentHeaders;

public abstract class Content
implements IDisposable {
    static final Encoding DefaultHttpEncoding = Encoding.getEncoding(28591);
    static final Encoding DefaultStringEncoding = Encoding.getUTF8();
    private MemoryStream buffer;
    private ContentHeaders headers;
    private boolean isDisposed;

    public final ContentHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new ContentHeaders();
        }
        return this.headers;
    }

    private boolean isBuffered() {
        return this.buffer != null;
    }

    protected Content() {
    }

    private void checkDisposed() {
        if (this.isDisposed) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
    }

    @Override
    public final void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean bl2) {
        if (!this.isDisposed) {
            this.isDisposed = true;
        }
    }

    private MemoryStream getBuffer() {
        if (!this.isBuffered()) {
            this.buffer = new MemoryStream();
            this.serializeToStream(this.buffer);
        }
        this.buffer.seek(0L, 0);
        return this.buffer;
    }

    public final byte[] readAsByteArray() {
        this.checkDisposed();
        return this.getBuffer().toArray();
    }

    public final Stream readAsStream() {
        this.checkDisposed();
        return new z1(new MemoryStream(this.readAsByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readAsString() {
        Encoding encoding;
        this.checkDisposed();
        String string = null;
        if (!StringExtensions.isNullOrEmpty(this.getHeaders().get_Item("Content-Type")) && (encoding = z4.m198(this.getHeaders().get_Item("Content-Type"))) != null) {
            string = encoding.getWebName();
        }
        encoding = !StringExtensions.isNullOrEmpty(string) ? Encoding.getEncoding(string) : DefaultStringEncoding;
        StreamReader streamReader = new StreamReader(this.readAsStream(), encoding, true);
        try {
            String string2 = streamReader.readToEnd();
            return string2;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    protected abstract void serializeToStream(Stream var1);

    private static class z1
    extends com.aspose.html.internal.p218.z1 {
        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public int getWriteTimeout() {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void setWriteTimeout(int n2) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        public z1(Stream stream) {
            super(stream);
        }

        @Override
        public void flush() {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void setLength(long l2) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void writeByte(byte by2) {
            throw new NotSupportedException("The stream does not support writing.");
        }
    }
}

