/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.messagehandlers;

import com.aspose.html.dom.z1;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Diagnostics.Stopwatch;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.CookieContainer;
import com.aspose.html.internal.ms.System.Net.CredentialCache;
import com.aspose.html.internal.ms.System.Net.HttpWebRequest;
import com.aspose.html.internal.ms.System.Net.HttpWebResponse;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.Net.WebHeaderCollection;
import com.aspose.html.internal.ms.System.Net.WebRequest;
import com.aspose.html.internal.ms.System.Net.WebResponse;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p11.z28;
import com.aspose.html.internal.p11.z4;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.INetworkOperationContext;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.net.StreamContent;
import com.aspose.html.net.messagefilters.ProtocolMessageFilter;
import com.aspose.html.net.z1;

public class HttpProtocolMessageHandler
extends MessageHandler {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("Accept", "User-Agent", "Content-Type", "Expect", "Referer");

    public HttpProtocolMessageHandler() {
        this.getFilters().addItem(new ProtocolMessageFilter(com.aspose.html.internal.p195.z4.m1(z1.z6.m2304), com.aspose.html.internal.p195.z4.m1(z1.z6.m2305)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyHeadersToRequest(WebHeaderCollection webHeaderCollection, WebRequest webRequest) {
        IEnumerator iEnumerator = webHeaderCollection.getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (!WebHeaderCollection.isRestricted(string)) {
                    webRequest.getHeaders().set(string, webHeaderCollection.get_Item(string));
                    continue;
                }
                HttpWebRequest httpWebRequest = Operators.as(webRequest, HttpWebRequest.class);
                if (httpWebRequest == null) continue;
                switch (gStringSwitchMap.of(string)) {
                    case 0: {
                        httpWebRequest.setAccept(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 1: {
                        httpWebRequest.setUserAgent(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 2: {
                        httpWebRequest.setContentType(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 3: {
                        httpWebRequest.setExpect(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 4: {
                        httpWebRequest.setReferer(webHeaderCollection.get_Item(string));
                    }
                }
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyHeadersToResponse(WebResponse webResponse, ResponseMessage responseMessage) {
        IEnumerator iEnumerator = webResponse.getHeaders().getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                responseMessage.getHeaders().add(string, webResponse.getHeaders().get(string));
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(INetworkOperationContext iNetworkOperationContext) {
        Object object;
        Object object2;
        if (z4.m144().getEnabled()) {
            z4.m144().m390().m385();
        }
        HttpWebRequest httpWebRequest = (HttpWebRequest)WebRequest.create(iNetworkOperationContext.getRequest().getRequestUri().getHref());
        httpWebRequest.setMethod(iNetworkOperationContext.getRequest().getMethod() != null ? iNetworkOperationContext.getRequest().getMethod().getName() : HttpMethod.getGet().getName());
        ICredentials iCredentials = iNetworkOperationContext.getRequest().getCredentials();
        if (iCredentials == null) {
            iCredentials = CredentialCache.getDefaultCredentials();
        }
        httpWebRequest.setCredentials(iCredentials);
        httpWebRequest.setPreAuthenticate(iNetworkOperationContext.getRequest().getPreAuthenticate());
        httpWebRequest.setTimeout(Operators.castToInt32(iNetworkOperationContext.getRequest().getTimeout().getTotalMilliseconds(), 14));
        CookieContainer cookieContainer = iNetworkOperationContext.getRequest().getCookieContainer();
        if (cookieContainer == null) {
            cookieContainer = new CookieContainer();
        }
        httpWebRequest.setCookieContainer(cookieContainer);
        HttpProtocolMessageHandler.copyHeadersToRequest(iNetworkOperationContext.getRequest().getHeaders(), httpWebRequest);
        if (StringExtensions.isNullOrEmpty(httpWebRequest.getAccept())) {
            httpWebRequest.setAccept("*/*");
        }
        httpWebRequest.setUserAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35 Safari/537.36");
        if ((HttpMethod.getPost().equals(iNetworkOperationContext.getRequest().getMethod()) || HttpMethod.getPut().equals(iNetworkOperationContext.getRequest().getMethod())) && iNetworkOperationContext.getRequest().getContent() != null) {
            HttpProtocolMessageHandler.copyHeadersToRequest(iNetworkOperationContext.getRequest().getContent().getHeaders(), httpWebRequest);
            object2 = httpWebRequest.getRequestStream();
            object = iNetworkOperationContext.getRequest().getContent().readAsByteArray();
            ((Stream)object2).write((byte[])object, 0, ((Object)object).length);
            ((Stream)object2).close();
        }
        object2 = null;
        if (z4.m144().getEnabled()) {
            object2 = Stopwatch.startNew();
        }
        try {
            object = (HttpWebResponse)httpWebRequest.getResponse();
            try {
                Stream stream = ((HttpWebResponse)object).getResponseStream();
                try {
                    if (z4.m144().getEnabled()) {
                        ((Stopwatch)object2).stop();
                        z4.m144().m391().setValue(((Stopwatch)object2).getElapsedMilliseconds());
                    }
                    MemoryStream memoryStream = new MemoryStream();
                    z28.copyStream(stream, memoryStream);
                    memoryStream.flush();
                    memoryStream.seek(0L, 0);
                    iNetworkOperationContext.setResponse(new ResponseMessage(((HttpWebResponse)object).getStatusCode()));
                    iNetworkOperationContext.getResponse().setRequest(iNetworkOperationContext.getRequest());
                    iNetworkOperationContext.getResponse().setContent(new StreamContent(memoryStream));
                    iNetworkOperationContext.getResponse().setCookies(((HttpWebResponse)object).getCookies());
                    HttpProtocolMessageHandler.copyHeadersToResponse((WebResponse)object, iNetworkOperationContext.getResponse());
                }
                finally {
                    if (stream != null) {
                        stream.dispose();
                    }
                }
            }
            finally {
                if (object != null) {
                    object.dispose();
                }
            }
        }
        catch (Exception exception) {
            if (z4.m144().getEnabled()) {
                ((Stopwatch)object2).stop();
                z4.m144().m391().setValue(((Stopwatch)object2).getElapsedMilliseconds());
            }
            iNetworkOperationContext.setResponse(new ResponseMessage(400));
            iNetworkOperationContext.getResponse().setContent(new z1(exception));
        }
        this.next(iNetworkOperationContext);
    }
}

