/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.pdf;

import com.aspose.html.HTMLAnchorElement;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLLIElement;
import com.aspose.html.HTMLTemplateElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IBrowsingContext;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.svg.SVGAElement;
import com.aspose.html.dom.z1;
import com.aspose.html.drawing.Color;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p141.z13;
import com.aspose.html.internal.p141.z14;
import com.aspose.html.internal.p141.z6;
import com.aspose.html.internal.p141.z7;
import com.aspose.html.internal.p15.z5;
import com.aspose.html.internal.p283.z16;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.pdf.PdfRenderingOptions;
import com.aspose.html.rendering.pdf.z18;
import com.aspose.html.rendering.pdf.z26;
import com.aspose.html.rendering.pdf.z8;
import com.aspose.html.rendering.pdf.z9;
import com.aspose.html.rendering.z4;

public class PdfDevice
extends Device<z3, PdfRenderingOptions> {
    private final List<z1> _internalLinks = new List();
    private z9 _pdfDoc;
    private final Dictionary<String, Dictionary<Url, z2>> _uriIdLocationMap = new Dictionary();
    private final Dictionary<String, Integer> _uriPage = new Dictionary();
    private Node bookmarks;
    private String bookmarksBaseUrl;
    private String currentBaseUri;
    private z5 drFactory;
    private com.aspose.html.internal.p17.z8 fontFactory;
    private com.aspose.html.rendering.z1 formElementsFactory;
    private com.aspose.html.internal.p18.z4 zipFactory;

    public PdfDevice(ICreateStreamProvider iCreateStreamProvider) {
        this(new PdfRenderingOptions(), iCreateStreamProvider);
    }

    @Override
    protected z3 createContext() {
        return new z3();
    }

    public PdfDevice(PdfRenderingOptions pdfRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        super(pdfRenderingOptions, iCreateStreamProvider);
    }

    public PdfDevice(PdfRenderingOptions pdfRenderingOptions, Stream stream) {
        super(pdfRenderingOptions, stream);
    }

    public PdfDevice(PdfRenderingOptions pdfRenderingOptions, String string) {
        super(pdfRenderingOptions, string);
    }

    public PdfDevice(Stream stream) {
        this(new PdfRenderingOptions(), stream);
    }

    public PdfDevice(String string) {
        this(new PdfRenderingOptions(), string);
    }

    private void addBookmarks() {
        if (this.bookmarks == null) {
            return;
        }
        if (StringExtensions.equals(this.bookmarks.getLocalName(), "ncx", (short)5)) {
            this.addNavigation(Operators.as(this.bookmarks, Element.class), 0, new z16<Element, Boolean>(){

                public Boolean m5(Element element) {
                    return StringExtensions.equals(element.getTagName(), "navPoint", (short)5);
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m5((Element)object);
                }
            }, new z16<Element, String>(){

                public String m11(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "content");
                    return element2 != null ? element2.getAttribute("src") : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m11((Element)object);
                }
            }, new z16<Element, String>(){

                public String m11(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "navLabel");
                    return element2 != null ? element2.getTextContent() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m11((Element)object);
                }
            });
        } else {
            this.addNavigation(Operators.as(this.bookmarks, Element.class), 0, new z16<Element, Boolean>(){

                public Boolean m5(Element element) {
                    return Operators.is(element, HTMLLIElement.class);
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m5((Element)object);
                }
            }, new z16<Element, String>(){

                public String m11(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "a");
                    return element2 != null ? ((HTMLAnchorElement)element2).getHref() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m11((Element)object);
                }
            }, new z16<Element, String>(){

                public String m11(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "a");
                    return element2 != null ? element2.getTextContent() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m11((Element)object);
                }
            });
        }
    }

    private void addFormElement(com.aspose.html.internal.p141.z9 z910) {
        if (z910 != null) {
            z14 z1410 = Operators.as(z910, z14.class);
            if (z1410 != null) {
                this._pdfDoc.m1517().m1(z1410, this._pdfDoc.m1545());
                return;
            }
            com.aspose.html.internal.p141.z3 z3100 = Operators.as(z910, com.aspose.html.internal.p141.z3.class);
            if (z3100 != null) {
                this._pdfDoc.m1517().m1(z3100, this._pdfDoc.m1545());
                return;
            }
            z13 z1310 = Operators.as(z910, z13.class);
            if (z1310 != null) {
                this._pdfDoc.m1517().m1(z1310, this._pdfDoc.m1545());
                return;
            }
            z6 z610 = Operators.as(z910, z6.class);
            if (z610 != null) {
                this._pdfDoc.m1517().m1(z610, this._pdfDoc.m1545());
                return;
            }
            z7 z710 = Operators.as(z910, z7.class);
            if (z710 != null) {
                this._pdfDoc.m1517().m1(z710, this._pdfDoc.m1545());
                return;
            }
        }
    }

    private void addHyperlink(Element element, RectangleF rectangleF) {
        Object object;
        String string;
        if (element.hasAttribute("href")) {
            string = element.getAttribute("href");
        } else {
            object = Operators.as(element, SVGAElement.class);
            if (object == null) {
                return;
            }
            string = (String)((SVGAElement)object).getHref().getAnimVal();
            if (string == null) {
                return;
            }
        }
        object = this._pdfDoc.m1545().m1(this.transformRect(rectangleF.Clone()).Clone(), null);
        Url url = new Url(string, element.getBaseURI());
        Url url2 = new Url(element.getBaseURI());
        if (Uri.isWellFormedUriString(string, 1) || !StringExtensions.equals(url.getPathname(), url2.getPathname()) && !"epub:".equals(url2.getProtocol())) {
            ((com.aspose.html.rendering.pdf.z3)object).m1(new com.aspose.html.internal.p163.z4(string));
        } else {
            this._internalLinks.addItem(new z1((com.aspose.html.rendering.pdf.z3)object, url, url.getHash()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addInternalLinksDestinations() {
        IGenericEnumerator iGenericEnumerator = this._internalLinks.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z1 z1100 = (z1)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = this._uriIdLocationMap.iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator2.next();
                        Url url = new Url((String)keyValuePair.getKey());
                        if (!StringExtensions.equals(z1100.m1535().getPathname(), url.getPathname())) continue;
                        int n2 = 0;
                        Object[] objectArray = new Integer[]{n2};
                        boolean bl2 = StringExtensions.isNullOrEmpty(z1100.m1533()) && this._uriPage.tryGetValue((String)keyValuePair.getKey(), objectArray);
                        n2 = objectArray[0];
                        if (bl2) {
                            z1100.m1534().m1(new com.aspose.html.internal.p163.z2(new z8((String)this._pdfDoc.m1521().m1567().get_Item(n2 - 1), new PointF(0.0f, this._pdfDoc.m1521().m1568().get_Item(n2 - 1).getHeight()))));
                            continue;
                        }
                        Object object = null;
                        Object[] objectArray2 = new z2[]{object};
                        boolean bl3 = ((Dictionary)keyValuePair.getValue()).tryGetValue(z1100.m1535(), objectArray2);
                        object = objectArray2[0];
                        if (!bl3) continue;
                        z1100.m1534().m1(new com.aspose.html.internal.p163.z2(new z8(((z2)object).m1536(), ((z2)object).getLocation().Clone())));
                    }
                }
                finally {
                    if (!Operators.is(iGenericEnumerator2, IDisposable.class)) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return;
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigation(Element element, int n2, z16<Element, Boolean> z1610, z16<Element, String> z1611, z16<Element, String> z1612) {
        Object object;
        Object object2;
        if (element == null) {
            return;
        }
        if (z1610.invoke(element).booleanValue()) {
            ++n2;
            object2 = z1611.invoke(element);
            object = PdfDevice.trimBookmarksTitles(z1612.invoke(element));
            if (!StringExtensions.isNullOrEmpty((String)object2) && !StringExtensions.isNullOrEmpty((String)object)) {
                Object object3;
                Object object4;
                Object object5;
                final Url[] urlArray = new Url[]{new Url((String)object2, this.bookmarksBaseUrl)};
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this._internalLinks.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        z1 z1100 = (z1)iGenericEnumerator.next();
                        if (urlArray[0].equals((Object)z1100.m1535())) {
                            boolean bl3;
                            KeyValuePair keyValuePair;
                            if (StringExtensions.isNullOrEmpty(urlArray[0].getHash())) {
                                object5 = this._uriIdLocationMap.iterator();
                                try {
                                    while (object5.hasNext()) {
                                        keyValuePair = (KeyValuePair)object5.next();
                                        int n3 = 0;
                                        object4 = new Url(StringExtensions.Empty, (String)keyValuePair.getKey());
                                        object3 = new Integer[]{n3};
                                        bl3 = StringExtensions.equals(z1100.m1535().getPathname(), ((Url)object4).getPathname()) && this._uriPage.tryGetValue((String)keyValuePair.getKey(), (Object[])object3);
                                        n3 = (Integer)object3[0];
                                        if (!bl3) continue;
                                        this._pdfDoc.m1519().m1((String)object, n2, new z8((String)this._pdfDoc.m1521().m1567().get_Item(n3 - 1), new PointF(0.0f, this._pdfDoc.m1521().m1568().get_Item(n3 - 1).getHeight())));
                                        bl2 = true;
                                    }
                                }
                                finally {
                                    if (Operators.is(object5, IDisposable.class)) {
                                        ((IDisposable)object5).dispose();
                                    }
                                }
                            } else if (StringExtensions.equals(urlArray[0].getHash(), z1100.m1533())) {
                                object5 = this._uriIdLocationMap.iterator();
                                try {
                                    while (object5.hasNext()) {
                                        keyValuePair = (KeyValuePair)object5.next();
                                        Object object6 = null;
                                        object4 = new Url(StringExtensions.Empty, (String)keyValuePair.getKey());
                                        object3 = new z2[]{object6};
                                        bl3 = StringExtensions.equals(z1100.m1535().getPathname(), ((Url)object4).getPathname()) && ((Dictionary)keyValuePair.getValue()).tryGetValue(z1100.m1535(), (Object[])object3);
                                        object6 = object3[0];
                                        if (!bl3) continue;
                                        this._pdfDoc.m1519().m1((String)object, n2, new z8(((z2)object6).m1536(), ((z2)object6).getLocation().Clone()));
                                        bl2 = true;
                                        break;
                                    }
                                }
                                finally {
                                    if (Operators.is(object5, IDisposable.class)) {
                                        ((IDisposable)object5).dispose();
                                    }
                                }
                            }
                        }
                        if (!bl2) continue;
                        break;
                    }
                }
                finally {
                    if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
                if (!bl2) {
                    int n4 = 0;
                    object5 = new Integer[]{n4};
                    boolean bl4 = this._uriPage.tryGetValue(urlArray[0].getHref(), (Object[])object5);
                    n4 = (Integer)object5[0];
                    if (bl4) {
                        this._pdfDoc.m1519().m1((String)object, n2, new z8((String)this._pdfDoc.m1521().m1567().get_Item(n4 - 1), new PointF(0.0f, this._pdfDoc.m1521().m1568().get_Item(n4 - 1).getHeight())));
                    } else if (com.aspose.html.internal.p292.z3.m2(this._uriIdLocationMap, new z16<KeyValuePair<String, Dictionary<Url, z2>>, Boolean>(){

                        public Boolean m2(KeyValuePair<String, Dictionary<Url, z2>> keyValuePair) {
                            return Url.z1.m1(urlArray[0], new Url(StringExtensions.Empty, keyValuePair.getKey()), true);
                        }

                        @Override
                        public /* synthetic */ Object invoke(Object object) {
                            return this.m2((KeyValuePair)object);
                        }
                    })) {
                        IGenericEnumerator iGenericEnumerator2 = this._uriIdLocationMap.iterator();
                        try {
                            while (iGenericEnumerator2.hasNext()) {
                                object4 = (KeyValuePair)iGenericEnumerator2.next();
                                object3 = null;
                                Object[] objectArray = new z2[]{object3};
                                boolean bl5 = Url.z1.m1(urlArray[0], new Url(StringExtensions.Empty, (String)((KeyValuePair)object4).getKey()), true) && ((Dictionary)((KeyValuePair)object4).getValue()).tryGetValue(urlArray[0], objectArray);
                                object3 = objectArray[0];
                                if (!bl5) continue;
                                this._pdfDoc.m1519().m1((String)object, n2, new z8(((z2)object3).m1536(), ((z2)object3).getLocation().Clone()));
                                break;
                            }
                        }
                        finally {
                            if (Operators.is(iGenericEnumerator2, IDisposable.class)) {
                                ((IDisposable)iGenericEnumerator2).dispose();
                            }
                        }
                    }
                }
            }
        }
        object2 = element.getChildren().iterator();
        try {
            while (object2.hasNext()) {
                object = (Element)object2.next();
                this.addNavigation((Element)object, n2, z1610, z1611, z1612);
            }
        }
        finally {
            if (Operators.is(object2, IDisposable.class)) {
                ((IDisposable)object2).dispose();
            }
        }
    }

    @Override
    public void addRect(RectangleF rectangleF) {
        this._pdfDoc.m1545().addRect(rectangleF.Clone());
    }

    private void addToLocationMap(Url url, RectangleF rectangleF, Dictionary<Url, z2> dictionary) {
        Object object = null;
        Object[] objectArray = new z2[]{object};
        boolean bl2 = !dictionary.tryGetValue(url, objectArray);
        object = objectArray[0];
        if (bl2) {
            dictionary.set_Item(url, new z2(this._pdfDoc.m1545().m1553(), this.transformRect(rectangleF.Clone()).getLocation().Clone()));
        }
    }

    @Override
    public void beginDocument(Document document) {
        this.currentBaseUri = document.getBaseURI();
        super.beginDocument(document);
        if (this._pdfDoc != null) {
            return;
        }
        IBrowsingContext iBrowsingContext = document.getContext();
        this.drFactory = iBrowsingContext.getService(z5.class);
        this.fontFactory = iBrowsingContext.getService(com.aspose.html.internal.p17.z8.class);
        this.zipFactory = iBrowsingContext.getService(com.aspose.html.internal.p18.z4.class);
        this.formElementsFactory = new com.aspose.html.rendering.z1(this.fontFactory, iBrowsingContext.getService(com.aspose.html.internal.p141.z8.class));
        this._pdfDoc = new z9(this.getOutputStream(), (PdfRenderingOptions)this.getOptions(), this, this.drFactory, this.fontFactory, this.zipFactory);
    }

    @Override
    public boolean beginElement(Element element, RectangleF rectangleF) {
        Dictionary<Url, z2> dictionary;
        HTMLElement hTMLElement;
        if (!StringExtensions.isNullOrEmpty(this.currentBaseUri) && !this._uriPage.containsKey(this.currentBaseUri)) {
            this._uriPage.set_Item(this.currentBaseUri, this.getPageIndex());
        }
        if (!((hTMLElement = Operators.as(element, HTMLElement.class)) == null || StringExtensions.isNullOrEmpty(hTMLElement.getId_Rename_Namesake()) && StringExtensions.isNullOrEmpty(hTMLElement.getAttribute("name")) || StringExtensions.isNullOrEmpty(this.currentBaseUri))) {
            dictionary = null;
            Object[] objectArray = new Dictionary[]{dictionary};
            boolean bl2 = !this._uriIdLocationMap.tryGetValue(this.currentBaseUri, objectArray);
            dictionary = objectArray[0];
            if (bl2) {
                dictionary = new Dictionary<Url, z2>();
                this._uriIdLocationMap.set_Item(this.currentBaseUri, dictionary);
            }
            if (!StringExtensions.isNullOrEmpty(hTMLElement.getId_Rename_Namesake())) {
                this.addToLocationMap(new Url(StringExtensions.concat("#", hTMLElement.getId_Rename_Namesake()), hTMLElement.getBaseURI()), rectangleF.Clone(), dictionary);
            }
            if (!StringExtensions.isNullOrEmpty(hTMLElement.getAttribute("name"))) {
                this.addToLocationMap(new Url(StringExtensions.concat("#", hTMLElement.getAttribute("name")), hTMLElement.getBaseURI()), rectangleF.Clone(), dictionary);
            }
        }
        if ((dictionary = this.formElementsFactory.m1(element, rectangleF.Clone(), (GraphicContext)this.getGraphicContext())) != null) {
            this.addFormElement((com.aspose.html.internal.p141.z9)((Object)dictionary));
            return Operators.is(dictionary, com.aspose.html.internal.p141.z3.class);
        }
        if (Element.z1.m16(element).m2(z1.z5.m2085)) {
            this.addHyperlink(element, rectangleF.Clone());
        }
        return true;
    }

    @Override
    public void beginPage(SizeF sizeF) {
        super.beginPage(sizeF.Clone());
        this._pdfDoc.m1(sizeF.Clone());
        this.saveGraphicContext();
        ((z3)this.getGraphicContext()).transform(new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, sizeF.getHeight()));
        z4.m1(this.drFactory, this, sizeF.Clone());
    }

    public final void clearExtGraphicState() {
        while (((z3)this.getGraphicContext()).m1538() > 0) {
            ((z3)this.getGraphicContext()).m197(((z3)this.getGraphicContext()).m1538() - 1);
            this._pdfDoc.m1545().m1564();
        }
    }

    @Override
    public void clip(int n2) {
        this._pdfDoc.m1545().clip(n2);
    }

    @Override
    public void closePath() {
        this._pdfDoc.m1545().closePath();
    }

    @Override
    public void cubicBezierTo(PointF pointF, PointF pointF2, PointF pointF3) {
        this._pdfDoc.m1545().cubicBezierTo(pointF.Clone(), pointF2.Clone(), pointF3.Clone());
    }

    @Override
    public void drawImage(byte[] byArray, int n2, RectangleF rectangleF) {
        this.saveGraphicContext();
        this._pdfDoc.m1545().m1(byArray, rectangleF.Clone());
        this.restoreGraphicContext();
    }

    @Override
    public void endDocument() {
        if (Device.z1.m2(this)) {
            this.registerBookmarks();
        }
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void endPage() {
        this.restoreGraphicContext();
        this._pdfDoc.endPage();
        super.endPage();
    }

    @Override
    public void fill(int n2) {
        this._pdfDoc.m1545().fill(n2);
    }

    @Override
    public void fillText(String string, PointF pointF) {
        this._pdfDoc.m1545().m1(string, pointF.Clone(), ((z3)this.getGraphicContext()).getTextInfo().getCharacterInfos());
    }

    @Override
    public void flush() {
        if (Device.z1.m2(this) && this._pdfDoc != null) {
            this.addInternalLinksDestinations();
            this.addBookmarks();
            this._pdfDoc.endDocument();
            this._pdfDoc = null;
        }
        this._uriIdLocationMap.clear();
        this._internalLinks.clear();
        this._uriPage.clear();
        super.flush();
    }

    @Override
    protected String getExtension() {
        return ".pdf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getFirstChildElement(Element element, String string) {
        IEnumerator iEnumerator = element.getChildren().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element2 = (Element)iEnumerator.next();
                if (!StringExtensions.equals(element2.getTagName(), string, (short)5)) continue;
                Element element3 = element2;
                return element3;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        ((z3)this.getGraphicContext()).m1(this);
    }

    @Override
    public void lineTo(PointF pointF) {
        this._pdfDoc.m1545().lineTo(pointF.Clone());
    }

    @Override
    public void moveTo(PointF pointF) {
        this._pdfDoc.m1545().moveTo(pointF.Clone());
    }

    private void registerBookmarks() {
        HTMLTemplateElement hTMLTemplateElement = Operators.as(Device.z1.m1(this).querySelector("head template"), HTMLTemplateElement.class);
        if (hTMLTemplateElement == null || hTMLTemplateElement.getContent().getFirstChild() == null) {
            return;
        }
        this.bookmarksBaseUrl = hTMLTemplateElement.getAttribute("BaseUrl");
        this.bookmarks = hTMLTemplateElement.getContent().getFirstChild();
    }

    @Override
    public void restoreGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.m1545().m1564();
        super.restoreGraphicContext();
    }

    @Override
    public void saveGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.m1545().m1565();
        try {
            ((z3)this.getGraphicContext()).m63(true);
            super.saveGraphicContext();
        }
        finally {
            ((z3)this.getGraphicContext()).m63(false);
        }
    }

    public final void setExtGraphicState() {
        this._pdfDoc.m1545().m1565();
        ((z3)this.getGraphicContext()).m197(((z3)this.getGraphicContext()).m1538() + 1);
    }

    @Override
    public void stroke() {
        this._pdfDoc.m1545().stroke();
    }

    @Override
    public void strokeAndFill(int n2) {
        this._pdfDoc.m1545().strokeAndFill(n2);
    }

    @Override
    public void strokeText(String string, PointF pointF) {
    }

    private static RectangleF transformRect(Matrix matrix, RectangleF rectangleF) {
        PointF[] pointFArray = (PointF[])Array.unboxing(Array.createInstance(Operators.typeOf(PointF.class), 2));
        pointFArray[0] = new PointF(rectangleF.getLeft(), rectangleF.getTop());
        pointFArray[1] = new PointF(rectangleF.getRight(), rectangleF.getBottom());
        matrix.transformPoints(pointFArray);
        return RectangleF.fromLTRB(pointFArray[0].getX(), pointFArray[0].getY(), pointFArray[1].getX(), pointFArray[1].getY());
    }

    private RectangleF transformRect(RectangleF rectangleF) {
        if (((z3)this.getGraphicContext()).getTransformationMatrix() == null || ((z3)this.getGraphicContext()).getTransformationMatrix().isIdentity()) {
            return rectangleF;
        }
        return PdfDevice.transformRect(((z3)this.getGraphicContext()).getTransformationMatrix(), rectangleF.Clone());
    }

    private static String trimBookmarksTitles(String string) {
        if (StringExtensions.isNullOrEmpty(string)) {
            return null;
        }
        return StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(string, '\n', ' '), '\r', ' '));
    }

    public static class z3
    extends GraphicContext
    implements Cloneable {
        private boolean m7607;
        private float m7608 = 1.0f;
        private Color m7609 = Color.getBlack().Clone();
        private com.aspose.html.internal.p168.z1 m7610 = com.aspose.html.internal.p168.z1.m1613();
        private float m7611 = 1.0f;
        private Color m7612 = Color.getBlack().Clone();
        private com.aspose.html.internal.p168.z1 m7613 = com.aspose.html.internal.p168.z1.m1613();
        private int m7614;
        private PdfDevice m7615;
        private int m7616;
        private z18 m7617;
        private boolean m7618;
        private float m7619;

        public final PdfDevice m1537() {
            return this.m7615;
        }

        public final void m1(PdfDevice pdfDevice) {
            this.m7615 = pdfDevice;
        }

        @Override
        public IBrush getFillBrush() {
            return super.getFillBrush();
        }

        @Override
        public void setFillBrush(IBrush iBrush) {
            this.m1537().clearExtGraphicState();
            this.m1540().m1562().m1(iBrush, false);
            super.setFillBrush(iBrush);
        }

        public final int m1538() {
            return this.m7616;
        }

        public final void m197(int n2) {
            this.m7616 = n2;
        }

        public final boolean m1539() {
            return this.m7611 < 1.0f || this.m7608 < 1.0f;
        }

        @Override
        public int getLineCap() {
            return super.getLineCap();
        }

        @Override
        public void setLineCap(int n2) {
            super.setLineCap(n2);
            int n3 = 0;
            switch (n2) {
                case 2: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                }
            }
            this.m1540().m1563().m25("{0} J", com.aspose.html.internal.p25.z3.m26(n3));
        }

        @Override
        public int getLineJoin() {
            return super.getLineJoin();
        }

        @Override
        public void setLineJoin(int n2) {
            super.setLineJoin(n2);
            int n3 = 0;
            switch (n2) {
                case 2: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                }
            }
            this.m1540().m1563().m25("{0} j", com.aspose.html.internal.p25.z3.m26(n3));
        }

        @Override
        public float getLineWidth() {
            return super.getLineWidth();
        }

        @Override
        public void setLineWidth(float f2) {
            super.setLineWidth(f2);
            this.m1540().m1563().m25("{0} w", z26.m52(f2));
        }

        @Override
        public float getMiterLimit() {
            return super.getMiterLimit();
        }

        @Override
        public void setMiterLimit(float f2) {
            super.setMiterLimit(f2);
            this.m1540().m1563().m25("{0} M", z26.m52(f2));
        }

        public final z18 m1540() {
            return this.m7617;
        }

        public final void m1(z18 z1810) {
            this.m7617 = z1810;
        }

        public final boolean m1541() {
            return this.m7618;
        }

        public final void m63(boolean bl2) {
            this.m7618 = bl2;
        }

        @Override
        public IBrush getStrokeBrush() {
            return super.getStrokeBrush();
        }

        @Override
        public void setStrokeBrush(IBrush iBrush) {
            this.m1537().clearExtGraphicState();
            this.m1540().m1562().m1(iBrush, true);
            super.setStrokeBrush(iBrush);
        }

        public final float m1542() {
            return this.m7619;
        }

        public final void m50(float f2) {
            this.m7619 = f2;
        }

        @Override
        public Matrix getTransformationMatrix() {
            return super.getTransformationMatrix();
        }

        @Override
        public void setTransformationMatrix(Matrix matrix) {
            if (this.m1541()) {
                super.setTransformationMatrix(matrix);
            } else if (super.getTransformationMatrix() != null && !super.getTransformationMatrix().isIdentity() && super.getTransformationMatrix().isInvertible()) {
                super.getTransformationMatrix().invert();
                float[] fArray = super.getTransformationMatrix().getElements();
                this.m1540().m1563().m1(this.m1537().drFactory.m1(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                Matrix matrix2 = new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.m1540().getHeight());
                matrix2.multiply(matrix);
                fArray = matrix2.getElements();
                this.m1540().m1563().m1(this.m1537().drFactory.m1(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                super.setTransformationMatrix(matrix2);
            }
        }

        @Override
        public GraphicContext deepClone() {
            z3 z3100 = (z3)this.memberwiseClone();
            if (this.getTransformationMatrix() != null) {
                z3100.setTransformationMatrix(this.getTransformationMatrix().deepClone());
            }
            this.m197(0);
            return z3100;
        }

        @Override
        public void transform(Matrix matrix) {
            float[] fArray = matrix.getElements();
            this.m1540().m1563().m1(this.m1537().drFactory.m1(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
            if (super.getTransformationMatrix() != null) {
                super.getTransformationMatrix().multiply(matrix);
            } else {
                super.setTransformationMatrix(matrix.deepClone());
            }
        }

        public final void m1(Color color, boolean bl2) {
            if (bl2) {
                if (this.m7613 == com.aspose.html.internal.p168.z1.m1614() && Color.op_Equality(color, this.m7612)) {
                    return;
                }
                this.m7613 = com.aspose.html.internal.p168.z1.m1614();
                color.CloneTo(this.m7612);
            } else {
                if (this.m7610 == com.aspose.html.internal.p168.z1.m1614() && Color.op_Equality(color, this.m7609)) {
                    return;
                }
                this.m7610 = com.aspose.html.internal.p168.z1.m1614();
                color.CloneTo(this.m7609);
            }
            if ((color.getA() & 0xFF) < 255) {
                com.aspose.html.internal.p168.z2 z2100 = this.m1540().m1544().m1530().m1569();
                float f2 = (float)(color.getA() & 0xFF) / 255.0f;
                if (bl2) {
                    this.m7611 = f2;
                } else {
                    this.m7608 = f2;
                }
                z2100.m53(this.m7608);
                z2100.m54(this.m7611);
                this.m1(z2100);
                this.m7607 = true;
            } else if (this.m1539()) {
                com.aspose.html.internal.p168.z2 z2101 = this.m1540().m1544().m1530().m1569();
                float f3 = 1.0f;
                if (bl2) {
                    this.m7611 = 1.0f;
                } else {
                    this.m7608 = 1.0f;
                }
                z2101.m53(this.m7608);
                z2101.m54(this.m7611);
                this.m1(z2101);
            }
            this.m1540().m1563().m11("{0} {1}", z26.m6(this.m1537().drFactory.m16(color.Clone())), bl2 ? "RG" : "rg");
        }

        public final void m1(com.aspose.html.internal.p168.z1 z1100, boolean bl2) {
            if (bl2) {
                if (z1100 == this.m7613) {
                    return;
                }
                this.m7613 = z1100;
            } else {
                if (z1100 == this.m7610) {
                    return;
                }
                this.m7610 = z1100;
            }
            this.m1540().m1563().m11("/{0} {1}", z1100.getFullName(), bl2 ? "CS" : "cs");
        }

        private void m1(com.aspose.html.internal.p168.z2 z2100) {
            this.m1537().setExtGraphicState();
            this.m1540().m1563().m25("/{0} gs", z2100.m1555());
        }

        public final void m1543() {
            this.m1540().m1563().m25("{0} Tc", z26.m52(this.getCharacterSpacing()));
        }

        public final void m1(com.aspose.html.internal.p166.z2 z2100) {
            this.m1540().m1563().m11("/{0} {1} Tf", z2100.m1555(), z26.m52(this.getFontSize()));
        }

        public final void m51(float f2) {
            if (f2 == this.m1542()) {
                return;
            }
            this.m50(f2);
            this.m1540().m1563().m25("{0} TL", z26.m52(f2));
        }

        public final void m198(int n2) {
            if (n2 == this.m7614) {
                return;
            }
            this.m7614 = n2;
            this.m1540().m1563().m25("{0} Tr", com.aspose.html.internal.p25.z3.m26(n2));
        }

        @Override
        protected Object memberwiseClone() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }
    }

    private static class z2 {
        private final PointF m7605 = new PointF();
        private final String m7606;

        public final PointF getLocation() {
            return this.m7605;
        }

        public final String m1536() {
            return this.m7606;
        }

        public z2(String string, PointF pointF) {
            this.m7606 = string;
            pointF.CloneTo(this.m7605);
        }
    }

    private static class z1 {
        private final String m7602;
        private final com.aspose.html.rendering.pdf.z3 m7603;
        private final Url m7604;

        public final String m1533() {
            return this.m7602;
        }

        public final com.aspose.html.rendering.pdf.z3 m1534() {
            return this.m7603;
        }

        public final Url m1535() {
            return this.m7604;
        }

        public z1(com.aspose.html.rendering.pdf.z3 z3100, Url url, String string) {
            this.m7603 = z3100;
            this.m7602 = string;
            this.m7604 = url;
        }
    }
}

