/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.image;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.rendering.CharacterInfo;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.image.ImageFormat;
import com.aspose.html.rendering.image.ImageRenderingOptions;
import com.aspose.html.utils.IZ;
import com.aspose.html.utils.Jb;
import com.aspose.html.utils.Jc;
import com.aspose.html.utils.Jd;
import com.aspose.html.utils.Jg;
import com.aspose.html.utils.Qp;
import com.aspose.html.utils.Qq;
import com.aspose.html.utils.Qr;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.atN;
import com.aspose.html.utils.bY;
import com.aspose.html.utils.collections.generic.IGenericList;
import com.aspose.html.utils.dL;
import com.aspose.html.utils.dM;
import com.aspose.html.utils.dN;
import com.aspose.html.utils.dq;
import com.aspose.html.utils.ds;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Collections.Generic.Stack;
import com.aspose.html.utils.ms.System.Drawing.Bitmap;
import com.aspose.html.utils.ms.System.Drawing.Brush;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.GraphicsState;
import com.aspose.html.utils.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.utils.ms.System.Drawing.Font;
import com.aspose.html.utils.ms.System.Drawing.Graphics;
import com.aspose.html.utils.ms.System.Drawing.Image;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ImageAttributes;
import com.aspose.html.utils.ms.System.Drawing.Pen;
import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Region;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.Drawing.StringFormat;
import com.aspose.html.utils.ms.System.EnumExtensions;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Ref;

public class ImageDevice
extends Device<ImageGraphicContext, ImageRenderingOptions> {
    atN<IBrush, Brush> gMF;
    private dq eAr;
    private dL GZ;
    private final Jg gMG = new Jg();
    private dM cdK;
    private final Stack<GraphicsState> gMH = new Stack();
    private StringFormat cdM;
    private Qp gMI;

    protected ImageGraphicContext aaT() {
        return new ImageGraphicContext();
    }

    @Override
    public DeviceConfiguration Qt() {
        return this.aaV().Qt();
    }

    public Graphics getGraphics() {
        return this.aaV().abb();
    }

    public final Stream aaU() {
        return this.getOutputStream();
    }

    public final Qp aaV() {
        return this.gMI;
    }

    private void a(Qp qp2) {
        this.gMI = qp2;
    }

    public ImageDevice(ICreateStreamProvider iCreateStreamProvider) {
        this(new ImageRenderingOptions(), iCreateStreamProvider);
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, ICreateStreamProvider iCreateStreamProvider) {
        super(imageRenderingOptions, iCreateStreamProvider);
        this.rw();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, Stream stream) {
        super(imageRenderingOptions, stream);
        this.rw();
    }

    public ImageDevice(ImageRenderingOptions imageRenderingOptions, String string) {
        super(imageRenderingOptions, string);
        this.rw();
    }

    public ImageDevice(Stream stream) {
        this(new ImageRenderingOptions(), stream);
    }

    public ImageDevice(String string) {
        this(new ImageRenderingOptions(), string);
    }

    @Override
    public void addRect(RectangleF rectangleF) {
        this.gMG.y(rectangleF.Clone());
    }

    @Override
    public void beginDocument(Document document) {
        if (!Device.a.b(this)) {
            this.eAr = document.getContext().getService(dq.class);
            this.GZ = document.getContext().getService(dL.class);
        }
        super.beginDocument(document);
        this.gMG.QB();
        this.cdK = this.GZ.it();
    }

    @Override
    public boolean beginElement(Element element, RectangleF rectangleF) {
        return true;
    }

    @Override
    public void beginPage(SizeF sizeF) {
        super.beginPage(sizeF.Clone());
        this.aaV().beginPage(sizeF.Clone());
        IZ.a(this.eAr, this, sizeF.Clone());
    }

    @Override
    public void clip(int n2) {
        this.gMG.Qy().setFillMode(n2);
        this.getGraphics().setClip(new Region(this.gMG.Qy()), 1);
        this.gMG.QB();
    }

    @Override
    public void closePath() {
        this.gMG.QC();
    }

    private Pen ru() {
        Pen pen = new Pen(this.gMF.invoke(((ImageGraphicContext)this.getGraphicContext()).getStrokeBrush()));
        pen.setWidth(((ImageGraphicContext)this.getGraphicContext()).getLineWidth());
        pen.setStartCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setEndCap(((ImageGraphicContext)this.getGraphicContext()).getLineCap());
        pen.setLineJoin(((ImageGraphicContext)this.getGraphicContext()).getLineJoin());
        pen.setMiterLimit(((ImageGraphicContext)this.getGraphicContext()).getMiterLimit());
        pen.setDashOffset(((ImageGraphicContext)this.getGraphicContext()).getLineDashOffset() / pen.getWidth());
        pen.setDashStyle(((ImageGraphicContext)this.getGraphicContext()).getLineDashStyle());
        pen.setDashCap(GraphicContext.a.a(this.getGraphicContext()));
        if (pen.getDashStyle() == 5) {
            int n2 = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern().length;
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = ((ImageGraphicContext)this.getGraphicContext()).getLineDashPattern()[i2] / ((ImageGraphicContext)this.getGraphicContext()).getLineWidth();
            }
            pen.setDashPattern(fArray);
        }
        return pen;
    }

    private Qp aaW() {
        switch (((ImageRenderingOptions)this.getOptions()).getFormat()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Qq(this);
            }
            case 5: {
                return new Qr(this);
            }
        }
        throw new NotSupportedException();
    }

    @Override
    public void cubicBezierTo(PointF pointF, PointF pointF2, PointF pointF3) {
        this.gMG.f(pointF.Clone(), pointF2.Clone(), pointF3.Clone());
    }

    @Override
    public void dispose(boolean bl2) {
        if (this.aaV() != null && bl2) {
            this.aaV().dispose();
            this.a((Qp)null);
        }
        super.dispose(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(byte[] byArray, int n2, RectangleF rectangleF) {
        Image image = Image.fromStream(new MemoryStream(byArray));
        try {
            Integer n3 = 2;
            Integer[] integerArray = new Integer[]{n3};
            RectangleF rectangleF2 = image.getBounds(new Ref<Integer>(n3)).Clone();
            n3 = integerArray[0];
            PointF[] pointFArray = new PointF[]{rectangleF.getLocation(), new PointF(rectangleF.getX() + rectangleF.getWidth(), rectangleF.getY()), new PointF(rectangleF.getX(), rectangleF.getY() + rectangleF.getHeight())};
            ImageAttributes imageAttributes = null;
            this.getGraphics().drawImage(image, pointFArray, rectangleF2.Clone(), (int)n3, imageAttributes);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public void endDocument() {
        if (Device.a.b(this)) {
            this.cdK.dispose();
            this.cdK = null;
        }
        super.endDocument();
    }

    @Override
    public void endElement(Element element) {
    }

    @Override
    public void endPage() {
        this.aaV().endPage();
        super.endPage();
    }

    @Override
    public void fill(int n2) {
        this.fW(n2);
        this.gMG.QB();
    }

    private void fW(int n2) {
        Brush brush = this.gMF.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            this.gMG.Qy().setFillMode(n2);
            this.getGraphics().fillPath(brush, this.gMG.Qy());
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String string, PointF pointF) {
        if (((ImageGraphicContext)this.getGraphicContext()).getFontSize() < 0.1f) {
            return;
        }
        pointF.setY(pointF.getY() - ((ImageGraphicContext)this.getGraphicContext()).getFont().getAscent(((ImageGraphicContext)this.getGraphicContext()).getFontSize()));
        Brush brush = this.gMF.invoke(((ImageGraphicContext)this.getGraphicContext()).getFillBrush());
        try {
            Font font = this.GZ.a(Font.class, (dN)((bY)((Object)((ImageGraphicContext)this.getGraphicContext()).getFont())).fY(), ((ImageGraphicContext)this.getGraphicContext()).getFontSize(), ((ImageGraphicContext)this.getGraphicContext()).getFontStyle(), this.cdK);
            try {
                IGenericList<CharacterInfo> iGenericList = ((ImageGraphicContext)this.getGraphicContext()).getTextInfo().getCharacterInfos();
                for (int i2 = 0; i2 < iGenericList.size(); ++i2) {
                    this.getGraphics().drawString(Char.toString(string.charAt(i2)), font, brush, pointF.Clone(), this.cdM);
                    pointF.setX(pointF.getX() + (iGenericList.get_Item(i2).getWidth() + iGenericList.get_Item(i2).getOffset()));
                }
            }
            finally {
                if (font != null) {
                    font.dispose();
                }
            }
        }
        finally {
            if (brush != null) {
                brush.dispose();
            }
        }
    }

    @Override
    public void flush() {
        this.aaV().flush();
        this.gMH.clear();
        super.flush();
    }

    @Override
    public String getExtension() {
        return StringExtensions.concat(".", StringExtensions.toLowerInvariant(EnumExtensions.toString(ImageFormat.class, ((ImageRenderingOptions)this.getOptions()).getFormat())));
    }

    @Override
    public void initialize() {
        super.initialize();
        ((ImageGraphicContext)this.getGraphicContext()).c(this);
    }

    private void rw() {
        this.gMF = new atN<IBrush, Brush>(){

            public String aL() {
                return "Aspose.Html.Rendering.Image.ImageDevice.ToNativeBrush(Aspose.Html.Drawing.IBrush)";
            }

            public Brush c(IBrush iBrush) {
                return ImageDevice.this.a(iBrush);
            }

            @Override
            public /* synthetic */ Object invoke(Object object) {
                return this.c((IBrush)object);
            }
        };
        this.cdM = new StringFormat(StringFormat.getGenericTypographic());
        this.cdM.setFormatFlags(this.cdM.getFormatFlags() | 0x800);
        this.a(this.aaW());
    }

    @Override
    public void lineTo(PointF pointF) {
        this.gMG.r(pointF.Clone());
    }

    @Override
    public void moveTo(PointF pointF) {
        this.gMG.s(pointF.Clone());
    }

    @Override
    public void restoreGraphicContext() {
        this.getGraphics().restore(this.gMH.pop());
        super.restoreGraphicContext();
    }

    @Override
    public void saveGraphicContext() {
        this.gMH.push(this.getGraphics().save());
        super.saveGraphicContext();
    }

    @Override
    public void stroke() {
        this.aaX();
        this.gMG.QB();
    }

    @Override
    public void strokeAndFill(int n2) {
        this.fW(n2);
        this.aaX();
        this.gMG.QB();
    }

    private void aaX() {
        Pen pen = this.ru();
        try {
            this.getGraphics().drawPath(pen, this.gMG.Qy());
        }
        finally {
            if (pen != null) {
                pen.dispose();
            }
        }
    }

    @Override
    public void strokeText(String string, PointF pointF) {
    }

    Brush a(IBrush iBrush) {
        switch (iBrush.getType()) {
            case 1: {
                return this.eAr.a(Brush.class, (ds)((Jd)iBrush).fY());
            }
            case 2: {
                return this.eAr.a(Brush.class, (ds)((Jb)iBrush).fY());
            }
            case 0: {
                return this.eAr.a(Brush.class, (ds)((Jc)iBrush).fY());
            }
        }
        return null;
    }

    @Override
    public /* synthetic */ GraphicContext ry() {
        return this.aaT();
    }

    public static class ImageGraphicContext
    extends GraphicContext {
        private Matrix cdS;
        private ImageDevice gMK;

        public final ImageDevice aaY() {
            return this.gMK;
        }

        public final void c(ImageDevice imageDevice) {
            this.gMK = imageDevice;
        }

        @Override
        public Matrix getTransformationMatrix() {
            return this.cdS;
        }

        @Override
        public void setTransformationMatrix(Matrix matrix) {
            this.cdS = matrix;
            if (this.aaY().getGraphics() != null) {
                this.aaY().getGraphics().setTransform(matrix);
            }
        }

        @Override
        public GraphicContext deepClone() {
            ImageGraphicContext imageGraphicContext = (ImageGraphicContext)super.deepClone();
            if (this.cdS != null) {
                imageGraphicContext.cdS = this.cdS.deepClone();
            }
            return imageGraphicContext;
        }

        @Override
        public void transform(Matrix matrix) {
            if (this.getTransformationMatrix() != null) {
                this.getTransformationMatrix().multiply(matrix);
                if (this.aaY().getGraphics() != null) {
                    this.aaY().getGraphics().setTransform(this.cdS);
                }
            } else {
                this.setTransformationMatrix(matrix.deepClone());
            }
        }
    }

    public static class a {
        public static atN<IBrush, Brush> a(ImageDevice imageDevice) {
            return imageDevice.gMF;
        }

        public static Bitmap b(ImageDevice imageDevice) {
            return imageDevice.aaV().aaZ();
        }

        public static void a(ImageDevice imageDevice, atN<IBrush, Brush> atN2) {
            imageDevice.gMF = atN2;
        }
    }
}

