/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Drawing.KnownColor;
import com.aspose.html.utils.ms.System.Drawing.KnownColors;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Struct;

public class Color
extends Struct<Color> {
    private long e;
    short a;
    short b;
    String c;
    public static Color Empty = new Color();

    public java.awt.Color getNativeObject() {
        return new java.awt.Color(this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF, this.getA() & 0xFF);
    }

    static Color a(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.fromArgb(n2, n3, n4, n5).Clone();
        color.a = (short)5;
        color.c = KnownColors.getName(n6);
        color.b = (short)n6;
        return color;
    }

    static Color b(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.a(n2, n3, n4, n5, string, n6).Clone();
        color.a = (short)(color.a | 8);
        return color;
    }

    public String getName() {
        if (this.c == null) {
            this.c = this.isNamedColor() ? KnownColors.getName(this.b) : StringExtensions.format("{0:x}", this.toArgb());
        }
        return this.c;
    }

    public boolean isKnownColor() {
        return (this.a & 1) != 0;
    }

    public boolean isSystemColor() {
        return (this.a & 8) != 0;
    }

    public boolean isNamedColor() {
        return (this.a & 5) != 0;
    }

    long a() {
        if (this.e == 0L && this.isKnownColor()) {
            this.e = (long)KnownColors.fromKnownColor(this.b).toArgb() & 0xFFFFFFFFL;
        }
        return this.e;
    }

    void a(long l2) {
        this.e = l2;
    }

    public static Color fromArgb(int n2, int n3, int n4) {
        return Color.fromArgb(255, n2, n3, n4);
    }

    public static Color fromArgb(int n2, int n3, int n4, int n5) {
        Color.a(n2, n3, n4, n5);
        Color color = new Color();
        color.a = (short)2;
        color.a((n2 << 24) + (n3 << 16) + (n4 << 8) + n5);
        return color;
    }

    public int toArgb() {
        return (int)this.a();
    }

    public static Color fromArgb(int n2, Color color) {
        return Color.fromArgb(n2, color.getR() & 0xFF, color.getG() & 0xFF, color.getB() & 0xFF);
    }

    public static Color fromArgb(int n2) {
        return Color.fromArgb(n2 >>> 24 & 0xFF, n2 >>> 16 & 0xFF, n2 >>> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color fromKnownColor(int n2) {
        return KnownColors.fromKnownColor(n2);
    }

    public static Color fromName(String string) {
        try {
            int n2 = (int)Enum.parse(KnownColor.class, string, (Boolean)true);
            return KnownColors.fromKnownColor(n2);
        }
        catch (Exception exception) {
            Color color = Color.fromArgb(0, 0, 0, 0).Clone();
            color.c = string;
            color.a = (short)(color.a | 4);
            return color;
        }
    }

    public static boolean op_Equality(Color color, Color color2) {
        if (color.a() != color2.a()) {
            return false;
        }
        if (color.isNamedColor() != color2.isNamedColor()) {
            return false;
        }
        if (color.isSystemColor() != color2.isSystemColor()) {
            return false;
        }
        if (color.isEmpty() != color2.isEmpty()) {
            return false;
        }
        return !color.isNamedColor() || StringExtensions.equals(color.getName(), color2.getName());
    }

    public static boolean op_Inequality(Color color, Color color2) {
        return !Color.equals(color, color2);
    }

    public float getBrightness() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        return (float)((by3 & 0xFF) + (by2 & 0xFF)) / 510.0f;
    }

    public float getSaturation() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        if (by3 == by2) {
            return 0.0f;
        }
        int n2 = (by3 & 0xFF) + (by2 & 0xFF);
        if (n2 > 255) {
            n2 = 510 - n2;
        }
        return (float)((by3 & 0xFF) - (by2 & 0xFF)) / (float)n2;
    }

    public float getHue() {
        int n2 = this.getR() & 0xFF;
        int n3 = this.getG() & 0xFF;
        int n4 = this.getB() & 0xFF;
        byte by2 = (byte)Math.min(n2, Math.min(n3, n4));
        byte by3 = (byte)Math.max(n2, Math.max(n3, n4));
        if (by3 == by2) {
            return 0.0f;
        }
        float f2 = (by3 & 0xFF) - (by2 & 0xFF);
        float f3 = (float)((by3 & 0xFF) - n2) / f2;
        float f4 = (float)((by3 & 0xFF) - n3) / f2;
        float f5 = (float)((by3 & 0xFF) - n4) / f2;
        float f6 = 0.0f;
        if (n2 == (by3 & 0xFF)) {
            f6 = 60.0f * (6.0f + f5 - f4);
        }
        if (n3 == (by3 & 0xFF)) {
            f6 = 60.0f * (2.0f + f3 - f5);
        }
        if (n4 == (by3 & 0xFF)) {
            f6 = 60.0f * (4.0f + f4 - f3);
        }
        if (f6 > 360.0f) {
            f6 -= 360.0f;
        }
        return f6;
    }

    public int toKnownColor() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a == 0;
    }

    public byte getA() {
        return (byte)(this.a() >> 24 & 0xFFL);
    }

    public byte getR() {
        return (byte)(this.a() >> 16 & 0xFFL);
    }

    public byte getG() {
        return (byte)(this.a() >> 8 & 0xFFL);
    }

    public byte getB() {
        return (byte)(this.a() & 0xFFL);
    }

    public int hashCode() {
        int n2 = (int)(this.a() ^ this.a() >> 32 ^ (long)this.a ^ (long)(this.b >> 16));
        if (this.isNamedColor()) {
            n2 ^= this.getName().hashCode();
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Color [Empty]";
        }
        if (this.isNamedColor()) {
            return "Color [" + this.getName() + "]";
        }
        return StringExtensions.format("Color [A={0}, R={1}, G={2}, B={3}]", this.getA() & 0xFF, this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF);
    }

    private static void a(int n2, int n3, int n4) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "red");
        }
        if (n3 > 255 || n3 < 0) {
            throw Color.a(n3, "green");
        }
        if (n4 > 255 || n4 < 0) {
            throw Color.a(n4, "blue");
        }
    }

    private static ArgumentException a(int n2, String string) {
        return new ArgumentException(StringExtensions.format("'{0}' is not a valid value for '{1}'. '{1}' should be greater or equal to 0 and less than or equal to 255.", n2, string));
    }

    private static void a(int n2, int n3, int n4, int n5) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "alpha");
        }
        Color.a(n3, n4, n5);
    }

    public static Color getTransparent() {
        return KnownColors.fromKnownColor(27);
    }

    public static Color getAliceBlue() {
        return KnownColors.fromKnownColor(28);
    }

    public static Color getAntiqueWhite() {
        return KnownColors.fromKnownColor(29);
    }

    public static Color getAqua() {
        return KnownColors.fromKnownColor(30);
    }

    public static Color getAquamarine() {
        return KnownColors.fromKnownColor(31);
    }

    public static Color getAzure() {
        return KnownColors.fromKnownColor(32);
    }

    public static Color getBeige() {
        return KnownColors.fromKnownColor(33);
    }

    public static Color getBisque() {
        return KnownColors.fromKnownColor(34);
    }

    public static Color getBlack() {
        return KnownColors.fromKnownColor(35);
    }

    public static Color getBlanchedAlmond() {
        return KnownColors.fromKnownColor(36);
    }

    public static Color getBlue() {
        return KnownColors.fromKnownColor(37);
    }

    public static Color getBlueViolet() {
        return KnownColors.fromKnownColor(38);
    }

    public static Color getBrown() {
        return KnownColors.fromKnownColor(39);
    }

    public static Color getBurlyWood() {
        return KnownColors.fromKnownColor(40);
    }

    public static Color getCadetBlue() {
        return KnownColors.fromKnownColor(41);
    }

    public static Color getChartreuse() {
        return KnownColors.fromKnownColor(42);
    }

    public static Color getChocolate() {
        return KnownColors.fromKnownColor(43);
    }

    public static Color getCoral() {
        return KnownColors.fromKnownColor(44);
    }

    public static Color getCornflowerBlue() {
        return KnownColors.fromKnownColor(45);
    }

    public static Color getCornsilk() {
        return KnownColors.fromKnownColor(46);
    }

    public static Color getCrimson() {
        return KnownColors.fromKnownColor(47);
    }

    public static Color getCyan() {
        return KnownColors.fromKnownColor(48);
    }

    public static Color getDarkBlue() {
        return KnownColors.fromKnownColor(49);
    }

    public static Color getDarkCyan() {
        return KnownColors.fromKnownColor(50);
    }

    public static Color getDarkGoldenrod() {
        return KnownColors.fromKnownColor(51);
    }

    public static Color getDarkGray() {
        return KnownColors.fromKnownColor(52);
    }

    public static Color getDarkGreen() {
        return KnownColors.fromKnownColor(53);
    }

    public static Color getDarkKhaki() {
        return KnownColors.fromKnownColor(54);
    }

    public static Color getDarkMagenta() {
        return KnownColors.fromKnownColor(55);
    }

    public static Color getDarkOliveGreen() {
        return KnownColors.fromKnownColor(56);
    }

    public static Color getDarkOrange() {
        return KnownColors.fromKnownColor(57);
    }

    public static Color getDarkOrchid() {
        return KnownColors.fromKnownColor(58);
    }

    public static Color getDarkRed() {
        return KnownColors.fromKnownColor(59);
    }

    public static Color getDarkSalmon() {
        return KnownColors.fromKnownColor(60);
    }

    public static Color getDarkSeaGreen() {
        return KnownColors.fromKnownColor(61);
    }

    public static Color getDarkSlateBlue() {
        return KnownColors.fromKnownColor(62);
    }

    public static Color getDarkSlateGray() {
        return KnownColors.fromKnownColor(63);
    }

    public static Color getDarkTurquoise() {
        return KnownColors.fromKnownColor(64);
    }

    public static Color getDarkViolet() {
        return KnownColors.fromKnownColor(65);
    }

    public static Color getDeepPink() {
        return KnownColors.fromKnownColor(66);
    }

    public static Color getDeepSkyBlue() {
        return KnownColors.fromKnownColor(67);
    }

    public static Color getDimGray() {
        return KnownColors.fromKnownColor(68);
    }

    public static Color getDodgerBlue() {
        return KnownColors.fromKnownColor(69);
    }

    public static Color getFirebrick() {
        return KnownColors.fromKnownColor(70);
    }

    public static Color getFloralWhite() {
        return KnownColors.fromKnownColor(71);
    }

    public static Color getForestGreen() {
        return KnownColors.fromKnownColor(72);
    }

    public static Color getFuchsia() {
        return KnownColors.fromKnownColor(73);
    }

    public static Color getGainsboro() {
        return KnownColors.fromKnownColor(74);
    }

    public static Color getGhostWhite() {
        return KnownColors.fromKnownColor(75);
    }

    public static Color getGold() {
        return KnownColors.fromKnownColor(76);
    }

    public static Color getGoldenrod() {
        return KnownColors.fromKnownColor(77);
    }

    public static Color getGray() {
        return KnownColors.fromKnownColor(78);
    }

    public static Color getGreen() {
        return KnownColors.fromKnownColor(79);
    }

    public static Color getGreenYellow() {
        return KnownColors.fromKnownColor(80);
    }

    public static Color getHoneydew() {
        return KnownColors.fromKnownColor(81);
    }

    public static Color getHotPink() {
        return KnownColors.fromKnownColor(82);
    }

    public static Color getIndianRed() {
        return KnownColors.fromKnownColor(83);
    }

    public static Color getIndigo() {
        return KnownColors.fromKnownColor(84);
    }

    public static Color getIvory() {
        return KnownColors.fromKnownColor(85);
    }

    public static Color getKhaki() {
        return KnownColors.fromKnownColor(86);
    }

    public static Color getLavender() {
        return KnownColors.fromKnownColor(87);
    }

    public static Color getLavenderBlush() {
        return KnownColors.fromKnownColor(88);
    }

    public static Color getLawnGreen() {
        return KnownColors.fromKnownColor(89);
    }

    public static Color getLemonChiffon() {
        return KnownColors.fromKnownColor(90);
    }

    public static Color getLightBlue() {
        return KnownColors.fromKnownColor(91);
    }

    public static Color getLightCoral() {
        return KnownColors.fromKnownColor(92);
    }

    public static Color getLightCyan() {
        return KnownColors.fromKnownColor(93);
    }

    public static Color getLightGoldenrodYellow() {
        return KnownColors.fromKnownColor(94);
    }

    public static Color getLightGreen() {
        return KnownColors.fromKnownColor(96);
    }

    public static Color getLightGray() {
        return KnownColors.fromKnownColor(95);
    }

    public static Color getLightPink() {
        return KnownColors.fromKnownColor(97);
    }

    public static Color getLightSalmon() {
        return KnownColors.fromKnownColor(98);
    }

    public static Color getLightSeaGreen() {
        return KnownColors.fromKnownColor(99);
    }

    public static Color getLightSkyBlue() {
        return KnownColors.fromKnownColor(100);
    }

    public static Color getLightSlateGray() {
        return KnownColors.fromKnownColor(101);
    }

    public static Color getLightSteelBlue() {
        return KnownColors.fromKnownColor(102);
    }

    public static Color getLightYellow() {
        return KnownColors.fromKnownColor(103);
    }

    public static Color getLime() {
        return KnownColors.fromKnownColor(104);
    }

    public static Color getLimeGreen() {
        return KnownColors.fromKnownColor(105);
    }

    public static Color getLinen() {
        return KnownColors.fromKnownColor(106);
    }

    public static Color getMagenta() {
        return KnownColors.fromKnownColor(107);
    }

    public static Color getMaroon() {
        return KnownColors.fromKnownColor(108);
    }

    public static Color getMediumAquamarine() {
        return KnownColors.fromKnownColor(109);
    }

    public static Color getMediumBlue() {
        return KnownColors.fromKnownColor(110);
    }

    public static Color getMediumOrchid() {
        return KnownColors.fromKnownColor(111);
    }

    public static Color getMediumPurple() {
        return KnownColors.fromKnownColor(112);
    }

    public static Color getMediumSeaGreen() {
        return KnownColors.fromKnownColor(113);
    }

    public static Color getMediumSlateBlue() {
        return KnownColors.fromKnownColor(114);
    }

    public static Color getMediumSpringGreen() {
        return KnownColors.fromKnownColor(115);
    }

    public static Color getMediumTurquoise() {
        return KnownColors.fromKnownColor(116);
    }

    public static Color getMediumVioletRed() {
        return KnownColors.fromKnownColor(117);
    }

    public static Color getMidnightBlue() {
        return KnownColors.fromKnownColor(118);
    }

    public static Color getMintCream() {
        return KnownColors.fromKnownColor(119);
    }

    public static Color getMistyRose() {
        return KnownColors.fromKnownColor(120);
    }

    public static Color getMoccasin() {
        return KnownColors.fromKnownColor(121);
    }

    public static Color getNavajoWhite() {
        return KnownColors.fromKnownColor(122);
    }

    public static Color getNavy() {
        return KnownColors.fromKnownColor(123);
    }

    public static Color getOldLace() {
        return KnownColors.fromKnownColor(124);
    }

    public static Color getOlive() {
        return KnownColors.fromKnownColor(125);
    }

    public static Color getOliveDrab() {
        return KnownColors.fromKnownColor(126);
    }

    public static Color getOrange() {
        return KnownColors.fromKnownColor(127);
    }

    public static Color getOrangeRed() {
        return KnownColors.fromKnownColor(128);
    }

    public static Color getOrchid() {
        return KnownColors.fromKnownColor(129);
    }

    public static Color getPaleGoldenrod() {
        return KnownColors.fromKnownColor(130);
    }

    public static Color getPaleGreen() {
        return KnownColors.fromKnownColor(131);
    }

    public static Color getPaleTurquoise() {
        return KnownColors.fromKnownColor(132);
    }

    public static Color getPaleVioletRed() {
        return KnownColors.fromKnownColor(133);
    }

    public static Color getPapayaWhip() {
        return KnownColors.fromKnownColor(134);
    }

    public static Color getPeachPuff() {
        return KnownColors.fromKnownColor(135);
    }

    public static Color getPeru() {
        return KnownColors.fromKnownColor(136);
    }

    public static Color getPink() {
        return KnownColors.fromKnownColor(137);
    }

    public static Color getPlum() {
        return KnownColors.fromKnownColor(138);
    }

    public static Color getPowderBlue() {
        return KnownColors.fromKnownColor(139);
    }

    public static Color getPurple() {
        return KnownColors.fromKnownColor(140);
    }

    public static Color getRed() {
        return KnownColors.fromKnownColor(141);
    }

    public static Color getRosyBrown() {
        return KnownColors.fromKnownColor(142);
    }

    public static Color getRoyalBlue() {
        return KnownColors.fromKnownColor(143);
    }

    public static Color getSaddleBrown() {
        return KnownColors.fromKnownColor(144);
    }

    public static Color getSalmon() {
        return KnownColors.fromKnownColor(145);
    }

    public static Color getSandyBrown() {
        return KnownColors.fromKnownColor(146);
    }

    public static Color getSeaGreen() {
        return KnownColors.fromKnownColor(147);
    }

    public static Color getSeaShell() {
        return KnownColors.fromKnownColor(148);
    }

    public static Color getSienna() {
        return KnownColors.fromKnownColor(149);
    }

    public static Color getSilver() {
        return KnownColors.fromKnownColor(150);
    }

    public static Color getSkyBlue() {
        return KnownColors.fromKnownColor(151);
    }

    public static Color getSlateBlue() {
        return KnownColors.fromKnownColor(152);
    }

    public static Color getSlateGray() {
        return KnownColors.fromKnownColor(153);
    }

    public static Color getSnow() {
        return KnownColors.fromKnownColor(154);
    }

    public static Color getSpringGreen() {
        return KnownColors.fromKnownColor(155);
    }

    public static Color getSteelBlue() {
        return KnownColors.fromKnownColor(156);
    }

    public static Color getTan() {
        return KnownColors.fromKnownColor(157);
    }

    public static Color getTeal() {
        return KnownColors.fromKnownColor(158);
    }

    public static Color getThistle() {
        return KnownColors.fromKnownColor(159);
    }

    public static Color getTomato() {
        return KnownColors.fromKnownColor(160);
    }

    public static Color getTurquoise() {
        return KnownColors.fromKnownColor(161);
    }

    public static Color getViolet() {
        return KnownColors.fromKnownColor(162);
    }

    public static Color getWheat() {
        return KnownColors.fromKnownColor(163);
    }

    public static Color getWhite() {
        return KnownColors.fromKnownColor(164);
    }

    public static Color getWhiteSmoke() {
        return KnownColors.fromKnownColor(165);
    }

    public static Color getYellow() {
        return KnownColors.fromKnownColor(166);
    }

    public static Color getYellowGreen() {
        return KnownColors.fromKnownColor(167);
    }

    @Override
    public void CloneTo(Color color) {
        color.e = this.e;
        color.a = this.a;
        color.b = this.b;
        color.c = this.c;
    }

    @Override
    public Color Clone() {
        Color color = new Color();
        this.CloneTo(color);
        return color;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Color color) {
        return color.e == this.e && color.a == this.a && color.b == this.b && ObjectExtensions.equals(color.c, this.c);
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        return this.a((Color)object);
    }

    public static boolean equals(Color color, Color color2) {
        return color.equals(color2);
    }

    public static java.awt.Color toJava(Color color) {
        if (color == null) {
            return null;
        }
        return color.getNativeObject();
    }

    public static Color fromJava(java.awt.Color color) {
        if (color == null) {
            return new Color();
        }
        return Color.fromArgb(color.getRGB());
    }

    public static final class ColorType {
        public static final short Empty = 0;
        public static final short Known = 1;
        public static final short ARGB = 2;
        public static final short Named = 4;
        public static final short System = 8;

        static {
            Enum.register(new Enum.FlaggedEnum((Class)ColorType.class, Short.class){
                {
                    this.addConstant("Empty", 0L);
                    this.addConstant("Known", 1L);
                    this.addConstant("ARGB", 2L);
                    this.addConstant("Named", 4L);
                    this.addConstant("System", 8L);
                }
            });
        }
    }
}

