/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing.Imaging;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Drawing.Color;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ColorMap;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ColorMatrix;
import com.aspose.html.utils.ms.System.Drawing.Imaging.ColorPalette;
import com.aspose.html.utils.ms.System.ICloneable;

public final class ImageAttributes
implements IDisposable,
ICloneable {
    private ImageAttribute a;
    private ImageAttribute b;
    private ImageAttribute c;
    private ImageAttribute d;
    private ImageAttribute e;
    public int wrapMode = 4;
    public Color color;

    @Override
    public void dispose() {
    }

    @Override
    public Object deepClone() {
        ImageAttributes imageAttributes = new ImageAttributes();
        imageAttributes.a = this.a != null ? this.a.Clone() : null;
        imageAttributes.b = this.b != null ? this.b.Clone() : null;
        imageAttributes.c = this.c != null ? this.c.Clone() : null;
        imageAttributes.d = this.d != null ? this.d.Clone() : null;
        imageAttributes.e = this.e != null ? this.e.Clone() : null;
        imageAttributes.color = this.color != null ? this.color.Clone() : null;
        imageAttributes.wrapMode = this.wrapMode;
        return imageAttributes;
    }

    public ImageAttribute getAttribute(int n2) {
        ImageAttribute imageAttribute = this.a != null ? this.a : new ImageAttribute();
        switch (n2) {
            case 0: {
                this.a = imageAttribute.Clone();
                return this.a;
            }
            case 1: {
                if (this.b == null) {
                    this.b = imageAttribute.Clone();
                }
                return this.b;
            }
            case 2: {
                if (this.c == null) {
                    this.c = imageAttribute.Clone();
                }
                return this.c;
            }
            case 3: {
                if (this.d == null) {
                    this.d = imageAttribute.Clone();
                }
                return this.d;
            }
            case 4: {
                if (this.e == null) {
                    this.e = imageAttribute.Clone();
                }
                return this.e;
            }
        }
        return null;
    }

    ImageAttribute a(int n2) {
        ImageAttribute imageAttribute = this.a != null ? this.a : new ImageAttribute();
        switch (n2) {
            case 0: {
                this.a = imageAttribute.Clone();
                return this.a;
            }
            case 1: {
                if (this.b == null) {
                    return imageAttribute.Clone();
                }
                return this.b;
            }
            case 2: {
                if (this.c == null) {
                    return imageAttribute.Clone();
                }
                return this.c;
            }
            case 3: {
                if (this.d == null) {
                    return imageAttribute.Clone();
                }
                return this.d;
            }
            case 4: {
                if (this.e == null) {
                    return imageAttribute.Clone();
                }
                return this.e;
            }
        }
        return null;
    }

    public void setColorMatrix(ColorMatrix colorMatrix) {
        this.setColorMatrix(colorMatrix, 0, 0);
    }

    public void setColorMatrix(ColorMatrix colorMatrix, int n2) {
        this.setColorMatrix(colorMatrix, n2, 0);
    }

    public void setColorMatrix(ColorMatrix colorMatrix, int n2, int n3) {
        this.getAttribute((int)n3).clrMatrix = colorMatrix;
        this.getAttribute((int)n3).clrMatrixFlag = n2;
    }

    public void clearColorMatrix() {
        this.clearColorMatrix(0);
    }

    public void clearColorMatrix(int n2) {
        ColorMatrix colorMatrix;
        this.getAttribute((int)n2).clrMatrix = colorMatrix = new ColorMatrix();
    }

    public void setColorMatrices(ColorMatrix colorMatrix, ColorMatrix colorMatrix2) {
        this.setColorMatrices(colorMatrix, colorMatrix2, 0, 0);
    }

    public void setColorMatrices(ColorMatrix colorMatrix, ColorMatrix colorMatrix2, int n2) {
        this.setColorMatrices(colorMatrix, colorMatrix2, n2, 0);
    }

    public void setColorMatrices(ColorMatrix colorMatrix, ColorMatrix colorMatrix2, int n2, int n3) {
        this.getAttribute((int)n3).clrMatrix = colorMatrix;
        this.getAttribute((int)n3).gMatrix = colorMatrix2;
        this.getAttribute((int)n3).clrMatrixFlag = n2;
    }

    public void setThreshold(float f2) {
        this.setThreshold(f2, 0);
    }

    public void setThreshold(float f2, int n2) {
        ImageAttribute imageAttribute = this.getAttribute(n2);
        imageAttribute.thresh = f2;
        imageAttribute.a = true;
    }

    public void clearThreshold() {
        this.clearThreshold(0);
    }

    public void clearThreshold(int n2) {
        ImageAttribute imageAttribute = this.getAttribute(n2);
        imageAttribute.thresh = 1.0f;
        imageAttribute.a = false;
    }

    public void setGamma(float f2) {
        this.setGamma(f2, 0);
    }

    public void setGamma(float f2, int n2) {
        if (f2 <= 0.0f) {
            throw new ArgumentException();
        }
        ImageAttribute imageAttribute = this.getAttribute(n2);
        imageAttribute.gamma = f2;
    }

    public void clearGamma() {
        this.clearGamma(0);
    }

    public void clearGamma(int n2) {
        this.a((int)n2).gamma = 1.0f;
    }

    public void setNoOp() {
        this.setNoOp(0);
    }

    public void setNoOp(int n2) {
        this.getAttribute((int)n2).bNoOp = true;
    }

    public void clearNoOp() {
        this.clearNoOp(0);
    }

    public void clearNoOp(int n2) {
        this.getAttribute((int)n2).bNoOp = false;
    }

    public void setColorKey(Color color, Color color2) {
        this.setColorKey(color.Clone(), color2.Clone(), 0);
    }

    public void setColorKey(Color color, Color color2, int n2) {
        if ((color.getR() & 0xFF) > (color2.getR() & 0xFF) || (color.getG() & 0xFF) > (color2.getG() & 0xFF) || (color.getB() & 0xFF) > (color2.getB() & 0xFF)) {
            throw new ArgumentException();
        }
        color.CloneTo(this.getAttribute((int)n2).clrLow);
        color2.CloneTo(this.getAttribute((int)n2).clrHigh);
    }

    public void clearColorKey() {
        this.clearColorKey(0);
    }

    public void clearColorKey(int n2) {
    }

    public void setOutputChannel(int n2) {
        this.setOutputChannel(n2, 0);
    }

    public void setOutputChannel(int n2, int n3) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new ArgumentException();
        }
        if (n3 == 5 || n3 == 6) {
            throw new ArgumentException();
        }
        this.getAttribute((int)n3).clrChannelFlags = n2;
    }

    public void clearOutputChannel() {
        this.clearOutputChannel(0);
    }

    public void clearOutputChannel(int n2) {
        if (n2 == 5 || n2 == 6) {
            throw new ArgumentException();
        }
        this.getAttribute((int)n2).clrChannelFlags = 0;
    }

    public void setOutputChannelColorProfile(String string) {
        this.setOutputChannelColorProfile(string, 0);
    }

    public void setOutputChannelColorProfile(String string, int n2) {
        this.getAttribute((int)n2).clrProfileFilename = string;
    }

    public void clearOutputChannelColorProfile() {
        this.clearOutputChannelColorProfile(0);
    }

    public void clearOutputChannelColorProfile(int n2) {
        this.getAttribute((int)n2).clrProfileFilename = null;
    }

    public void setRemapTable(ColorMap[] colorMapArray) {
        this.setRemapTable(colorMapArray, 0);
    }

    public void setRemapTable(ColorMap[] colorMapArray, int n2) {
        this.getAttribute((int)n2).clrMap = colorMapArray;
    }

    public void clearRemapTable() {
        this.clearRemapTable(0);
    }

    public void clearRemapTable(int n2) {
        this.getAttribute((int)n2).clrMap = null;
    }

    public void setBrushRemapTable(ColorMap[] colorMapArray) {
        this.setRemapTable(colorMapArray, 2);
    }

    public void clearBrushRemapTable() {
        this.clearRemapTable(2);
    }

    public void setWrapMode(int n2) {
        this.setWrapMode(n2, new Color(), false);
    }

    public void setWrapMode(int n2, Color color) {
        this.setWrapMode(n2, color.Clone(), false);
    }

    public void setWrapMode(int n2, Color color, boolean bl2) {
        this.wrapMode = n2;
        if (this.color == null) {
            this.color = color.Clone();
        } else {
            color.CloneTo(this.color);
        }
        this.getAttribute((int)0).bClamp = bl2;
    }

    public void getAdjustedPalette(ColorPalette colorPalette, int n2) {
        if (!colorPalette.a()) {
            throw new ArgumentException();
        }
        if (n2 == 6 || n2 == 0 || n2 == 5) {
            throw new ArgumentException();
        }
        ImageAttribute imageAttribute = this.a(n2);
        imageAttribute.clrPalette = colorPalette;
        this.a(imageAttribute);
        this.b(imageAttribute);
        this.c(imageAttribute);
    }

    private void a(ImageAttribute imageAttribute) {
        if (!imageAttribute.clrLow.isEmpty() && !imageAttribute.clrHigh.isEmpty()) {
            for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
                Color color = imageAttribute.clrPalette.getEntries()[i2];
                if ((color.getB() & 0xFF) < (imageAttribute.clrLow.getB() & 0xFF) || (color.getB() & 0xFF) > (imageAttribute.clrHigh.getB() & 0xFF) || (color.getG() & 0xFF) < (imageAttribute.clrLow.getG() & 0xFF) || (color.getG() & 0xFF) > (imageAttribute.clrHigh.getG() & 0xFF) || (color.getR() & 0xFF) < (imageAttribute.clrLow.getR() & 0xFF) || (color.getR() & 0xFF) > (imageAttribute.clrHigh.getR() & 0xFF)) continue;
                imageAttribute.clrPalette.a(i2, Color.fromArgb(0, color.getR() & 0xFF, color.getG() & 0xFF, color.getB() & 0xFF));
            }
        }
    }

    private void b(ImageAttribute imageAttribute) {
        if (imageAttribute.gamma != 1.0f && imageAttribute.gamma > 0.0f) {
            for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
                Color color = imageAttribute.clrPalette.getEntries()[i2];
                imageAttribute.clrPalette.a(i2, Color.fromArgb(color.getA() & 0xFF, (int)(Math.round(255.0 * Math.pow((float)(color.getR() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL), (int)(Math.round(255.0 * Math.pow((float)(color.getG() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL), (int)(Math.round(255.0 * Math.pow((float)(color.getB() & 0xFF) / 255.0f, imageAttribute.gamma)) & 0xFFL)));
            }
        }
    }

    private void c(ImageAttribute imageAttribute) {
        if (!imageAttribute.a) {
            return;
        }
        float f2 = imageAttribute.thresh;
        float f3 = Math.abs(f2);
        float f4 = f3 - (float)((int)f3);
        boolean bl2 = false;
        if (f2 < 0.0f) {
            if (f4 == 0.0f) {
                f2 = 0.0f;
                bl2 = true;
            } else {
                f2 = 1.0f - f4;
            }
        }
        if (f2 > 1.0f) {
            f2 = f4 == 1.0f ? 1.0f : f4;
        }
        float f5 = f2 < 1.0f ? f2 * 256.0f : f2 * 255.0f;
        for (int i2 = 0; i2 < imageAttribute.clrPalette.getEntries().length; ++i2) {
            Color color = imageAttribute.clrPalette.getEntries()[i2];
            int n2 = color.getR() & 0xFF;
            int n3 = color.getG() & 0xFF;
            int n4 = color.getB() & 0xFF;
            imageAttribute.clrPalette.a(i2, Color.fromArgb(color.getA() & 0xFF, n2 == 0 && bl2 ? 0 : (n2 == 1 ? 255 : ((float)n2 < f5 ? 0 : 255)), n3 == 0 && bl2 ? 0 : (n3 == 1 ? 255 : ((float)n3 < f5 ? 0 : 255)), n4 == 0 && bl2 ? 0 : (n4 == 1 ? 255 : ((float)n4 < f5 ? 0 : 255))));
        }
    }

    public final class ImageAttribute {
        public ColorMatrix clrMatrix;
        public int clrMatrixFlag;
        public ColorMatrix gMatrix;
        public float thresh;
        boolean a = false;
        public float gamma;
        public int clrChannelFlags;
        public String clrProfileFilename;
        public Color clrLow = new Color();
        public Color clrHigh = new Color();
        public ColorMap[] clrMap;
        public boolean bClamp;
        public ColorPalette clrPalette;
        public boolean bNoOp;

        public ImageAttribute Clone() {
            ImageAttribute imageAttribute = new ImageAttribute();
            imageAttribute.clrMatrix = this.clrMatrix;
            imageAttribute.clrMatrixFlag = this.clrMatrixFlag;
            imageAttribute.gMatrix = this.gMatrix;
            imageAttribute.thresh = this.thresh;
            imageAttribute.a = this.a;
            imageAttribute.gamma = this.gamma;
            imageAttribute.clrChannelFlags = this.clrChannelFlags;
            imageAttribute.clrProfileFilename = this.clrProfileFilename;
            this.clrLow.CloneTo(imageAttribute.clrLow);
            this.clrHigh.CloneTo(imageAttribute.clrHigh);
            imageAttribute.clrMap = this.clrMap;
            imageAttribute.bClamp = this.bClamp;
            imageAttribute.clrPalette = this.clrPalette;
            imageAttribute.bNoOp = this.bNoOp;
            return imageAttribute;
        }
    }
}

