/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Int16Extensions;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Int64Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.SByteExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Type;
import com.aspose.html.utils.ms.System.UInt16Extensions;
import com.aspose.html.utils.ms.System.UInt32Extensions;
import com.aspose.html.utils.ms.System.UInt64Extensions;
import com.aspose.html.utils.ms.System.ValueType;
import com.aspose.html.utils.ms.lang.Operators;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class Enum
extends ValueType<Enum> {
    public static final char[] EnumSeparatorCharArray = new char[]{','};
    private static volatile transient EnumMap a = new EnumMap();

    public static void register(AbstractEnum abstractEnum) {
        a.put(abstractEnum.getEnumClass(), abstractEnum);
    }

    private static AbstractEnum a(Class<?> clazz) {
        if (!a.containsKey(clazz)) {
            try {
                Class.forName(clazz.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!a.containsKey(clazz)) {
                throw new IllegalStateException();
            }
        }
        return (AbstractEnum)a.get(clazz);
    }

    private static AbstractEnum.ConstantMap b(Class<?> clazz) {
        AbstractEnum abstractEnum = Enum.a(clazz);
        return abstractEnum.constants;
    }

    public static String getName(Class<?> clazz, long l2) {
        return Enum.a(clazz).getName(l2);
    }

    public static long getValue(Class<?> clazz, String string) {
        return Enum.a(clazz).getValue(string, false);
    }

    public long get_Value() {
        throw new InvalidOperationException("should be overrided");
    }

    public String get_Caption() {
        throw new InvalidOperationException("should be overrided");
    }

    public static Collection<String> getNames(Class<?> clazz) {
        return Enum.b(clazz).values();
    }

    public static String[] getNames(Type type) {
        return Enum.b(type.getJavaClass()).values().toArray(new String[0]);
    }

    public static Array getValues(Type type) {
        Set set = Enum.b(type.getJavaClass()).keySet();
        return Array.boxing(set.toArray(new Long[set.size()]));
    }

    public static boolean isDefined(Class<?> clazz, long l2) {
        return Enum.b(clazz).containsKey(l2);
    }

    public static boolean isDefined(Type type, long l2) {
        return Enum.isDefined(type.getJavaClass(), l2);
    }

    public static boolean isDefined(Type type, String string) {
        return Enum.b(type.getJavaClass()).containsValue(string);
    }

    public static boolean isDefined(Type type, Object object) {
        if (object instanceof String) {
            return Enum.isDefined(type, (String)object);
        }
        if (object instanceof Long) {
            return Enum.isDefined(type, (long)((Long)object));
        }
        if (object instanceof Integer) {
            return Enum.isDefined(type, ((Integer)object).longValue());
        }
        if (object instanceof Short) {
            return Enum.isDefined(type, ((Short)object).longValue());
        }
        if (object instanceof Byte) {
            return Enum.isDefined(type, ((Byte)object).longValue());
        }
        return false;
    }

    public static String format(Class<?> clazz, long l2, String string) {
        throw new NotImplementedException();
    }

    public static String format(Type type, Object object, String string) {
        if (type == null) {
            throw new ArgumentNullException("enumType");
        }
        if (!type.isEnum()) {
            throw new ArgumentException("Type provided must be an Enum.", "enumType");
        }
        if (object == null) {
            throw new ArgumentNullException("value");
        }
        if (string == null) {
            throw new ArgumentNullException("format");
        }
        Type type2 = Operators.typeOf(object.getClass());
        Type type3 = Enum.getUnderlyingType(type);
        long l2 = 0L;
        if (type2.isEnum()) {
            if (type2 != type) {
                throw new ArgumentException(StringExtensions.format("Object must be the same type as the enum. The type passed in was '{0}'; the enum type was '{1}'.", type2.toString(), type.toString()));
            }
            if (type2.getBaseType().equals(Operators.typeOf(ObjectEnum.class))) {
                l2 = ((Enum)object).get_Value();
            } else if (type2.equals(Operators.typeOf(Long.class)) || type2.equals(Operators.typeOf(Long.TYPE))) {
                l2 = (Long)object;
            } else if (type2.equals(Operators.typeOf(String.class))) {
                l2 = Enum.getValue(type.getJavaClass(), (String)object);
            }
        } else {
            if (type2 != type3) {
                throw new ArgumentException(StringExtensions.format("Enum underlying type and the object must be same type or object. Type passed in was '{0}'; the enum underlying type was '{1}'.", type2.toString(), type3.toString()));
            }
            l2 = Convert.toInt64(object);
        }
        if (string.length() != 1) {
            throw new FormatException("Format String can be only \"G\", \"g\", \"X\", \"x\", \"F\", \"f\", \"D\" or \"d\".");
        }
        char c2 = string.charAt(0);
        switch (c2) {
            case 'D': 
            case 'd': {
                return Int64Extensions.toString(l2);
            }
            case 'X': 
            case 'x': {
                return Enum.a(l2);
            }
            case 'F': 
            case 'G': 
            case 'f': 
            case 'g': {
                return Enum.getName(type.getJavaClass(), l2);
            }
        }
        throw new FormatException("Format String can be only \"G\", \"g\", \"X\", \"x\", \"F\", \"f\", \"D\" or \"d\".");
    }

    private static String a(Object object) {
        switch (Type.getTypeCode(Operators.typeOf(object.getClass()))) {
            case 5: {
                byte by2 = (Byte)object;
                return SByteExtensions.toString(by2, "X2", null);
            }
            case 6: {
                byte by3 = (Byte)object;
                return ByteExtensions.toString(by3, "X2", null);
            }
            case 7: {
                short s2 = (Short)object;
                return Int16Extensions.toString(s2, "X4", null);
            }
            case 8: {
                int n2 = (Integer)object;
                return UInt16Extensions.toString(n2, "X4", null);
            }
            case 9: {
                int n3 = (Integer)object;
                return Int32Extensions.toString(n3, "X8", null);
            }
            case 10: {
                long l2 = (Long)object;
                return UInt32Extensions.toString(l2, "X8", null);
            }
            case 11: {
                long l3 = (Long)object;
                return Int64Extensions.toString(l3, "X16", null);
            }
            case 12: {
                long l4 = (Long)object;
                return UInt64Extensions.toString(l4, "X16", null);
            }
        }
        throw new InvalidOperationException("Unknown enum type.");
    }

    public static long parse(Class<?> clazz, String string) {
        return Enum.parse(clazz, string, (Boolean)false);
    }

    public static long parse(Class<?> clazz, String string, Boolean bl2) {
        Object object;
        String[] stringArray = StringExtensions.split(string, EnumSeparatorCharArray);
        if (stringArray.length == 1 && Int64Extensions.tryParse(string, 7, null, (long[])(object = new long[1]))) {
            if (object[0] > Integer.MAX_VALUE || object[0] < Integer.MIN_VALUE) {
                throw new OverflowException();
            }
            return object[0];
        }
        object = Enum.a(clazz);
        long l2 = 0L;
        for (String string2 : stringArray) {
            l2 += ((AbstractEnum)object).getValue(string2.trim(), bl2);
        }
        return l2;
    }

    public static long parse(Type type, String string) {
        return Enum.parse(type.getJavaClass(), string);
    }

    public static long parse(Type type, String string, Boolean bl2) {
        return Enum.parse(type.getJavaClass(), string, bl2);
    }

    public static Class<? extends Number> getUnderlyingType(Class<?> clazz) {
        AbstractEnum abstractEnum = Enum.a(clazz);
        return abstractEnum.getUnderlineClass();
    }

    public static Type getUnderlyingType(Type type) {
        return Operators.typeOf(Enum.getUnderlyingType(type.getJavaClass()));
    }

    public static Object toObject(Type type, Object object) {
        throw new NotImplementedException();
    }

    @Override
    public void CloneTo(Enum enum_) {
    }

    @Override
    public Enum Clone() {
        return this;
    }

    protected static class EnumMap
    extends HashMap<Class<?>, AbstractEnum> {
        protected EnumMap() {
        }
    }

    public static abstract class ObjectEnum
    extends Enum {
        private long a;
        private String b;

        protected ObjectEnum(long l2, String string) {
            this.a = l2;
            this.b = string;
        }

        @Override
        public final long get_Value() {
            return this.a;
        }

        @Override
        public final String get_Caption() {
            return this.b;
        }

        public static <T extends ObjectEnum> T getEnum(Class<T> clazz, long l2) {
            String string = ObjectEnum.getName(clazz, l2);
            try {
                Constructor<T> constructor = clazz.getConstructor(Long.TYPE, String.class);
                return (T)((ObjectEnum)constructor.newInstance(l2, string));
            }
            catch (Exception exception) {
                throw new InvalidOperationException();
            }
        }

        public <T extends ObjectEnum> T OR(T t2) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() | t2.get_Value());
        }

        public <T extends ObjectEnum> T XOR(T t2) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() ^ t2.get_Value());
        }

        public <T extends ObjectEnum> T AND(T t2) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() & t2.get_Value());
        }

        public int hashCode() {
            return (int)this.a;
        }

        public boolean equals(Object object) {
            if (object instanceof ObjectEnum) {
                ObjectEnum objectEnum = (ObjectEnum)object;
                return objectEnum.a == this.a && StringExtensions.equals(objectEnum.b, this.b);
            }
            return false;
        }
    }

    public static abstract class FlaggedEnum
    extends AbstractEnum {
        public FlaggedEnum(Class<?> clazz, Class<? extends Number> clazz2) {
            super(clazz, clazz2);
        }

        @Override
        protected String getName(long l2) {
            Object object;
            if (l2 == 0L) {
                return this.constants.containsKey(l2) ? (String)this.constants.get(l2) : Long.toString(l2);
            }
            if (this.constants.containsKey(l2)) {
                return (String)this.constants.get(l2);
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Map.Entry object22 : this.constants.entrySet()) {
                object = (Long)object22.getKey();
                String string = (String)object22.getValue();
                if ((Long)object == 0L || (l2 & (Long)object) != (Long)object) continue;
                linkedHashSet.add(string);
                l2 ^= ((Long)object).longValue();
            }
            if (l2 != 0L) {
                linkedHashSet.add(Long.toString(l2));
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuilder.append((String)object);
                if (!iterator.hasNext()) break;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }

    public static abstract class SimpleEnum
    extends AbstractEnum {
        public SimpleEnum(Class<?> clazz, Class<? extends Number> clazz2) {
            super(clazz, clazz2);
        }

        @Override
        protected String getName(long l2) {
            return this.constants.containsKey(l2) ? (String)this.constants.get(l2) : Long.toString(l2);
        }
    }

    public static abstract class AbstractEnum {
        private final Class<?> a;
        private final Class<? extends Number> b;
        protected final ConstantMap constants;

        protected AbstractEnum(Class<?> clazz, Class<? extends Number> clazz2) {
            this.a = clazz;
            this.b = clazz2;
            this.constants = new ConstantMap();
        }

        protected final void addConstant(String string, long l2) {
            this.constants.put(l2, string);
        }

        public final Class<?> getEnumClass() {
            return this.a;
        }

        public final Class<? extends Number> getUnderlineClass() {
            return this.b;
        }

        protected abstract String getName(long var1);

        public final long getValue(String string, boolean bl2) {
            for (Map.Entry entry : this.constants.entrySet()) {
                if (StringExtensions.compare((String)entry.getValue(), string, bl2) != 0) continue;
                return (Long)entry.getKey();
            }
            throw new ArgumentException("Requested value '{0}' was not found.", string);
        }

        protected static class ConstantMap
        extends TreeMap<Long, String> {
            protected ConstantMap() {
            }
        }
    }
}

