/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.bmp;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.bmp.BmpFileHeader;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

class BmpInfoHeader {
    public long size;
    public int width;
    public int height;
    public int planes;
    public int bitsPerPixel;
    public long compression;
    public long imageSize;
    public int xpixelsPerM;
    public int ypixelsPerM;
    public long colorsUsed;
    public long colorsImportant;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int alphaMask;
    public long csType;
    public int redX;
    public int redY;
    public int redZ;
    public int greenX;
    public int greenY;
    public int greenZ;
    public int blueX;
    public int blueY;
    public int blueZ;
    public long gammaRed;
    public long gammaGreen;
    public long gammaBlue;
    public boolean isBottomUp;
    public byte[] palette;
    public int numColors;
    int profileData = 0;
    int profileSize = 0;
    public int imageType;

    public BmpInfoHeader() {
        this.size = 40L;
        this.width = 0;
        this.height = 0;
        this.isBottomUp = true;
        this.planes = 1;
        this.bitsPerPixel = 0;
        this.numColors = 0;
        this.compression = 0L;
        this.imageSize = 0L;
        this.xpixelsPerM = 0;
        this.ypixelsPerM = 0;
        this.colorsUsed = 0L;
        this.colorsImportant = 0L;
    }

    public BmpInfoHeader(ImageInputStream imageInputStream, BmpFileHeader bmpFileHeader) throws IOException {
        this.size = imageInputStream.readInt();
        if (this.size == 12L) {
            this.width = imageInputStream.readShort();
            this.height = imageInputStream.readShort();
        } else {
            this.width = imageInputStream.readInt();
            this.height = imageInputStream.readInt();
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = -this.height;
        }
        this.planes = imageInputStream.readShort();
        this.bitsPerPixel = imageInputStream.readShort();
        this.numColors = 1 << this.bitsPerPixel;
        if (this.size == 12L) {
            this.a(imageInputStream, bmpFileHeader);
        } else {
            this.compression = imageInputStream.readUnsignedInt();
            this.imageSize = imageInputStream.readUnsignedInt();
            this.xpixelsPerM = imageInputStream.readInt();
            this.ypixelsPerM = imageInputStream.readInt();
            this.colorsUsed = imageInputStream.readUnsignedInt();
            this.colorsImportant = imageInputStream.readUnsignedInt();
            if (this.size == 40L) {
                this.b(imageInputStream, bmpFileHeader);
            } else if (this.size == 108L || this.size == 124L) {
                this.c(imageInputStream, bmpFileHeader);
            } else {
                throw new RuntimeException("Invalid length of data");
            }
        }
    }

    private void a(ImageInputStream imageInputStream, BmpFileHeader bmpFileHeader) throws IOException {
        if (this.bitsPerPixel == 1) {
            this.imageType = 0;
        } else if (this.bitsPerPixel == 4) {
            this.imageType = 1;
        } else if (this.bitsPerPixel == 8) {
            this.imageType = 2;
        } else if (this.bitsPerPixel == 24) {
            this.imageType = 3;
        }
        int n2 = (int)((bmpFileHeader.bitmapOffset - 14L - this.size) / 3L);
        int n3 = n2 * 3;
        this.a(imageInputStream, n3);
    }

    private void a(ImageInputStream imageInputStream, int n2) throws IOException {
        this.palette = new byte[n2];
        imageInputStream.readFully(this.palette, 0, n2);
    }

    private void b(ImageInputStream imageInputStream, BmpFileHeader bmpFileHeader) throws IOException {
        switch ((int)this.compression) {
            case 4: 
            case 5: {
                this.imageType = 16;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                int n2 = (int)((bmpFileHeader.bitmapOffset - 14L - this.size) / 4L);
                int n3 = n2 * 4;
                this.a(imageInputStream, n3);
                if (this.bitsPerPixel == 1) {
                    this.imageType = 4;
                    break;
                }
                if (this.bitsPerPixel == 4) {
                    this.imageType = 5;
                    break;
                }
                if (this.bitsPerPixel == 8) {
                    this.imageType = 6;
                    break;
                }
                if (this.bitsPerPixel == 24) {
                    this.imageType = 7;
                    break;
                }
                if (this.bitsPerPixel == 16) {
                    this.imageType = 8;
                    this.redMask = 31744;
                    this.greenMask = 992;
                    this.blueMask = 31;
                    break;
                }
                if (this.bitsPerPixel != 32) break;
                this.imageType = 9;
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
                break;
            }
            case 3: {
                if (this.bitsPerPixel == 16) {
                    this.imageType = 8;
                } else if (this.bitsPerPixel == 32) {
                    this.imageType = 9;
                }
                this.redMask = (int)imageInputStream.readUnsignedInt();
                this.greenMask = (int)imageInputStream.readUnsignedInt();
                this.blueMask = (int)imageInputStream.readUnsignedInt();
                if (this.colorsUsed == 0L) break;
                this.a(imageInputStream, (int)this.colorsUsed * 4);
                break;
            }
            default: {
                throw new RuntimeException("Invalid compression");
            }
        }
    }

    private void c(ImageInputStream imageInputStream, BmpFileHeader bmpFileHeader) throws IOException {
        this.redMask = (int)imageInputStream.readUnsignedInt();
        this.greenMask = (int)imageInputStream.readUnsignedInt();
        this.blueMask = (int)imageInputStream.readUnsignedInt();
        this.alphaMask = (int)imageInputStream.readUnsignedInt();
        this.csType = imageInputStream.readUnsignedInt();
        this.redX = imageInputStream.readInt();
        this.redY = imageInputStream.readInt();
        this.redZ = imageInputStream.readInt();
        this.greenX = imageInputStream.readInt();
        this.greenY = imageInputStream.readInt();
        this.greenZ = imageInputStream.readInt();
        this.blueX = imageInputStream.readInt();
        this.blueY = imageInputStream.readInt();
        this.blueZ = imageInputStream.readInt();
        this.gammaRed = imageInputStream.readUnsignedInt();
        this.gammaGreen = imageInputStream.readUnsignedInt();
        this.gammaBlue = imageInputStream.readUnsignedInt();
        if (this.size == 124L) {
            imageInputStream.skipBytes(4);
            this.profileData = imageInputStream.readInt();
            this.profileSize = imageInputStream.readInt();
            imageInputStream.skipBytes(4);
        }
        int n2 = (int)((bmpFileHeader.bitmapOffset - 14L - this.size) / 4L);
        int n3 = n2 * 4;
        this.a(imageInputStream, n3);
        switch ((int)this.compression) {
            case 4: 
            case 5: {
                if (this.size == 108L) {
                    this.imageType = 17;
                    break;
                }
                if (this.size != 124L) break;
                this.imageType = 18;
                break;
            }
            default: {
                if (this.bitsPerPixel == 1) {
                    this.imageType = 10;
                    break;
                }
                if (this.bitsPerPixel == 4) {
                    this.imageType = 11;
                    break;
                }
                if (this.bitsPerPixel == 8) {
                    this.imageType = 12;
                    break;
                }
                if (this.bitsPerPixel == 16) {
                    this.imageType = 13;
                    if ((int)this.compression != 0) break;
                    this.redMask = 31744;
                    this.greenMask = 992;
                    this.blueMask = 31;
                    break;
                }
                if (this.bitsPerPixel == 24) {
                    this.imageType = 14;
                    break;
                }
                if (this.bitsPerPixel != 32) break;
                this.imageType = 15;
                if ((int)this.compression != 0) break;
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
            }
        }
    }

    public void write(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeInt((int)this.size);
        imageOutputStream.writeInt(this.width);
        imageOutputStream.writeInt(this.height);
        imageOutputStream.writeShort(this.planes);
        imageOutputStream.writeShort(this.bitsPerPixel);
        imageOutputStream.writeInt((int)this.compression);
        imageOutputStream.writeInt((int)this.imageSize);
        imageOutputStream.writeInt(this.xpixelsPerM);
        imageOutputStream.writeInt(this.ypixelsPerM);
        imageOutputStream.writeInt((int)this.colorsUsed);
        imageOutputStream.writeInt((int)this.colorsImportant);
    }
}

