/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;

public class PartialProcessor {
    public static void processInterlaced(Rectangle rectangle, int n2, int n3, IPartialProcessor iPartialProcessor) {
        if (rectangle.getBottom() > n3) {
            throw new ArgumentOutOfRangeException("fullHeight", "The rectangle bottom is more than full height.");
        }
        if (rectangle.getRight() > n2) {
            throw new ArgumentOutOfRangeException("fullWidth", "The rectangle right is more than full width.");
        }
        PartialProcessor.a(rectangle.Clone(), iPartialProcessor, 1, n2, n3);
    }

    public static void process(Rectangle rectangle, IPartialProcessor iPartialProcessor) {
        PartialProcessor.a(rectangle.Clone(), iPartialProcessor, 0, 0, 0);
    }

    private static void a(Rectangle rectangle, IPartialProcessor iPartialProcessor, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (iPartialProcessor == null) {
            throw new ArgumentNullException("partialProcessor");
        }
        if (rectangle.getWidth() <= 0) {
            throw new ArgumentOutOfRangeException("areaToProcess", "The processing area widht must be positive and more than 0.");
        }
        if (rectangle.getHeight() <= 0) {
            throw new ArgumentOutOfRangeException("areaToProcess", "The processing area height must be positive and more than 0.");
        }
        if (rectangle.getLeft() < 0) {
            throw new ArgumentOutOfRangeException("areaToProcess", "The processing area left must be positive.");
        }
        if (rectangle.getTop() < 0) {
            throw new ArgumentOutOfRangeException("areaToProcess", "The processing area top must be positive.");
        }
        List<Rectangle> list = new List<Rectangle>();
        if (n2 == 1) {
            int n8;
            int n9 = 0;
            n7 = rectangle.getBottom();
            if (rectangle.getHeight() >= 8) {
                n9 = 4;
            } else {
                for (n6 = rectangle.getTop(); n6 < n7; ++n6) {
                    n8 = n6 % 2;
                    if (n8 == 1) {
                        n9 = 4;
                        break;
                    }
                    int n10 = n6 % 4;
                    if (n10 == 2) {
                        n9 = 3;
                        continue;
                    }
                    n5 = n6 % 8;
                    if (n5 == 4) {
                        n9 = msMath.max(n9, 2);
                        continue;
                    }
                    if (n5 != 0) continue;
                    n9 = msMath.max(n9, 1);
                }
            }
            if (n9 == 4) {
                for (n6 = 1; n6 < n7; n6 += 2) {
                    list.addItem(new Rectangle(0, n6, n3, 1));
                }
                n7 = n4;
            }
            if (n9 >= 3) {
                n6 = 0;
                for (n8 = 2; n8 < n7; n8 += 4) {
                    list.insertItem(n6++, new Rectangle(0, n8, n3, 1));
                }
                n7 = n4;
            }
            if (n9 >= 2) {
                n6 = 0;
                for (n8 = 4; n8 < n7; n8 += 8) {
                    list.insertItem(n6++, new Rectangle(0, n8, n3, 1));
                }
                n7 = n4;
            }
            if (n9 >= 1) {
                n6 = 0;
                for (n8 = 0; n8 < n7; n8 += 8) {
                    list.insertItem(n6++, new Rectangle(0, n8, n3, 1));
                }
            }
        } else {
            list.addItem(rectangle.Clone());
        }
        while (list.size() > 0) {
            try {
                ((Rectangle)list.get_Item(0)).CloneTo(rectangle);
                list.removeAt(0);
                try {
                    iPartialProcessor.process(rectangle.Clone());
                }
                catch (FrameworkException frameworkException) {
                    if (frameworkException.getInnerException() instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)frameworkException.getInnerException();
                    }
                    throw frameworkException;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n7 = rectangle.getWidth();
                n6 = rectangle.getHeight();
                if (n6 > 1) {
                    n6 /= 2;
                } else {
                    if (n7 == 1) {
                        throw outOfMemoryError;
                    }
                    n7 /= 2;
                }
                Rectangle rectangle2 = new Rectangle(rectangle.getLeft(), rectangle.getTop(), n7, n6);
                Rectangle rectangle3 = new Rectangle();
                if (rectangle.getHeight() != n6) {
                    n5 = rectangle.getTop() + n6;
                    rectangle3 = new Rectangle(rectangle.getLeft(), n5, n7, rectangle.getHeight() - n6);
                } else {
                    n5 = rectangle.getLeft() + n7;
                    rectangle3 = new Rectangle(n5, rectangle.getTop(), rectangle.getWidth() - n7, n6);
                }
                list.insertItem(0, rectangle2.Clone());
                list.insertItem(1, rectangle3.Clone());
            }
        }
    }

    public static final class ProcessingType
    extends Enum {
        public static final int Default = 0;
        public static final int Interlaced8 = 1;

        private ProcessingType() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)ProcessingType.class, Integer.class){
                {
                    this.addConstant("Default", 0L);
                    this.addConstant("Interlaced8", 1L);
                }
            });
        }
    }
}

