/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder;

import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.DataBlock;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegComponentInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegEncoderState;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegScan;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegOrder;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.JpegEntropyEncoder;

public class HuffmanEncoder
extends JpegEntropyEncoder {
    private final int[] a = new int[JpegConstants.MaxComponents];
    private final long[][] b = new long[JpegConstants.MaxHuffTbls][];
    private final EntropyTable[] c = new EntropyTable[JpegConstants.MaxHuffTbls];
    private final long[][] d = new long[JpegConstants.MaxHuffTbls][];
    private final EntropyTable[] e = new EntropyTable[JpegConstants.MaxHuffTbls];
    private int f;
    private int g;

    public HuffmanEncoder(JpegEncoderState jpegEncoderState) {
        super(jpegEncoderState);
    }

    @Override
    public EntropyTable[] createHuffmanTables() {
        List<EntropyTable> list = new List<EntropyTable>();
        boolean[] blArray = new boolean[JpegConstants.MaxHuffTbls];
        boolean[] blArray2 = new boolean[JpegConstants.MaxHuffTbls];
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            EntropyTable entropyTable;
            byte by2 = this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getDCSelector();
            byte by3 = this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getACSelector();
            if (!blArray[by2 & 0xFF]) {
                entropyTable = this.generateOptimalTable(this.d[by2 & 0xFF]);
                entropyTable.setTableClass((byte)0);
                entropyTable.setDestination(by2);
                list.addItem(entropyTable);
                blArray[by2 & 0xFF] = true;
            }
            if (blArray2[by3 & 0xFF]) continue;
            entropyTable = this.generateOptimalTable(this.b[by3 & 0xFF]);
            entropyTable.setDestination(by3);
            entropyTable.setTableClass((byte)1);
            list.addItem(entropyTable);
            blArray2[by3 & 0xFF] = true;
        }
        return list.toArray(new EntropyTable[0]);
    }

    @Override
    public void encodeMCU(DataBlock[] dataBlockArray) {
        if (this.getEncoderState().getRestartsNumber() != 0 && this.g == 0) {
            this.a(this.f);
        }
        for (int i2 = 0; i2 < this.getEncoderState().getBlocksInMCU(); ++i2) {
            int n2 = this.getEncoderState().getCurrentScan().getMCUMembership()[i2];
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[n2];
            this.a(dataBlockArray[i2].getData(), this.a[jpegComponentInfo.getId() & 0xFF], this.e[jpegComponentInfo.getDCSelector() & 0xFF], this.c[jpegComponentInfo.getACSelector() & 0xFF]);
            this.a[jpegComponentInfo.getId() & 0xFF] = dataBlockArray[i2].getData()[0];
        }
        if (this.getEncoderState().getRestartsNumber() == 0 || this.g != 0) {
            return;
        }
        this.g = this.getEncoderState().getRestartsNumber();
        ++this.f;
        this.f &= 7;
    }

    @Override
    public void finishPass() {
        this.getEncoderState().getRawDataWriter().flush();
    }

    @Override
    public void gatherEntropy(DataBlock[] dataBlockArray) {
        for (int i2 = 0; i2 < dataBlockArray.length; ++i2) {
            int n2 = this.getEncoderState().getCurrentScan().getMCUMembership()[i2];
            this.testBlock(dataBlockArray[i2].getData(), this.a[n2], this.d[this.getEncoderState().getJpegFrame().getComponentInfos()[n2].getDCSelector() & 0xFF], this.b[this.getEncoderState().getJpegFrame().getComponentInfos()[n2].getACSelector() & 0xFF]);
            this.a[n2] = dataBlockArray[i2].getData()[0];
        }
    }

    public void gatherMCUData(DataBlock[] dataBlockArray) {
        for (int i2 = 0; i2 < this.getEncoderState().getBlocksInMCU(); ++i2) {
            int n2 = this.getEncoderState().getCurrentScan().getMCUMembership()[i2];
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[n2];
            this.testBlock(dataBlockArray[i2].getData(), this.a[n2], this.d[jpegComponentInfo.getDCSelector() & 0xFF], this.b[jpegComponentInfo.getACSelector() & 0xFF]);
            this.a[n2] = dataBlockArray[i2].getData()[0];
        }
    }

    @Override
    public void initialize() {
        for (int i2 = 0; i2 < this.getEncoderState().getBlocksInMCU(); ++i2) {
            int n2 = this.getEncoderState().getCurrentScan().getMCUMembership()[i2];
            JpegComponentInfo jpegComponentInfo = this.getEncoderState().getJpegFrame().getComponentInfos()[n2];
            for (EntropyTable entropyTable : this.getEncoderState().getEntropyTables().getValues()) {
                if ((entropyTable.getTableClass() & 0xFF) == 1) {
                    if ((entropyTable.getDestination() & 0xFF) != (jpegComponentInfo.getACSelector() & 0xFF)) continue;
                    this.c[jpegComponentInfo.getACSelector() & 0xFF] = entropyTable;
                    continue;
                }
                if ((entropyTable.getDestination() & 0xFF) != (jpegComponentInfo.getDCSelector() & 0xFF)) continue;
                this.e[jpegComponentInfo.getDCSelector() & 0xFF] = entropyTable;
            }
        }
        ArrayHelper.clear(this.a, 0, this.a.length);
        if (this.getEncoderState().getRestartsNumber() > 0) {
            this.g = this.getEncoderState().getRestartsNumber();
        }
    }

    @Override
    public void startGatherEntropy() {
        JpegScan jpegScan = this.getEncoderState().getCurrentScan();
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            if (this.d[this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getDCSelector() & 0xFF] == null) {
                this.d[this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getDCSelector() & 0xFF] = new long[257];
            }
            if (this.b[this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getACSelector() & 0xFF] == null) {
                this.b[this.getEncoderState().getJpegFrame().getComponentInfos()[jpegScan.Components[i2]].getACSelector() & 0xFF] = new long[257];
            }
            this.a[jpegScan.Components[i2]] = 0;
        }
    }

    public void testBlock(short[] sArray, int n2, long[] lArray, long[] lArray2) {
        int n3 = sArray[0] - n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = 0;
        while (n3 != 0) {
            ++n4;
            n3 >>= 1;
        }
        int n5 = n4;
        lArray[n5] = lArray[n5] + 1L;
        int n6 = 0;
        for (int i2 = 1; i2 < JpegConstants.BlockSize2; ++i2) {
            n3 = sArray[JpegOrder.NaturalOrder[i2]];
            if (n3 == 0) {
                ++n6;
                continue;
            }
            while (n6 > 15) {
                lArray2[240] = lArray2[240] + 1L;
                n6 -= 16;
            }
            if (n3 < 0) {
                n3 = -n3;
            }
            n4 = 1;
            while ((n3 >>= 1) != 0) {
                ++n4;
            }
            int n7 = (n6 << 4) + n4;
            lArray2[n7] = lArray2[n7] + 1L;
            n6 = 0;
        }
        if (n6 > 0) {
            lArray2[0] = lArray2[0] + 1L;
        }
    }

    private void a(int n2) {
        this.getEncoderState().getRawDataWriter().flush();
        this.getEncoderState().getRawDataWriter().emitByte((byte)(208 + n2));
        ArrayHelper.clear(this.a, 0, this.a.length);
    }

    private void a(short[] sArray, int n2, EntropyTable entropyTable, EntropyTable entropyTable2) {
        int n3;
        int n4 = n3 = sArray[0] - n2;
        if (n3 < 0) {
            n3 = -n3;
            --n4;
        }
        int n5 = 0;
        while (n3 != 0) {
            ++n5;
            n3 >>= 1;
        }
        if (n5 > MaxHuffmanCoefBits + 1) {
            throw new Exception("Bad DCT coef");
        }
        this.getEncoderState().getRawDataWriter().emitBits(entropyTable.getEhufco()[n5], entropyTable.getEhufsi()[n5]);
        if (n5 != 0) {
            this.getEncoderState().getRawDataWriter().emitBits(n4, n5);
        }
        int n6 = 0;
        for (int i2 = 1; i2 < JpegConstants.BlockSize2; ++i2) {
            n3 = sArray[JpegOrder.NaturalOrder[i2]];
            if (n3 == 0) {
                ++n6;
                continue;
            }
            while (n6 > 15) {
                this.getEncoderState().getRawDataWriter().emitBits(entropyTable2.getEhufco()[240], entropyTable2.getEhufsi()[240]);
                n6 -= 16;
            }
            n4 = n3;
            if (n3 < 0) {
                n3 = -n3;
                --n4;
            }
            n5 = 1;
            while ((n3 >>= 1) != 0) {
                ++n5;
            }
            if (n5 > MaxHuffmanCoefBits) {
                throw new Exception("Bad dct coef");
            }
            int n7 = (n6 << 4) + n5;
            this.getEncoderState().getRawDataWriter().emitBits(entropyTable2.getEhufco()[n7], entropyTable2.getEhufsi()[n7]);
            this.getEncoderState().getRawDataWriter().emitBits(n4, n5);
            n6 = 0;
        }
        if (n6 > 0) {
            this.getEncoderState().getRawDataWriter().emitBits(entropyTable2.getEhufco()[0], entropyTable2.getEhufsi()[0]);
        }
    }
}

