/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.utils.ms.core.JavaLangSystem;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.FilterType;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLine;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLines;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngDeinterlacer;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngIDatChunkInputStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjInputException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkLoadBehaviour;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunksList;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIDAT;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIHDR;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSkipped;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;

public class PngReader {
    public final ImageInfo imgInfo;
    protected final String filename;
    private ChunkLoadBehaviour a = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;
    private boolean b = true;
    private long c = 0xC800000L;
    private int d = 0x500000;
    private int e = 0x200000;
    private String[] f = new String[]{"fdAT"};
    private HashSet<String> g;
    protected final PngMetadata metadata;
    protected final ChunksList chunksList;
    protected ImageLine imgLine;
    protected byte[] rowb = null;
    protected byte[] rowbprev = null;
    protected byte[] rowbfilter = null;
    private final boolean h;
    private final PngDeinterlacer i;
    private boolean j = true;
    private boolean k = false;
    protected int currentChunkGroup = -1;
    protected int rowNum = -1;
    private long l = 0L;
    private int m;
    protected final InputStream inputStream;
    protected InflaterInputStream idatIstream;
    protected PngIDatChunkInputStream iIdatCstream;
    protected CRC32 crctest;

    public PngReader(InputStream inputStream, String string) {
        this.filename = string == null ? "" : string;
        this.inputStream = inputStream;
        this.chunksList = new ChunksList(null);
        this.metadata = new PngMetadata(this.chunksList);
        byte[] byArray = new byte[8];
        PngHelperInternal.readBytes(inputStream, byArray, 0, byArray.length);
        this.l += (long)byArray.length;
        if (!Arrays.equals(byArray, PngHelperInternal.getPngIdSignature())) {
            throw new PngjInputException("Bad PNG signature");
        }
        this.currentChunkGroup = 0;
        int n2 = PngHelperInternal.readInt4(inputStream);
        this.l += 4L;
        if (n2 != 13) {
            throw new PngjInputException("IDHR chunk len != 13 ?? " + n2);
        }
        byte[] byArray2 = new byte[4];
        PngHelperInternal.readBytes(inputStream, byArray2, 0, 4);
        if (!Arrays.equals(byArray2, ChunkHelper.b_IHDR)) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ChunkHelper.toString(byArray2) + "]");
        }
        this.l += 4L;
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)this.a(byArray2, n2, false);
        boolean bl2 = (pngChunkIHDR.getColormodel() & 4) != 0;
        boolean bl3 = (pngChunkIHDR.getColormodel() & 1) != 0;
        boolean bl4 = pngChunkIHDR.getColormodel() == 0 || pngChunkIHDR.getColormodel() == 4;
        this.imgInfo = new ImageInfo(pngChunkIHDR.getCols(), pngChunkIHDR.getRows(), pngChunkIHDR.getBitspc(), bl2, bl4, bl3);
        this.rowbfilter = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowb = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.h = pngChunkIHDR.getInterlaced() == 1;
        PngDeinterlacer pngDeinterlacer = this.i = this.h ? new PngDeinterlacer(this.imgInfo) : null;
        if (pngChunkIHDR.getFilmeth() != 0 || pngChunkIHDR.getCompmeth() != 0 || (pngChunkIHDR.getInterlaced() & 0xFFFE) != 0) {
            throw new PngjInputException("compression method o filter method or interlaced unrecognized ");
        }
        if (pngChunkIHDR.getColormodel() < 0 || pngChunkIHDR.getColormodel() > 6 || pngChunkIHDR.getColormodel() == 1 || pngChunkIHDR.getColormodel() == 5) {
            throw new PngjInputException("Invalid colormodel " + pngChunkIHDR.getColormodel());
        }
        if (pngChunkIHDR.getBitspc() != 1 && pngChunkIHDR.getBitspc() != 2 && pngChunkIHDR.getBitspc() != 4 && pngChunkIHDR.getBitspc() != 8 && pngChunkIHDR.getBitspc() != 16) {
            throw new PngjInputException("Invalid bit depth " + pngChunkIHDR.getBitspc());
        }
    }

    private boolean a() {
        return this.currentChunkGroup < 1;
    }

    private void b() {
        if (this.currentChunkGroup < 5) {
            try {
                this.idatIstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.readLastChunks();
        }
        this.c();
    }

    private void c() {
        if (this.currentChunkGroup < 6) {
            try {
                this.idatIstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentChunkGroup = 6;
        }
        if (this.b) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                throw new PngjInputException("error closing input stream!", exception);
            }
        }
    }

    private void a(int n2) {
        byte by2 = this.rowbfilter[0];
        FilterType filterType = FilterType.getByVal(by2);
        if (filterType == null) {
            filterType = FilterType.FILTER_NONE;
        }
        switch (filterType) {
            case FILTER_NONE: {
                this.c(n2);
                break;
            }
            case FILTER_SUB: {
                this.e(n2);
                break;
            }
            case FILTER_UP: {
                this.f(n2);
                break;
            }
            case FILTER_AVERAGE: {
                this.b(n2);
                break;
            }
            case FILTER_PAETH: {
                this.d(n2);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + by2 + " not implemented");
            }
        }
        if (this.crctest != null) {
            this.crctest.update(this.rowb, 1, this.rowb.length - 1);
        }
    }

    private void b(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowb[n3] & 0xFF : 0;
            this.rowb[n4] = (byte)(this.rowbfilter[n4] + (n5 + (this.rowbprev[n4] & 0xFF)) / 2);
            ++n4;
            ++n3;
        }
    }

    private void c(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowb[i2] = this.rowbfilter[i2];
        }
    }

    private void d(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowb[n3] & 0xFF : 0;
            int n6 = n3 > 0 ? this.rowbprev[n3] & 0xFF : 0;
            this.rowb[n4] = (byte)(this.rowbfilter[n4] + PngHelperInternal.filterPaethPredictor(n5, this.rowbprev[n4] & 0xFF, n6));
            ++n4;
            ++n3;
        }
    }

    private void e(int n2) {
        int n3;
        for (n3 = 1; n3 <= this.imgInfo.bytesPixel; ++n3) {
            this.rowb[n3] = this.rowbfilter[n3];
        }
        int n4 = 1;
        n3 = this.imgInfo.bytesPixel + 1;
        while (n3 <= n2) {
            this.rowb[n3] = (byte)(this.rowbfilter[n3] + this.rowb[n4]);
            ++n3;
            ++n4;
        }
    }

    private void f(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowb[i2] = (byte)(this.rowbfilter[i2] + this.rowbprev[i2]);
        }
    }

    private final void d() {
        int n2;
        if (!this.a()) {
            return;
        }
        int n3 = 0;
        boolean bl2 = false;
        byte[] byArray = new byte[4];
        this.currentChunkGroup = 1;
        while (!bl2) {
            n3 = PngHelperInternal.readInt4(this.inputStream);
            this.l += 4L;
            if (n3 < 0) break;
            PngHelperInternal.readBytes(this.inputStream, byArray, 0, 4);
            this.l += 4L;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl2 = true;
                this.currentChunkGroup = 4;
                this.chunksList.appendReadChunk(new PngChunkIDAT(this.imgInfo, n3, this.l - 8L), this.currentChunkGroup);
                break;
            }
            if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                throw new PngjInputException("END chunk found before image data (IDAT) at offset=" + this.l);
            }
            if (Arrays.equals(byArray, ChunkHelper.b_PLTE)) {
                this.currentChunkGroup = 2;
            }
            this.a(byArray, n3, false);
            if (!Arrays.equals(byArray, ChunkHelper.b_PLTE)) continue;
            this.currentChunkGroup = 3;
        }
        int n4 = n2 = bl2 ? n3 : -1;
        if (n2 < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.inputStream, n2, this.l);
        this.idatIstream = new InflaterInputStream(this.iIdatCstream);
        if (!this.j) {
            this.iIdatCstream.disableCrcCheck();
        }
    }

    void readLastChunks() {
        this.currentChunkGroup = 5;
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        int n2 = this.iIdatCstream.getLenLastChunk();
        byte[] byArray = this.iIdatCstream.getIdLastChunk();
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        while (!bl2) {
            bl4 = false;
            if (!bl3) {
                n2 = PngHelperInternal.readInt4(this.inputStream);
                this.l += 4L;
                if (n2 < 0) {
                    throw new PngjInputException("bad chuck len " + n2);
                }
                PngHelperInternal.readBytes(this.inputStream, byArray, 0, 4);
                this.l += 4L;
            }
            bl3 = false;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl4 = true;
            } else if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                this.currentChunkGroup = 6;
                bl2 = true;
            }
            this.a(byArray, n2, bl4);
        }
        if (!bl2) {
            throw new PngjInputException("end chunk not found - offset=" + this.l);
        }
    }

    private PngChunk a(byte[] byArray, int n2, boolean bl2) {
        if (n2 < 0) {
            throw new PngjInputException("invalid chunk lenght: " + n2);
        }
        if (this.g == null && this.currentChunkGroup > 0) {
            this.g = new HashSet<String>(Arrays.asList(this.f));
        }
        String string = ChunkHelper.toString(byArray);
        boolean bl3 = ChunkHelper.isCritical(string);
        PngChunk pngChunk = null;
        boolean bl4 = bl2;
        if (this.c > 0L && (long)n2 + this.l > this.c) {
            throw new PngjInputException("Maximum total bytes to read exceeeded: " + this.c + " offset:" + this.l + " clen=" + n2);
        }
        if (this.currentChunkGroup > 0 && !bl3) {
            boolean bl5 = bl4 = bl4 || this.e > 0 && n2 >= this.e || this.g.contains(string) || this.d > 0 && n2 > this.d - this.m || !ChunkHelper.shouldLoad(string, this.a);
        }
        if (bl4) {
            PngHelperInternal.skipBytes(this.inputStream, n2);
            PngHelperInternal.readInt4(this.inputStream);
            pngChunk = new PngChunkSkipped(string, this.imgInfo, n2);
        } else {
            ChunkRaw chunkRaw = new ChunkRaw(n2, byArray, true);
            chunkRaw.readChunkData(this.inputStream, this.j || bl3);
            pngChunk = PngChunk.factory(chunkRaw, this.imgInfo);
            if (!pngChunk.crit) {
                this.m += chunkRaw.len;
            }
        }
        pngChunk.setOffset(this.l - 8L);
        this.chunksList.appendReadChunk(pngChunk, this.currentChunkGroup);
        this.l += (long)n2 + 4L;
        return pngChunk;
    }

    protected void logWarn(String string) {
        JavaLangSystem.err.println(string);
    }

    public ChunkLoadBehaviour getChunkLoadBehaviour() {
        return this.a;
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.a = chunkLoadBehaviour;
    }

    public ChunksList getChunksList() {
        if (this.a()) {
            this.d();
        }
        return this.chunksList;
    }

    int getCurrentChunkGroup() {
        return this.currentChunkGroup;
    }

    public PngMetadata getMetadata() {
        if (this.a()) {
            this.d();
        }
        return this.metadata;
    }

    public ImageLine readRow(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.k);
        }
        return this.imgLine.sampleType != ImageLine.SampleType.BYTE ? this.readRowInt(n2) : this.readRowByte(n2);
    }

    public ImageLine readRowInt(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.INT, this.k);
        }
        if (this.imgLine.getRown() == n2) {
            return this.imgLine;
        }
        this.readRowInt(this.imgLine.scanline, n2);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(n2);
        return this.imgLine;
    }

    public ImageLine readRowByte(int n2) {
        if (this.imgLine == null) {
            this.imgLine = new ImageLine(this.imgInfo, ImageLine.SampleType.BYTE, this.k);
        }
        if (this.imgLine.getRown() == n2) {
            return this.imgLine;
        }
        this.readRowByte(this.imgLine.scanlineb, n2);
        this.imgLine.setFilterUsed(FilterType.getByVal(this.rowbfilter[0]));
        this.imgLine.setRown(n2);
        return this.imgLine;
    }

    public final int[] readRow(int[] nArray, int n2) {
        return this.readRowInt(nArray, n2);
    }

    public final int[] readRowInt(int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.h) {
            if (n2 <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n2);
            }
            int n3 = 0;
            while (this.rowNum < n2) {
                n3 = this.g(this.rowNum + 1);
            }
            this.a(nArray, n3);
        } else {
            if (this.i.getImageInt() == null) {
                this.i.setImageInt(this.readRowsInt().scanlines);
            }
            System.arraycopy(this.i.getImageInt()[n2], 0, nArray, 0, this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return nArray;
    }

    public final byte[] readRowByte(byte[] byArray, int n2) {
        if (byArray == null) {
            byArray = new byte[this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
        }
        if (!this.h) {
            if (n2 <= this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n2);
            }
            int n3 = 0;
            while (this.rowNum < n2) {
                n3 = this.g(this.rowNum + 1);
            }
            this.a(byArray, n3);
        } else {
            if (this.i.getImageByte() == null) {
                this.i.setImageByte(this.readRowsByte().scanlinesb);
            }
            System.arraycopy(this.i.getImageByte()[n2], 0, byArray, 0, this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked);
        }
        return byArray;
    }

    public ImageLine getRow(int n2) {
        return this.readRow(n2);
    }

    private void a(int[] nArray, int n2) {
        if (this.imgInfo.bitDepth <= 8) {
            int n3 = 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.rowb[n3++] & 0xFF;
            }
        } else {
            int n4 = 0;
            int n5 = 1;
            while (n5 <= n2) {
                nArray[n4] = ((this.rowb[n5++] & 0xFF) << 8) + (this.rowb[n5++] & 0xFF);
                ++n4;
            }
        }
        if (this.imgInfo.packed && this.k) {
            ImageLine.unpackInplaceInt(this.imgInfo, nArray, nArray, false);
        }
    }

    private void a(byte[] byArray, int n2) {
        if (this.imgInfo.bitDepth <= 8) {
            System.arraycopy(this.rowb, 1, byArray, 0, n2);
        } else {
            int n3 = 0;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                byArray[n3] = this.rowb[i2];
                ++n3;
            }
        }
        if (this.imgInfo.packed && this.k) {
            ImageLine.unpackInplaceByte(this.imgInfo, byArray, byArray, false);
        }
    }

    public ImageLines readRowsInt(int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = (this.imgInfo.rows - n2) / n4;
        }
        if (n4 < 1 || n2 < 0 || n3 * n4 + n2 > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imageLines = new ImageLines(this.imgInfo, ImageLine.SampleType.INT, this.k, n2, n3, n4);
        if (!this.h) {
            for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
                int n5 = this.g(i2);
                int n6 = imageLines.imageRowToMatrixRowStrict(i2);
                if (n6 < 0) continue;
                this.a(imageLines.scanlines[n6], n5);
            }
        } else {
            int[] nArray = new int[this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int i3 = 1; i3 <= 7; ++i3) {
                this.i.setPass(i3);
                for (int i4 = 0; i4 < this.i.getRows(); ++i4) {
                    int n7 = this.g(i4);
                    int n8 = this.i.getCurrRowReal();
                    int n9 = imageLines.imageRowToMatrixRowStrict(n8);
                    if (n9 < 0) continue;
                    this.a(nArray, n7);
                    this.i.deinterlaceInt(nArray, imageLines.scanlines[n9], !this.k);
                }
            }
        }
        this.end();
        return imageLines;
    }

    public ImageLines readRowsInt() {
        return this.readRowsInt(0, this.imgInfo.rows, 1);
    }

    public ImageLines readRowsByte(int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = (this.imgInfo.rows - n2) / n4;
        }
        if (n4 < 1 || n2 < 0 || n3 * n4 + n2 > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        ImageLines imageLines = new ImageLines(this.imgInfo, ImageLine.SampleType.BYTE, this.k, n2, n3, n4);
        if (!this.h) {
            for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
                int n5 = this.g(i2);
                int n6 = imageLines.imageRowToMatrixRowStrict(i2);
                if (n6 < 0) continue;
                this.a(imageLines.scanlinesb[n6], n5);
            }
        } else {
            byte[] byArray = new byte[this.k ? this.imgInfo.samplesPerRow : this.imgInfo.samplesPerRowPacked];
            for (int i3 = 1; i3 <= 7; ++i3) {
                this.i.setPass(i3);
                for (int i4 = 0; i4 < this.i.getRows(); ++i4) {
                    int n7 = this.g(i4);
                    int n8 = this.i.getCurrRowReal();
                    int n9 = imageLines.imageRowToMatrixRowStrict(n8);
                    if (n9 < 0) continue;
                    this.a(byArray, n7);
                    this.i.deinterlaceByte(byArray, imageLines.scanlinesb[n9], !this.k);
                }
            }
        }
        this.end();
        return imageLines;
    }

    public ImageLines readRowsByte() {
        return this.readRowsByte(0, this.imgInfo.rows, 1);
    }

    private int g(int n2) {
        if (n2 == 0 && this.a()) {
            this.d();
        }
        if (n2 == 0 && this.h) {
            Arrays.fill(this.rowb, (byte)0);
        }
        int n3 = this.imgInfo.bytesPerRow;
        if (this.h) {
            if (n2 < 0 || n2 > this.i.getRows() || n2 != 0 && n2 != this.i.getCurrRowSubimg() + 1) {
                throw new PngjInputException("invalid row in interlaced mode: " + n2);
            }
            this.i.setRow(n2);
            n3 = (this.imgInfo.bitspPixel * this.i.getPixelsToRead() + 7) / 8;
            if (n3 < 1) {
                throw new PngjExceptionInternal("wtf??");
            }
        } else if (n2 < 0 || n2 >= this.imgInfo.rows || n2 != this.rowNum + 1) {
            throw new PngjInputException("invalid row: " + n2);
        }
        this.rowNum = n2;
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
        PngHelperInternal.readBytes(this.idatIstream, this.rowbfilter, 0, n3 + 1);
        this.l = this.iIdatCstream.getOffset();
        if (this.l < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.l);
        }
        if (this.c > 0L && this.l >= this.c) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.c + " offset:" + this.l);
        }
        this.rowb[0] = 0;
        this.a(n3);
        this.rowb[0] = this.rowbfilter[0];
        if (this.rowNum == this.imgInfo.rows - 1 && !this.h || this.h && this.i.isAtLastRow()) {
            this.b();
        }
        return n3;
    }

    public void readSkippingAllRows() {
        if (this.a()) {
            this.d();
        }
        this.iIdatCstream.disableCrcCheck();
        try {
            int n2;
            while ((n2 = this.iIdatCstream.read(this.rowbfilter, 0, this.rowbfilter.length)) >= 0) {
            }
        }
        catch (IOException iOException) {
            throw new PngjInputException("error in raw read of IDAT", iOException);
        }
        this.l = this.iIdatCstream.getOffset();
        if (this.l < 0L) {
            throw new PngjExceptionInternal("bad offset ??" + this.l);
        }
        if (this.c > 0L && this.l >= this.c) {
            throw new PngjInputException("Reading IDAT: Maximum total bytes to read exceeeded: " + this.c + " offset:" + this.l);
        }
        this.b();
    }

    public void setMaxTotalBytesRead(long l2) {
        this.c = l2;
    }

    public long getMaxTotalBytesRead() {
        return this.c;
    }

    public void setMaxBytesMetadata(int n2) {
        this.d = n2;
    }

    public int getMaxBytesMetadata() {
        return this.d;
    }

    public void setSkipChunkMaxSize(int n2) {
        this.e = n2;
    }

    public int getSkipChunkMaxSize() {
        return this.e;
    }

    public void setSkipChunkIds(String[] stringArray) {
        this.f = stringArray == null ? new String[]{} : stringArray;
    }

    public String[] getSkipChunkIds() {
        return this.f;
    }

    public void setShouldCloseStream(boolean bl2) {
        this.b = bl2;
    }

    public void end() {
        if (this.currentChunkGroup < 6) {
            this.c();
        }
    }

    public boolean isInterlaced() {
        return this.h;
    }

    public void setUnpackedMode(boolean bl2) {
        this.k = bl2;
    }

    public boolean isUnpackedMode() {
        return this.k;
    }

    public void setCrcCheckDisabled() {
        this.j = false;
    }

    long getCrctestVal() {
        return this.crctest.getValue();
    }

    void initCrctest() {
        this.crctest = new CRC32();
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }
}

