/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricSignatureDeformatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.utils.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.MD5SHA1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.s;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class RSASslSignatureDeformatter
extends AsymmetricSignatureDeformatter {
    private RSA a;
    private HashAlgorithm b;
    private static final StringSwitchMap c = new StringSwitchMap("MD5SHA1");

    public RSASslSignatureDeformatter() {
    }

    public RSASslSignatureDeformatter(AsymmetricAlgorithm asymmetricAlgorithm) {
        this.setKey(asymmetricAlgorithm);
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException("The key is a null reference");
        }
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException("The hash algorithm is a null reference.");
        }
        if (byArray == null) {
            throw new ArgumentNullException("The rgbHash parameter is a null reference.");
        }
        return s.a(this.a, this.b, byArray, byArray2);
    }

    @Override
    public void setHashAlgorithm(String string) {
        switch (c.of(string)) {
            case 0: {
                this.b = new MD5SHA1();
                break;
            }
            default: {
                this.b = HashAlgorithm.create(string);
            }
        }
    }

    @Override
    public void setKey(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (!Operators.is(asymmetricAlgorithm, RSA.class)) {
            throw new ArgumentException("Specfied key is not an RSA key");
        }
        this.a = Operators.as(asymmetricAlgorithm, RSA.class);
    }
}

