/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.DSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSAPKCS1SignatureDeformatter;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSAPKCS1SignatureFormatter;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509CertificateCollection;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h;
import com.aspose.html.utils.ms.lang.StringSwitchMap;
import java.util.Comparator;
import java.util.Iterator;

public final class PKCS7 {
    private static final StringSwitchMap c = new StringSwitchMap("1.3.14.3.2.26", "1.2.840.113549.2.2", "1.2.840.113549.2.5", "2.16.840.1.101.3.4.1", "2.16.840.1.101.3.4.2", "2.16.840.1.101.3.4.3");
    private static String d = StringExtensions.format("Input data cannot be coded as a valid certificate.", new Object[0]);
    static final int a = -2146889714;
    static final String b = "The original signer is not found.";

    private PKCS7() {
    }

    public static ASN1 attribute(String string, ASN1 aSN1) {
        ASN1 aSN12 = new ASN1(48);
        aSN12.add(ASN1Convert.fromOid(string));
        ASN1 aSN13 = aSN12.add(new ASN1(49));
        aSN13.add(aSN1);
        return aSN12;
    }

    public static ASN1 algorithmIdentifier(String string) {
        ASN1 aSN1 = new ASN1(48);
        aSN1.add(ASN1Convert.fromOid(string));
        aSN1.add(new ASN1(5));
        return aSN1;
    }

    public static ASN1 algorithmIdentifier(String string, ASN1 aSN1) {
        ASN1 aSN12 = new ASN1(48);
        aSN12.add(ASN1Convert.fromOid(string));
        aSN12.add(aSN1);
        return aSN12;
    }

    public static ASN1 issuerAndSerialNumber(X509Certificate x509Certificate) {
        ASN1 aSN1;
        ASN1 aSN12 = null;
        ASN1 aSN13 = null;
        ASN1 aSN14 = new ASN1(x509Certificate.getRawData());
        int n2 = 0;
        boolean bl2 = false;
        while (n2 < aSN14.get_Item(0).getCount()) {
            aSN1 = aSN14.get_Item(0).get_Item(n2++);
            if (aSN1.getTag() == 2) {
                aSN13 = aSN1;
                continue;
            }
            if (aSN1.getTag() != 48) continue;
            if (bl2) {
                aSN12 = aSN1;
                break;
            }
            bl2 = true;
        }
        aSN1 = new ASN1(48);
        aSN1.add(aSN12);
        aSN1.add(aSN13);
        return aSN1;
    }

    public static X509Certificate[] loadCertificates(byte[] byArray) {
        ContentInfo contentInfo = new ContentInfo(byArray);
        if (!contentInfo.getContentType().equals("1.2.840.113549.1.7.2")) {
            throw new CryptographicException(d);
        }
        SignedData signedData = new SignedData(contentInfo.getContent());
        SignerInfo signerInfo = signedData.getSignerInfo();
        if (signerInfo.getIssuerName() == null) {
            throw new CryptographicException(b);
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[signedData.getCertificates().size()];
        signedData.getCertificates().copyTo(x509CertificateArray, 0);
        return x509CertificateArray;
    }

    static class a
    implements Comparator {
        a() {
        }

        public int compare(Object object, Object object2) {
            ASN1 aSN1;
            if (object == null) {
                return object2 == null ? 0 : -1;
            }
            if (object2 == null) {
                return 1;
            }
            ASN1 aSN12 = object instanceof ASN1 ? (ASN1)object : null;
            ASN1 aSN13 = aSN1 = object2 instanceof ASN1 ? (ASN1)object2 : null;
            if (aSN12 == null || aSN1 == null) {
                throw new ArgumentException(StringExtensions.format("Invalid objects.", new Object[0]));
            }
            byte[] byArray = aSN12.getBytes();
            byte[] byArray2 = aSN1.getBytes();
            for (int i2 = 0; i2 < byArray.length && i2 != byArray2.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF) ? -1 : 1;
            }
            if (byArray.length > byArray2.length) {
                return 1;
            }
            if (byArray.length < byArray2.length) {
                return -1;
            }
            return 0;
        }
    }

    public static class SignerInfo {
        private byte a = 1;
        private X509Certificate b;
        private String c;
        private AsymmetricAlgorithm d;
        private ArrayList e = new ArrayList();
        private ArrayList f = new ArrayList();
        private byte[] g;
        private String h;
        private byte[] i;
        private byte[] j;

        public SignerInfo() {
        }

        public SignerInfo(byte[] byArray) {
            this(new ASN1(byArray));
        }

        public SignerInfo(ASN1 aSN1) {
            this();
            ASN1 aSN12;
            if (aSN1.get_Item(0).getTag() != 48 || aSN1.get_Item(0).getCount() < 5) {
                throw new ArgumentException("Invalid SignedData");
            }
            if (aSN1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = aSN1.get_Item(0).get_Item(0).getValue()[0];
            ASN1 aSN13 = aSN1.get_Item(0).get_Item(1);
            if ((aSN13.getTag() & 0xFF) == 128 && this.a == 3) {
                this.j = aSN13.getValue();
            } else {
                this.h = com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h.a(aSN13.get_Item(0));
                this.i = aSN13.get_Item(1).getValue();
            }
            ASN1 aSN14 = aSN1.get_Item(0).get_Item(2);
            this.c = ASN1Convert.toOid(aSN14.get_Item(0));
            int n2 = 3;
            ASN1 aSN15 = aSN1.get_Item(0).get_Item(n2);
            if ((aSN15.getTag() & 0xFF) == 160) {
                ++n2;
                for (int i2 = 0; i2 < aSN15.getCount(); ++i2) {
                    this.e.addItem(aSN15.get_Item(i2));
                }
            }
            int n3 = ++n2;
            ++n2;
            ASN1 aSN16 = aSN1.get_Item(0).get_Item(n3);
            if (aSN16.getTag() == 4) {
                this.g = aSN16.getValue();
            }
            if ((aSN12 = aSN1.get_Item(0).get_Item(n2)) != null && (aSN12.getTag() & 0xFF) == 161) {
                for (int i3 = 0; i3 < aSN12.getCount(); ++i3) {
                    this.f.addItem(aSN12.get_Item(i3));
                }
            }
        }

        public String getIssuerName() {
            return this.h;
        }

        public byte[] getSerialNumber() {
            if (this.i == null) {
                return null;
            }
            return (byte[])this.i.clone();
        }

        public byte[] getSubjectKeyIdentifier() {
            if (this.j == null) {
                return null;
            }
            return (byte[])this.j.clone();
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ArrayList getAuthenticatedAttributes() {
            return this.e;
        }

        public X509Certificate getCertificate() {
            return this.b;
        }

        public void setCertificate(X509Certificate x509Certificate) {
            this.b = x509Certificate;
        }

        public String getHashName() {
            return this.c;
        }

        public void setHashName(String string) {
            this.c = string;
        }

        public AsymmetricAlgorithm getKey() {
            return this.d;
        }

        public void setKey(AsymmetricAlgorithm asymmetricAlgorithm) {
            this.d = asymmetricAlgorithm;
        }

        public byte[] getSignature() {
            if (this.g == null) {
                return null;
            }
            return (byte[])this.g.clone();
        }

        public void setSignature(byte[] byArray) {
            if (byArray != null) {
                this.g = (byte[])byArray.clone();
            }
        }

        public ArrayList getUnauthenticatedAttributes() {
            return this.f;
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte by2) {
            this.a = by2;
        }

        ASN1 a() {
            Object object;
            if (this.d == null || this.c == null) {
                return null;
            }
            byte[] byArray = new byte[]{this.a};
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(new ASN1(2, byArray));
            aSN1.add(PKCS7.issuerAndSerialNumber(this.b));
            String string = CryptoConfig.mapNameToOID(this.c);
            aSN1.add(PKCS7.algorithmIdentifier(string));
            ASN1 aSN12 = null;
            if (this.e.size() > 0) {
                aSN12 = aSN1.add(new ASN1(-96));
                this.e.sort((Comparator)new a());
                for (Iterator iterator : this.e) {
                    aSN12.add((ASN1)((Object)iterator));
                }
            }
            if (this.d instanceof RSA) {
                aSN1.add(PKCS7.algorithmIdentifier("1.2.840.113549.1.1.1"));
                if (aSN12 != null) {
                    Iterator iterator;
                    object = new RSAPKCS1SignatureFormatter(this.d);
                    ((RSAPKCS1SignatureFormatter)object).setHashAlgorithm(this.c);
                    iterator = (Iterator)aSN12.getBytes();
                    iterator[0] = 49;
                    Object object2 = HashAlgorithm.create(this.c);
                    byte[] byArray2 = ((HashAlgorithm)object2).computeHash((byte[])iterator);
                    this.g = ((RSAPKCS1SignatureFormatter)object).createSignature(byArray2);
                }
            } else {
                if (this.d instanceof DSA) {
                    throw new NotImplementedException("not yet");
                }
                throw new CryptographicException("Unknown assymetric algorithm");
            }
            aSN1.add(new ASN1(4, this.g));
            if (this.f.size() > 0) {
                object = aSN1.add(new ASN1(-95));
                this.f.sort((Comparator)new a());
                for (Object object2 : this.f) {
                    ((ASN1)object).add((ASN1)object2);
                }
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class SignedData {
        private byte a;
        private String b;
        private ContentInfo c;
        private X509CertificateCollection d;
        private ArrayList e;
        private SignerInfo f;
        private boolean g;
        private boolean h;

        public SignedData() {
            this.a = 1;
            this.c = new ContentInfo();
            this.d = new X509CertificateCollection();
            this.e = new ArrayList();
            this.f = new SignerInfo();
            this.g = true;
            this.h = false;
        }

        public SignedData(byte[] byArray) {
            this(new ASN1(byArray));
        }

        public SignedData(ASN1 aSN1) {
            int n2;
            if (aSN1.get_Item(0).getTag() != 48 || aSN1.get_Item(0).getCount() < 4) {
                throw new ArgumentException("Invalid SignedData");
            }
            if (aSN1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = aSN1.get_Item(0).get_Item(0).getValue()[0];
            this.c = new ContentInfo(aSN1.get_Item(0).get_Item(2));
            int n3 = 3;
            this.d = new X509CertificateCollection();
            if ((aSN1.get_Item(0).get_Item(n3).getTag() & 0xFF) == 160) {
                for (n2 = 0; n2 < aSN1.get_Item(0).get_Item(n3).getCount(); ++n2) {
                    this.d.add(new X509Certificate(aSN1.get_Item(0).get_Item(n3).get_Item(n2).getBytes()));
                }
                ++n3;
            }
            this.e = new ArrayList();
            if ((aSN1.get_Item(0).get_Item(n3).getTag() & 0xFF) == 161) {
                for (n2 = 0; n2 < aSN1.get_Item(0).get_Item(n3).getCount(); ++n2) {
                    this.e.addItem(aSN1.get_Item(0).get_Item(n3).get_Item(n2).getBytes());
                }
                ++n3;
            }
            this.f = aSN1.get_Item(0).get_Item(n3).getCount() > 0 ? new SignerInfo(aSN1.get_Item(0).get_Item(n3)) : new SignerInfo();
            if (this.f.getHashName() != null) {
                this.setHashName(this.a(this.f.getHashName()));
            }
            this.g = this.f.getAuthenticatedAttributes().size() > 0;
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public X509CertificateCollection getCertificates() {
            return this.d;
        }

        public ContentInfo getContentInfo() {
            return this.c;
        }

        public ArrayList getCrls() {
            return this.e;
        }

        public String getHashName() {
            return this.b;
        }

        public void setHashName(String string) {
            this.b = string;
            this.f.setHashName(string);
        }

        public SignerInfo getSignerInfo() {
            return this.f;
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte by2) {
            this.a = by2;
        }

        public boolean getUseAuthenticatedAttributes() {
            return this.g;
        }

        public void setUseAuthenticatedAttributes(boolean bl2) {
            this.g = bl2;
        }

        public boolean verifySignature(AsymmetricAlgorithm asymmetricAlgorithm) {
            if (asymmetricAlgorithm == null) {
                return false;
            }
            RSAPKCS1SignatureDeformatter rSAPKCS1SignatureDeformatter = new RSAPKCS1SignatureDeformatter(asymmetricAlgorithm);
            rSAPKCS1SignatureDeformatter.setHashAlgorithm(this.b);
            HashAlgorithm hashAlgorithm = HashAlgorithm.create(this.b);
            byte[] byArray = this.f.getSignature();
            byte[] byArray2 = null;
            if (this.g) {
                ASN1 aSN1 = new ASN1(49);
                for (ASN1 aSN12 : this.f.getAuthenticatedAttributes()) {
                    aSN1.add(aSN12);
                }
                byArray2 = hashAlgorithm.computeHash(aSN1.getBytes());
            } else {
                byArray2 = hashAlgorithm.computeHash(this.c.getContent().get_Item(0).getValue());
            }
            if (byArray2 != null && byArray != null) {
                return rSAPKCS1SignatureDeformatter.verifySignature(byArray2, byArray);
            }
            return false;
        }

        String a(String string) {
            switch (c.of(string)) {
                case 0: {
                    return "SHA1";
                }
                case 1: {
                    return "MD2";
                }
                case 2: {
                    return "MD5";
                }
                case 3: {
                    return "SHA256";
                }
                case 4: {
                    return "SHA384";
                }
                case 5: {
                    return "SHA512";
                }
            }
            return string;
        }

        ASN1 a() {
            Object object5;
            Object object2;
            Object object3;
            Object object4;
            ASN1 aSN1 = new ASN1(48);
            byte[] byArray = new byte[]{this.a};
            aSN1.add(new ASN1(2, byArray));
            ASN1 aSN12 = aSN1.add(new ASN1(49));
            if (this.b != null) {
                object4 = CryptoConfig.mapNameToOID(this.b);
                aSN12.add(PKCS7.algorithmIdentifier((String)object4));
            }
            object4 = this.c.get_ASN1();
            aSN1.add((ASN1)object4);
            if (!this.h && this.b != null) {
                if (this.g) {
                    object3 = PKCS7.attribute("1.2.840.113549.1.9.3", ((ASN1)object4).get_Item(0));
                    this.f.getAuthenticatedAttributes().addItem(object3);
                    object2 = HashAlgorithm.create(this.b);
                    object5 = ((HashAlgorithm)object2).computeHash(((ASN1)object4).get_Item(1).get_Item(0).getValue());
                    ASN1 aSN13 = new ASN1(48);
                    ASN1 aSN14 = PKCS7.attribute("1.2.840.113549.1.9.4", aSN13.add(new ASN1(4, (byte[])object5)));
                    this.f.getAuthenticatedAttributes().addItem(aSN14);
                } else {
                    object3 = new RSAPKCS1SignatureFormatter(this.f.getKey());
                    ((RSAPKCS1SignatureFormatter)object3).setHashAlgorithm(this.b);
                    object2 = HashAlgorithm.create(this.b);
                    object5 = ((HashAlgorithm)object2).computeHash(((ASN1)object4).get_Item(1).get_Item(0).getValue());
                    this.f.setSignature(((RSAPKCS1SignatureFormatter)object3).createSignature((byte[])object5));
                }
                this.h = true;
            }
            if (this.d.size() > 0) {
                object3 = aSN1.add(new ASN1(-96));
                for (Object object5 : this.d) {
                    ((ASN1)object3).add(new ASN1(((X509Certificate)object5).getRawData()));
                }
            }
            if (this.e.size() > 0) {
                object3 = aSN1.add(new ASN1(-95));
                object2 = this.e.iterator();
                while (object2.hasNext()) {
                    object5 = (byte[])object2.next();
                    ((ASN1)object3).add(new ASN1((byte[])object5));
                }
            }
            object3 = aSN1.add(new ASN1(49));
            if (this.f.getKey() != null) {
                ((ASN1)object3).add(this.f.getASN1_Rename_Namesake());
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class RecipientInfo {
        private int a;
        private String b;
        private byte[] c;
        private byte[] d;
        private String e;
        private byte[] f;

        public RecipientInfo() {
        }

        public RecipientInfo(ASN1 aSN1) {
            if (aSN1.getTag() != 48) {
                throw new ArgumentException("Invalid RecipientInfo");
            }
            ASN1 aSN12 = aSN1.get_Item(0);
            if (aSN12.getTag() != 2) {
                throw new ArgumentException("missing Version");
            }
            this.a = aSN12.getValue()[0] & 0xFF;
            ASN1 aSN13 = aSN1.get_Item(1);
            if ((aSN13.getTag() & 0xFF) == 128 && this.a == 3) {
                this.d = aSN13.getValue();
            } else {
                this.e = h.a(aSN13.get_Item(0));
                this.f = aSN13.get_Item(1).getValue();
            }
            ASN1 aSN14 = aSN1.get_Item(2);
            this.b = ASN1Convert.toOid(aSN14.get_Item(0));
            ASN1 aSN15 = aSN1.get_Item(3);
            this.c = aSN15.getValue();
        }

        public String getOid() {
            return this.b;
        }

        public byte[] getKey() {
            if (this.c == null) {
                return null;
            }
            return (byte[])this.c.clone();
        }

        public byte[] getSubjectKeyIdentifier() {
            if (this.d == null) {
                return null;
            }
            return (byte[])this.d.clone();
        }

        public String getIssuer() {
            return this.e;
        }

        public byte[] getSerial() {
            if (this.f == null) {
                return null;
            }
            return (byte[])this.f.clone();
        }

        public int getVersion() {
            return this.a;
        }
    }

    public static class EnvelopedData {
        private byte a = 0;
        private ContentInfo b = new ContentInfo();
        private ContentInfo c = new ContentInfo();
        private ArrayList d = new ArrayList();
        private byte[] e;

        public EnvelopedData() {
        }

        public EnvelopedData(byte[] byArray) {
            this(new ASN1(byArray));
        }

        public EnvelopedData(ASN1 aSN1) {
            this();
            ASN1 aSN12;
            if (aSN1.get_Item(0).getTag() != 48 || aSN1.get_Item(0).getCount() < 3) {
                throw new ArgumentException("Invalid EnvelopedData");
            }
            if (aSN1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = aSN1.get_Item(0).get_Item(0).getValue()[0];
            ASN1 aSN13 = aSN1.get_Item(0).get_Item(1);
            if (aSN13.getTag() != 49) {
                throw new ArgumentException("missing RecipientInfos");
            }
            for (int i2 = 0; i2 < aSN13.getCount(); ++i2) {
                aSN12 = aSN13.get_Item(i2);
                this.d.addItem(new RecipientInfo(aSN12));
            }
            ASN1 aSN14 = aSN1.get_Item(0).get_Item(2);
            if (aSN14.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo");
            }
            aSN12 = aSN14.get_Item(0);
            if (aSN12.getTag() != 6) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentType");
            }
            this.b = new ContentInfo(ASN1Convert.toOid(aSN12));
            ASN1 aSN15 = aSN14.get_Item(1);
            if (aSN15.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentEncryptionAlgorithmIdentifier");
            }
            this.c = new ContentInfo(ASN1Convert.toOid(aSN15.get_Item(0)));
            this.c.setContent(aSN15.get_Item(1));
            ASN1 aSN16 = aSN14.get_Item(2);
            if ((aSN16.getTag() & 0xFF) != 128) {
                throw new ArgumentException("missing EncryptedContentInfo.EncryptedContent");
            }
            this.e = aSN16.getValue();
        }

        public ArrayList getRecipientInfos() {
            return this.d;
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ContentInfo getContentInfo() {
            return this.b;
        }

        public ContentInfo getEncryptionAlgorithm() {
            return this.c;
        }

        public byte[] getEncryptedContent() {
            if (this.e == null) {
                return null;
            }
            return (byte[])this.e.clone();
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte by2) {
            this.a = by2;
        }

        ASN1 a() {
            ASN1 aSN1 = new ASN1(48);
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class EncryptedData {
        private byte a = 0;
        private ContentInfo b;
        private ContentInfo c;
        private byte[] d;

        public EncryptedData() {
        }

        public EncryptedData(byte[] byArray) {
            this(new ASN1(byArray));
        }

        public EncryptedData(ASN1 aSN1) {
            this();
            if (aSN1.getTag() != 48 || aSN1.getCount() < 2) {
                throw new ArgumentException("Invalid EncryptedData");
            }
            if (aSN1.get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = aSN1.get_Item(0).getValue()[0];
            ASN1 aSN12 = aSN1.get_Item(1);
            if (aSN12.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo");
            }
            ASN1 aSN13 = aSN12.get_Item(0);
            if (aSN13.getTag() != 6) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentType");
            }
            this.b = new ContentInfo(ASN1Convert.toOid(aSN13));
            ASN1 aSN14 = aSN12.get_Item(1);
            if (aSN14.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentEncryptionAlgorithmIdentifier");
            }
            this.c = new ContentInfo(ASN1Convert.toOid(aSN14.get_Item(0)));
            this.c.setContent(aSN14.get_Item(1));
            ASN1 aSN15 = aSN12.get_Item(2);
            if ((aSN15.getTag() & 0xFF) != 128) {
                throw new ArgumentException("missing EncryptedContentInfo.EncryptedContent");
            }
            this.d = aSN15.getValue();
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ContentInfo getContentInfo() {
            return this.b;
        }

        public ContentInfo getEncryptionAlgorithm() {
            return this.c;
        }

        public byte[] getEncryptedContent() {
            if (this.d == null) {
                return null;
            }
            return (byte[])this.d.clone();
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte by2) {
            this.a = by2;
        }

        ASN1 a() {
            return null;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class ContentInfo {
        private String a;
        private ASN1 b;

        public ContentInfo() {
            this.b = new ASN1(-96);
        }

        public ContentInfo(String string) {
            this();
            this.a = string;
        }

        public ContentInfo(byte[] byArray) {
            this(new ASN1(byArray));
        }

        public ContentInfo(ASN1 aSN1) {
            if (aSN1.getTag() != 48 || aSN1.getCount() < 1 && aSN1.getCount() > 2) {
                throw new ArgumentException("Invalid ASN1");
            }
            if (aSN1.get_Item(0).getTag() != 6) {
                throw new ArgumentException("Invalid contentType");
            }
            this.a = ASN1Convert.toOid(aSN1.get_Item(0));
            if (aSN1.getCount() > 1) {
                if ((aSN1.get_Item(1).getTag() & 0xFF) != 160) {
                    throw new ArgumentException("Invalid content");
                }
                this.b = aSN1.get_Item(1);
            }
        }

        public ASN1 get_ASN1() {
            return this.a();
        }

        public ASN1 getContent() {
            return this.b;
        }

        public void setContent(ASN1 aSN1) {
            this.b = aSN1;
        }

        public String getContentType() {
            return this.a;
        }

        public void setContentType(String string) {
            this.a = string;
        }

        ASN1 a() {
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(ASN1Convert.fromOid(this.a));
            if (this.b != null && this.b.getCount() > 0) {
                aSN1.add(this.b);
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class Oid {
        public static final String RSA_ENCRYPTION = "1.2.840.113549.1.1.1";
        public static final String DATA = "1.2.840.113549.1.7.1";
        public static final String SIGNED_DATA = "1.2.840.113549.1.7.2";
        public static final String ENVELOPED_DATA = "1.2.840.113549.1.7.3";
        public static final String SIGNED_AND_ENVELOPED_DATA = "1.2.840.113549.1.7.4";
        public static final String DIGESTED_DATA = "1.2.840.113549.1.7.5";
        public static final String ENCRYPTED_DATA = "1.2.840.113549.1.7.6";
        public static final String CONTENT_TYPE = "1.2.840.113549.1.9.3";
        public static final String MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
        public static final String SIGNING_TIME = "1.2.840.113549.1.9.5";
        public static final String COUNTERSIGNATURE = "1.2.840.113549.1.9.6";
    }
}

