/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.CollectionBase;
import com.aspose.html.utils.ms.System.Collections.IEnumerable;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.core.logger.Log4jLogger;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

public final class X509ExtensionCollection
extends CollectionBase
implements IEnumerable {
    private boolean a;

    public X509ExtensionCollection() {
    }

    public X509ExtensionCollection(ASN1 aSN1) {
        this();
        this.a = true;
        if (aSN1 == null) {
            return;
        }
        if (aSN1.getTag() != 48) {
            throw new Exception("Invalid extensions format");
        }
        for (int i2 = 0; i2 < aSN1.getCount(); ++i2) {
            X509Extension x509Extension = new X509Extension(aSN1.get_Item(i2));
            this.getInnerList().addItem(x509Extension);
        }
    }

    public int getExtensions(X509Extension x509Extension) {
        if (x509Extension == null) {
            throw new ArgumentNullException("extension");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        return this.getInnerList().addItem(x509Extension);
    }

    public void addRange(X509Extension[] x509ExtensionArray) {
        if (x509ExtensionArray == null) {
            throw new ArgumentNullException("extension");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        for (int i2 = 0; i2 < x509ExtensionArray.length; ++i2) {
            this.getInnerList().addItem(x509ExtensionArray[i2]);
        }
    }

    public void addRange(X509ExtensionCollection x509ExtensionCollection) {
        if (x509ExtensionCollection == null) {
            throw new ArgumentNullException("collection");
        }
        if (this.a) {
            throw new NotSupportedException("Extensions are read only");
        }
        for (int i2 = 0; i2 < x509ExtensionCollection.getInnerList().size(); ++i2) {
            this.getInnerList().addItem(x509ExtensionCollection.get_Item(i2));
        }
    }

    public boolean contains(X509Extension x509Extension) {
        return this.indexOf(x509Extension) != -1;
    }

    public boolean contains(String string) {
        return this.indexOf(string) != -1;
    }

    public void copyTo(X509Extension[] x509ExtensionArray, int n2) {
        if (x509ExtensionArray == null) {
            throw new ArgumentNullException("extensions");
        }
        this.getInnerList().copyTo(Array.boxing(x509ExtensionArray), n2);
    }

    public int indexOf(X509Extension x509Extension) {
        if (x509Extension == null) {
            throw new ArgumentNullException("extension");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension2 = (X509Extension)this.getInnerList().get_Item(i2);
            if (!x509Extension2.equals(x509Extension)) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(String string) {
        if (string == null) {
            throw new ArgumentNullException("oid");
        }
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension = (X509Extension)this.getInnerList().get_Item(i2);
            if (!StringExtensions.equals(x509Extension.getOid(), string)) continue;
            return i2;
        }
        return -1;
    }

    public void insert(int n2, X509Extension x509Extension) {
        if (x509Extension == null) {
            throw new ArgumentNullException("extension");
        }
        this.getInnerList().insertItem(n2, x509Extension);
    }

    public void remove(X509Extension x509Extension) {
        if (x509Extension == null) {
            throw new ArgumentNullException("extension");
        }
        this.getInnerList().removeItem(x509Extension);
    }

    public void remove(String string) {
        if (string == null) {
            throw new ArgumentNullException("oid");
        }
        int n2 = this.indexOf(string);
        if (n2 != -1) {
            this.getInnerList().removeAt(n2);
        }
    }

    @Override
    public IEnumerator iterator() {
        return this.getInnerList().iterator();
    }

    @Override
    public X509Extension get_Item(int n2) {
        return (X509Extension)this.getInnerList().get_Item(n2);
    }

    public X509Extension get_Item(String string) {
        int n2 = this.indexOf(string);
        if (n2 == -1) {
            return null;
        }
        return (X509Extension)this.getInnerList().get_Item(n2);
    }

    public byte[] getBytes() {
        if (this.getInnerList().size() < 1) {
            return null;
        }
        ASN1 aSN1 = new ASN1(48);
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Extension x509Extension = (X509Extension)this.getInnerList().get_Item(i2);
            aSN1.add(x509Extension.getASN1());
        }
        return aSN1.getBytes();
    }

    public static X509ExtensionCollection fromJava(X509Certificate x509Certificate) {
        X509ExtensionCollection x509ExtensionCollection = new X509ExtensionCollection();
        x509ExtensionCollection.addRange(X509ExtensionCollection.a(x509Certificate, x509Certificate.getCriticalExtensionOIDs(), true));
        x509ExtensionCollection.addRange(X509ExtensionCollection.a(x509Certificate, x509Certificate.getNonCriticalExtensionOIDs(), false));
        return x509ExtensionCollection;
    }

    private static X509Extension[] a(X509Certificate x509Certificate, Set<String> set, boolean bl2) {
        HashSet<X509Extension> hashSet = new HashSet<X509Extension>();
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                try {
                    if (x509Certificate.getExtensionValue(string) == null) continue;
                    hashSet.add(X509Extension.fromJava((byte[])x509Certificate.getExtensionValue(string).clone(), string, bl2));
                }
                catch (java.lang.Exception exception) {
                    Log4jLogger.debug(exception.toString(), exception);
                }
            }
        }
        return hashSet.toArray(new X509Extension[0]);
    }
}

