/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSecureRandom;
import com.aspose.html.utils.ms.core.bc.crypto.internal.KeyGenerationParameters;
import java.security.SecureRandom;

class CipherKeyGenerator {
    protected SecureRandom random;
    protected int strength;

    CipherKeyGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.strength = (keyGenerationParameters.getStrength() + 7) / 8;
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[this.strength];
        if (this.random instanceof FipsSecureRandom) {
            FipsSecureRandom fipsSecureRandom = (FipsSecureRandom)this.random;
            fipsSecureRandom.reseed();
            fipsSecureRandom.nextBytes(byArray);
        } else {
            this.random.nextBytes(byArray);
        }
        return byArray;
    }
}

