/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.math.ec.ECAlgorithms;
import com.aspose.html.utils.ms.core.bc.math.ec.ECPoint;
import java.math.BigInteger;

class EcDhcBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhcBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        if (!ecDomainParameters.equals(ecPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("ECCDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = ecDomainParameters.getH().multiply(this.key.getD()).mod(ecDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(ecDomainParameters.getCurve(), ecPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECCDH");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECCDH");
        }
        return eCPoint2.getAffineXCoord().toBigInteger();
    }
}

