/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.internal.macs;

import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DataLengthException;
import com.aspose.html.utils.ms.core.bc.crypto.internal.InvalidCipherTextException;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AEADParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.ParametersWithIV;

public class AEADCipherMac
implements Mac {
    private final AEADBlockCipher aeadCipher;
    private final int macLenInBits;

    public AEADCipherMac(AEADBlockCipher aEADBlockCipher, int n2) {
        this.aeadCipher = aEADBlockCipher;
        this.macLenInBits = n2;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("AEAD cipher based MAC needs nonce/IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        this.aeadCipher.init(true, new AEADParameters((KeyParameter)parametersWithIV.getParameters(), this.macLenInBits, parametersWithIV.getIV()));
    }

    public String getAlgorithmName() {
        return this.aeadCipher.getAlgorithmName() + "MAC";
    }

    public int getMacSize() {
        return (this.macLenInBits + 7) / 8;
    }

    public void update(byte by2) throws IllegalStateException {
        this.aeadCipher.processAADByte(by2);
    }

    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.aeadCipher.processAADBytes(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        try {
            return this.aeadCipher.doFinal(byArray, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException("Unable to create MAC tag:" + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public void reset() {
        this.aeadCipher.reset();
    }
}

