/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.pkix;

import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectKeyIdentifier;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cms.KeyTransRecipientId;
import com.aspose.html.utils.ms.core.bc.cms.RecipientId;

public class PKIXIdentity {
    private final PrivateKeyInfo privateKeyInfo;
    private final X509CertificateHolder[] certificateHolders;

    public PKIXIdentity(PrivateKeyInfo privateKeyInfo, X509CertificateHolder[] x509CertificateHolderArray) {
        this.privateKeyInfo = privateKeyInfo;
        this.certificateHolders = new X509CertificateHolder[x509CertificateHolderArray.length];
        System.arraycopy(x509CertificateHolderArray, 0, this.certificateHolders, 0, x509CertificateHolderArray.length);
    }

    public PKIXIdentity(PrivateKeyInfo privateKeyInfo, X509CertificateHolder x509CertificateHolder) {
        this(privateKeyInfo, new X509CertificateHolder[]{x509CertificateHolder});
    }

    public PrivateKeyInfo getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    public X509CertificateHolder getCertificate() {
        return this.certificateHolders[0];
    }

    public X509CertificateHolder[] getCertificateChain() {
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[this.certificateHolders.length];
        System.arraycopy(this.certificateHolders, 0, x509CertificateHolderArray, 0, x509CertificateHolderArray.length);
        return x509CertificateHolderArray;
    }

    public RecipientId getRecipientId() {
        return new KeyTransRecipientId(this.certificateHolders[0].getIssuer(), this.certificateHolders[0].getSerialNumber(), this.getSubjectKeyIdentifier());
    }

    private byte[] getSubjectKeyIdentifier() {
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions(this.certificateHolders[0].getExtensions());
        if (subjectKeyIdentifier == null) {
            return null;
        }
        return subjectKeyIdentifier.getKeyIdentifier();
    }
}

