/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.helpers.streams;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.IO.MemoryStream;
import com.aspose.html.utils.ms.helpers.streams.LoadFromStreamAspect;
import com.aspose.html.utils.ms.helpers.streams.SaveToStreamAspect;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class StreamUtil {
    public static final int BufferSize = 65536;

    public static MemoryStream copyStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("srcStream");
        }
        MemoryStream memoryStream = new MemoryStream();
        byte[] byArray = new byte[65536];
        while (true) {
            int n2 = 0;
            try {
                n2 = inputStream.read(byArray, 0, byArray.length);
            }
            catch (java.io.IOException iOException) {
                if (inputStream instanceof PipedInputStream && iOException.getMessage() != null && "write end dead".startsWith(iOException.getMessage().toLowerCase())) {
                    n2 = -1;
                }
                throw new IOException("exception", iOException);
            }
            if (n2 <= 0) break;
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.setPosition(0L);
        return memoryStream;
    }

    public static MemoryStream copyStream(Stream stream) {
        int n2;
        if (stream == null) {
            throw new NullPointerException("srcStream");
        }
        MemoryStream memoryStream = new MemoryStream();
        byte[] byArray = new byte[65536];
        while ((n2 = stream.read(byArray, 0, byArray.length)) > 0) {
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.setPosition(0L);
        return memoryStream;
    }

    public static void copyStream(Stream stream, OutputStream outputStream) {
        StreamUtil.copyStream(stream, outputStream, 0L);
    }

    public static void copyStream(Stream stream, OutputStream outputStream, long l2) {
        int n2;
        if (stream == null) {
            throw new NullPointerException("srcStream");
        }
        if (outputStream == null) {
            throw new NullPointerException("dstStream");
        }
        long l3 = stream.getPosition();
        stream.setPosition(l2);
        byte[] byArray = new byte[65536];
        while ((n2 = stream.read(byArray, 0, byArray.length)) != 0) {
            try {
                outputStream.write(byArray, 0, n2);
            }
            catch (java.io.IOException iOException) {
                throw new IOException("exception", iOException);
            }
        }
        stream.setPosition(l3);
    }

    public static void copyStream(Stream stream, Stream stream2) {
        int n2;
        if (stream == null) {
            throw new NullPointerException("srcStream");
        }
        if (stream2 == null) {
            throw new NullPointerException("dstStream");
        }
        long l2 = stream.getPosition();
        stream.setPosition(0L);
        byte[] byArray = new byte[65536];
        while ((n2 = stream.read(byArray, 0, byArray.length)) != 0) {
            stream2.write(byArray, 0, n2);
        }
        stream.setPosition(l2);
    }

    public static <T> T invoke(LoadFromStreamAspect<T> loadFromStreamAspect) {
        return loadFromStreamAspect.exec();
    }

    public static void invoke(SaveToStreamAspect saveToStreamAspect) {
        saveToStreamAspect.exec();
    }
}

