/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;

public class DHDomainParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private final BigInteger g;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private final int l;
    private final DHValidationParameters validation;

    private static int getDefaultMParam(int n2) {
        if (n2 == 0) {
            return 160;
        }
        return n2 < 160 ? n2 : 160;
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, null, bigInteger2, 0);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        this(bigInteger, null, bigInteger2, n2);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        this(bigInteger, bigInteger2, bigInteger3, DHDomainParameters.getDefaultMParam(n2), n2, null, null);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2, int n3) {
        this(bigInteger, bigInteger2, bigInteger3, n2, n3, null, null);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, 160, 0, bigInteger4, dHValidationParameters);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, DHDomainParameters.getDefaultMParam(n2), n2, null, dHValidationParameters);
    }

    public DHDomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2, int n3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n3 != 0) {
            BigInteger bigInteger5 = BigInteger.valueOf(2L ^ (long)(n3 - 1));
            if (bigInteger5.compareTo(bigInteger) == 1) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = bigInteger3;
        this.p = bigInteger;
        this.q = bigInteger2;
        this.m = n2;
        this.l = n3;
        this.j = bigInteger4;
        this.validation = dHValidationParameters;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHDomainParameters)) {
            return false;
        }
        DHDomainParameters dHDomainParameters = (DHDomainParameters)object;
        return dHDomainParameters.getP().equals(this.p) && dHDomainParameters.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode();
    }
}

