/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final Ed448 ed448 = new Ed448(){

        public Xof createXof() {
            return (Xof)Register.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };
    private final byte[] data = new byte[57];

    public Ed448PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        this.ed448.generatePrivateKey(secureRandom, this.data);
    }

    public Ed448PrivateKeyParameters(byte[] byArray, int n2) {
        super(true);
        System.arraycopy(byArray, n2, this.data, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream inputStream) throws IOException {
        super(true);
        if (57 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 private key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed448PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[57];
        this.ed448.generatePublicKey(this.data, 0, byArray, 0);
        return new Ed448PublicKeyParameters(byArray, 0);
    }

    public void sign(int n2, Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5) {
        byte[] byArray4 = new byte[57];
        if (null == ed448PublicKeyParameters) {
            this.ed448.generatePublicKey(this.data, 0, byArray4, 0);
        } else {
            ed448PublicKeyParameters.encode(byArray4, 0);
        }
        switch (n2) {
            case 0: {
                this.ed448.sign(this.data, 0, byArray4, 0, byArray, byArray2, n3, n4, byArray3, n5);
                break;
            }
            case 1: {
                if (64 != n4) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed448.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n3, byArray3, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

