/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.Utils;

public class XofOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Xof digest;

    public XofOutputStream(Xof xof) {
        this.algorithmName = xof.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = xof;
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(byArray, n2, n3);
    }

    public final int getOutput(byte[] byArray, int n2, int n3) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doOutput(byArray, n2, n3);
    }

    public void reset() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.reset();
    }
}

