/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.signers;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class BaseRsaDigestSigner
implements Signer {
    private final AsymmetricBlockCipher rsaEngine;
    private final AlgorithmIdentifier algId;
    private final Digest digest;
    private boolean forSigning;

    public BaseRsaDigestSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.rsaEngine = asymmetricBlockCipher;
        this.digest = digest;
        this.algId = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.rsaEngine.init(bl2, cipherParameters);
    }

    public void update(byte by2) {
        this.digest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("RsaDigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.derEncode(byArray);
            return this.rsaEngine.processBlock(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }

    public boolean verifySignature(byte[] byArray) throws InvalidSignatureException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.forSigning) {
            throw new IllegalStateException("RsaDigestSigner not initialised for verification");
        }
        byte[] byArray4 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray4, 0);
        try {
            byArray3 = this.rsaEngine.processBlock(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray4);
        }
        catch (Exception exception) {
            throw new InvalidSignatureException("Unable to process signature: " + exception.getMessage(), exception);
        }
        return BaseRsaDigestSigner.checkPKCS1Sig(byArray2, byArray3);
    }

    public void reset() {
        this.digest.reset();
    }

    private byte[] derEncode(byte[] byArray) throws IOException {
        DigestInfo digestInfo = new DigestInfo(this.algId, byArray);
        return digestInfo.getEncoded("DER");
    }

    public static boolean checkPKCS1Sig(byte[] byArray, byte[] byArray2) {
        if (byArray2.length == byArray.length) {
            return Arrays.constantTimeAreEqual(byArray, byArray2);
        }
        if (byArray2.length == byArray.length - 2) {
            int n2;
            byArray[1] = (byte)(byArray[1] - 2);
            byArray[3] = (byte)(byArray[3] - 2);
            int n3 = 4 + byArray[3];
            int n4 = n3 + 2;
            int n5 = 0;
            for (n2 = 0; n2 < byArray.length - n4; ++n2) {
                n5 |= byArray2[n3 + n2] ^ byArray[n4 + n2];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n5 |= byArray2[n2] ^ byArray[n2];
            }
            return n5 == 0;
        }
        Arrays.constantTimeAreEqual(byArray, byArray);
        return false;
    }
}

