/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.signers;

import java.math.BigInteger;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.util.ISOTrailers;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BaseX931Signer
implements Signer {
    public static final int TRAILER_IMPLICIT = 188;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private RsaKeyParameters kParam;
    private int trailer;
    private int keyBits;
    private byte[] block;

    public BaseX931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl2) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        if (bl2) {
            this.trailer = 188;
        } else {
            Integer n2 = ISOTrailers.getTrailer(digest);
            if (n2 != null) {
                this.trailer = n2;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.kParam = cipherParameters instanceof ParametersWithRandom ? (RsaKeyParameters)((ParametersWithRandom)cipherParameters).getParameters() : (RsaKeyParameters)cipherParameters;
        this.cipher.init(bl2, cipherParameters);
        this.keyBits = this.kParam.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    public void update(byte by2) {
        this.digest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public void reset() {
        this.digest.reset();
    }

    public byte[] generateSignature() throws CryptoException {
        this.createSignatureBlock(this.trailer);
        BigInteger bigInteger = new BigInteger(1, this.cipher.processBlock(this.block, 0, this.block.length));
        this.clearBlock(this.block);
        bigInteger = bigInteger.min(this.kParam.getModulus().subtract(bigInteger));
        return BigIntegers.asUnsignedByteArray((this.kParam.getModulus().bitLength() + 7) / 8, bigInteger);
    }

    private void createSignatureBlock(int n2) {
        int n3;
        int n4 = this.digest.getDigestSize();
        if (n2 == 188) {
            n3 = this.block.length - n4 - 1;
            this.digest.doFinal(this.block, n3);
            this.block[this.block.length - 1] = -68;
        } else {
            n3 = this.block.length - n4 - 2;
            this.digest.doFinal(this.block, n3);
            this.block[this.block.length - 2] = (byte)(n2 >>> 8);
            this.block[this.block.length - 1] = (byte)n2;
        }
        this.block[0] = 107;
        for (int i2 = n3 - 2; i2 != 0; --i2) {
            this.block[i2] = -69;
        }
        this.block[n3 - 1] = -70;
    }

    public boolean verifySignature(byte[] byArray) {
        BigInteger bigInteger;
        try {
            this.block = this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, this.block);
        if ((bigInteger2.intValue() & 0xF) == 12) {
            bigInteger = bigInteger2;
        } else {
            bigInteger2 = this.kParam.getModulus().subtract(bigInteger2);
            if ((bigInteger2.intValue() & 0xF) == 12) {
                bigInteger = bigInteger2;
            } else {
                return false;
            }
        }
        this.createSignatureBlock(this.trailer);
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(this.block.length, bigInteger);
        boolean bl2 = Arrays.constantTimeAreEqual(this.block, byArray2);
        if (this.trailer == 15052 && !bl2) {
            this.block[this.block.length - 2] = 64;
            bl2 = Arrays.constantTimeAreEqual(this.block, byArray2);
        }
        this.clearBlock(this.block);
        this.clearBlock(byArray2);
        return bl2;
    }
}

