/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.Poly1305;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;

final class ProvPoly1305
extends AlgorithmProvider {
    private static final String PREFIX = ProvPoly1305.class.getName();

    ProvPoly1305() {
    }

    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.POLY1305", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "POLY1305", 256, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new Poly1305.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        ProvPoly1305.addKeyGenAlias(bouncyCastleFipsProvider, "AES");
        ProvPoly1305.addKeyGenAlias(bouncyCastleFipsProvider, "CAMELLIA");
        ProvPoly1305.addKeyGenAlias(bouncyCastleFipsProvider, "SEED");
        ProvPoly1305.addKeyGenAlias(bouncyCastleFipsProvider, "SERPENT");
        ProvPoly1305.addKeyGenAlias(bouncyCastleFipsProvider, "TWOFISH");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305", PREFIX + "POLY1305", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MAC, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305-AES", PREFIX + "POLY1305-AES", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MACwithAES, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MACwithAES));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "POLY1305-AES", "POLY1305AES");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305-CAMELLIA", PREFIX + "POLY1305-CAMELLIA", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MACwithCAMELLIA, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MACwithCAMELLIA));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "POLY1305-CAMELLIA", "POLY1305CAMELLIA");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305-SEED", PREFIX + "POLY1305-SEED", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MACwithSEED, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MACwithSEED));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "POLY1305-SEED", "POLY1305SEED");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305-SERPENT", PREFIX + "POLY1305-SERPENT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MACwithSerpent, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MACwithSerpent));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "POLY1305-SERPENT", "POLY1305SERPENT");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.POLY1305-TWOFISH", PREFIX + "POLY1305-TWOFISH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Poly1305.MACwithTwofish, (MACOperatorFactory)new Poly1305.MACOperatorFactory(), new AuthParametersCreator(Poly1305.MACwithTwofish));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "POLY1305-TWOFISH", "POLY1305TWOFISH");
    }

    private static void addKeyGenAlias(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string) {
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "POLY1305", "POLY1305-" + string, "POLY1305" + string);
    }
}

