/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.internal.Interleave;
import org.bouncycastle.math.internal.Nat256;

class SecT233Field {
    private static final long M41 = 0x1FFFFFFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    SecT233Field() {
    }

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
        lArray3[7] = lArray[7] ^ lArray2[7];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat256.fromBigInteger64(bigInteger);
        SecT233Field.reduce23(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat256.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat256.create64();
        long[] lArray4 = Nat256.create64();
        SecT233Field.square(lArray, lArray3);
        SecT233Field.multiply(lArray3, lArray, lArray3);
        SecT233Field.square(lArray3, lArray3);
        SecT233Field.multiply(lArray3, lArray, lArray3);
        SecT233Field.squareN(lArray3, 3, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.square(lArray4, lArray4);
        SecT233Field.multiply(lArray4, lArray, lArray4);
        SecT233Field.squareN(lArray4, 7, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.squareN(lArray3, 14, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.square(lArray4, lArray4);
        SecT233Field.multiply(lArray4, lArray, lArray4);
        SecT233Field.squareN(lArray4, 29, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.squareN(lArray3, 58, lArray4);
        SecT233Field.multiply(lArray4, lArray3, lArray4);
        SecT233Field.squareN(lArray4, 116, lArray3);
        SecT233Field.multiply(lArray3, lArray4, lArray3);
        SecT233Field.square(lArray3, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        long l6 = lArray[4];
        long l7 = lArray[5];
        long l8 = lArray[6];
        long l9 = lArray[7];
        l5 ^= l9 << 23;
        l6 ^= l9 >>> 41 ^ l9 << 33;
        l4 ^= l8 << 23;
        l5 ^= l8 >>> 41 ^ l8 << 33;
        l3 ^= (l7 ^= l9 >>> 31) << 23;
        l4 ^= l7 >>> 41 ^ l7 << 33;
        long l10 = (l5 ^= l7 >>> 31) >>> 41;
        lArray2[0] = (l2 ^= (l6 ^= l8 >>> 31) << 23) ^ l10;
        lArray2[1] = (l3 ^= l6 >>> 41 ^ l6 << 33) ^ l10 << 10;
        lArray2[2] = l4 ^= l6 >>> 31;
        lArray2[3] = l5 & 0x1FFFFFFFFFFL;
    }

    public static void reduce23(long[] lArray, int n2) {
        long l2 = lArray[n2 + 3];
        long l3 = l2 >>> 41;
        int n3 = n2;
        lArray[n3] = lArray[n3] ^ l3;
        int n4 = n2 + 1;
        lArray[n4] = lArray[n4] ^ l3 << 10;
        lArray[n2 + 3] = l2 & 0x1FFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l2 = Interleave.unshuffle(lArray[0]);
        long l3 = Interleave.unshuffle(lArray[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(lArray[2]);
        l3 = Interleave.unshuffle(lArray[3]);
        long l6 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l7 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        long l8 = l7 >>> 27;
        l7 ^= l5 >>> 27 | l7 << 37;
        l5 ^= l5 << 37;
        long[] lArray3 = Nat256.createExt64();
        int[] nArray = new int[]{32, 117, 191};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2] >>> 6;
            int n3 = nArray[i2] & 0x3F;
            int n4 = n2;
            lArray3[n4] = lArray3[n4] ^ l5 << n3;
            int n5 = n2 + 1;
            lArray3[n5] = lArray3[n5] ^ (l7 << n3 | l5 >>> -n3);
            int n6 = n2 + 2;
            lArray3[n6] = lArray3[n6] ^ (l8 << n3 | l7 >>> -n3);
            int n7 = n2 + 3;
            lArray3[n7] = lArray3[n7] ^ l8 >>> -n3;
        }
        SecT233Field.reduce(lArray3, lArray2);
        lArray2[0] = lArray2[0] ^ l4;
        lArray2[1] = lArray2[1] ^ l6;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n2, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
        while (--n2 > 0) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 31) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        long l6 = lArray[4];
        long l7 = lArray[5];
        long l8 = lArray[6];
        long l9 = lArray[7];
        lArray[0] = l2 ^ l3 << 59;
        lArray[1] = l3 >>> 5 ^ l4 << 54;
        lArray[2] = l4 >>> 10 ^ l5 << 49;
        lArray[3] = l5 >>> 15 ^ l6 << 44;
        lArray[4] = l6 >>> 20 ^ l7 << 39;
        lArray[5] = l7 >>> 25 ^ l8 << 34;
        lArray[6] = l8 >>> 30 ^ l9 << 29;
        lArray[7] = l9 >>> 35;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        lArray2[0] = l2 & 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = (l2 >>> 59 ^ l3 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = (l3 >>> 54 ^ l4 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l4 >>> 49 ^ l5 << 15;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        int n2;
        long[] lArray4 = new long[4];
        long[] lArray5 = new long[4];
        SecT233Field.implExpand(lArray, lArray4);
        SecT233Field.implExpand(lArray2, lArray5);
        SecT233Field.implMulwAcc(lArray4[0], lArray5[0], lArray3, 0);
        SecT233Field.implMulwAcc(lArray4[1], lArray5[1], lArray3, 1);
        SecT233Field.implMulwAcc(lArray4[2], lArray5[2], lArray3, 2);
        SecT233Field.implMulwAcc(lArray4[3], lArray5[3], lArray3, 3);
        for (n2 = 5; n2 > 0; --n2) {
            int n3 = n2;
            lArray3[n3] = lArray3[n3] ^ lArray3[n2 - 1];
        }
        SecT233Field.implMulwAcc(lArray4[0] ^ lArray4[1], lArray5[0] ^ lArray5[1], lArray3, 1);
        SecT233Field.implMulwAcc(lArray4[2] ^ lArray4[3], lArray5[2] ^ lArray5[3], lArray3, 3);
        for (n2 = 7; n2 > 1; --n2) {
            int n4 = n2;
            lArray3[n4] = lArray3[n4] ^ lArray3[n2 - 2];
        }
        long l2 = lArray4[0] ^ lArray4[2];
        long l3 = lArray4[1] ^ lArray4[3];
        long l4 = lArray5[0] ^ lArray5[2];
        long l5 = lArray5[1] ^ lArray5[3];
        SecT233Field.implMulwAcc(l2 ^ l3, l4 ^ l5, lArray3, 3);
        long[] lArray6 = new long[3];
        SecT233Field.implMulwAcc(l2, l4, lArray6, 0);
        SecT233Field.implMulwAcc(l3, l5, lArray6, 1);
        long l6 = lArray6[0];
        long l7 = lArray6[1];
        long l8 = lArray6[2];
        lArray3[2] = lArray3[2] ^ l6;
        lArray3[3] = lArray3[3] ^ (l6 ^ l7);
        lArray3[4] = lArray3[4] ^ (l8 ^ l7);
        lArray3[5] = lArray3[5] ^ l8;
        SecT233Field.implCompactExt(lArray3);
    }

    protected static void implMulwAcc(long l2, long l3, long[] lArray, int n2) {
        long[] lArray2 = new long[8];
        lArray2[1] = l3;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l3;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l3;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l3;
        int n3 = (int)l2;
        long l4 = 0L;
        long l5 = lArray2[n3 & 7] ^ lArray2[n3 >>> 3 & 7] << 3;
        int n4 = 54;
        do {
            n3 = (int)(l2 >>> n4);
            long l6 = lArray2[n3 & 7] ^ lArray2[n3 >>> 3 & 7] << 3;
            l5 ^= l6 << n4;
            l4 ^= l6 >>> -n4;
        } while ((n4 -= 6) > 0);
        int n5 = n2;
        lArray[n5] = lArray[n5] ^ l5 & 0x7FFFFFFFFFFFFFFL;
        int n6 = n2 + 1;
        lArray[n6] = lArray[n6] ^ (l5 >>> 59 ^ l4 << 5);
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        Interleave.expand64To128(lArray[2], lArray2, 4);
        long l2 = lArray[3];
        lArray2[6] = Interleave.expand32to64((int)l2);
        lArray2[7] = (long)Interleave.expand16to32((int)(l2 >>> 32)) & 0xFFFFFFFFL;
    }
}

