/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Encoder;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.decodingTable.length; ++n2) {
            this.decodingTable[n2] = -1;
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.decodingTable[this.encodingTable[n2]] = (byte)n2;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] byArray, int n2, int n3, OutputStream outputStream) throws IOException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            outputStream.write(this.encodingTable[n4 >>> 4]);
            outputStream.write(this.encodingTable[n4 & 0xF]);
        }
        return n3 * 2;
    }

    private static boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    public int decode(byte[] byArray, int n2, int n3, OutputStream outputStream) throws IOException {
        int n4;
        int n5 = 0;
        for (n4 = n2 + n3; n4 > n2 && HexEncoder.ignore((char)byArray[n4 - 1]); --n4) {
        }
        int n6 = n2;
        while (n6 < n4) {
            byte by2;
            while (n6 < n4 && HexEncoder.ignore((char)byArray[n6])) {
                ++n6;
            }
            byte by3 = this.decodingTable[byArray[n6++]];
            while (n6 < n4 && HexEncoder.ignore((char)byArray[n6])) {
                ++n6;
            }
            if ((by3 | (by2 = this.decodingTable[byArray[n6++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            outputStream.write(by3 << 4 | by2);
            ++n5;
        }
        return n5;
    }

    public int decode(String string, OutputStream outputStream) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = string.length(); n2 > 0 && HexEncoder.ignore(string.charAt(n2 - 1)); --n2) {
        }
        int n4 = 0;
        while (n4 < n2) {
            byte by2;
            while (n4 < n2 && HexEncoder.ignore(string.charAt(n4))) {
                ++n4;
            }
            byte by3 = this.decodingTable[string.charAt(n4++)];
            while (n4 < n2 && HexEncoder.ignore(string.charAt(n4))) {
                ++n4;
            }
            if ((by3 | (by2 = this.decodingTable[string.charAt(n4++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            outputStream.write(by3 << 4 | by2);
            ++n3;
        }
        return n3;
    }

    byte[] decodeStrict(String string, int n2, int n3) throws IOException {
        if (null == string) {
            throw new NullPointerException("'str' cannot be null");
        }
        if (n2 < 0 || n3 < 0 || n2 > string.length() - n3) {
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        if (0 != (n3 & 1)) {
            throw new IOException("a hexadecimal encoding must have an even number of characters");
        }
        int n4 = n3 >>> 1;
        byte[] byArray = new byte[n4];
        int n5 = n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by2;
            byte by3;
            int n6;
            if ((n6 = (by3 = this.decodingTable[string.charAt(n5++)]) << 4 | (by2 = this.decodingTable[string.charAt(n5++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            byArray[i2] = (byte)n6;
        }
        return byArray;
    }
}

