/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.StringExtensions;

public final class BooleanExtensions {
    public static final String FalseString = "False";
    public static final String TrueString = "True";

    public static int compareTo(boolean bl2, boolean bl3) {
        if (bl2 == bl3) {
            return 0;
        }
        return !bl2 ? -1 : 1;
    }

    public static int compareTo(boolean bl2, Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != Boolean.class) {
            throw new ArgumentException("Object is not a Boolean.");
        }
        boolean bl3 = Convert.toBoolean(object);
        if (bl2 && !bl3) {
            return 1;
        }
        return bl2 == bl3 ? 0 : -1;
    }

    public static boolean equals(boolean bl2, boolean bl3) {
        return bl2 == bl3;
    }

    public static boolean equals(boolean bl2, Object object) {
        if (object == null || object.getClass() != Boolean.class) {
            return false;
        }
        return Convert.toBoolean(object) == bl2;
    }

    public static int getHashCode(boolean bl2) {
        return bl2 ? 1 : 0;
    }

    public static int getTypeCode() {
        return 3;
    }

    public static boolean parse(String string) {
        if (string == null) {
            throw new ArgumentNullException("value");
        }
        if (StringExtensions.compare(string = StringExtensions.trim(string), TrueString, true, CultureInfo.getInvariantCulture()) == 0) {
            return true;
        }
        if (StringExtensions.compare(string, FalseString, true, CultureInfo.getInvariantCulture()) == 0) {
            return false;
        }
        throw new FormatException("Value is not equivalent to either TrueString or FalseString.");
    }

    public static boolean tryParse(String string, boolean[] blArray) {
        blArray[0] = false;
        if (string == null) {
            return false;
        }
        string = StringExtensions.trim(string);
        try {
            blArray[0] = BooleanExtensions.parse(string);
            return true;
        }
        catch (FormatException formatException) {
            return false;
        }
    }

    public static String toString(boolean bl2) {
        if (!bl2) {
            return FalseString;
        }
        return TrueString;
    }

    public static String toString(boolean bl2, IFormatProvider iFormatProvider) {
        return BooleanExtensions.toString(bl2);
    }
}

