/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Console;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.IO.File;
import com.aspose.html.utils.ms.System.IO.FileStream;
import com.aspose.html.utils.ms.System.IntPtr;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSA;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.utils.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.bc.BouncyCastleProviderHelper;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.PKCS7;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.b;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.c;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.h;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.a;
import com.aspose.html.utils.ms.core.Win32.Win32ErrorCodes;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.MSBC_PKCS12;
import com.aspose.html.utils.ms.lang.Struct;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;

public class X509Certificate {
    private String a;
    private String b;
    private com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate c;
    private boolean d;
    private byte[] e;

    public X509Certificate() {
    }

    public X509Certificate(byte[] byArray, String string) {
        this.import_(byArray, string, 0);
    }

    public X509Certificate(byte[] byArray, String string, int n2) {
        this.import_(byArray, string, n2);
    }

    public X509Certificate(String string) {
        this.import_(string, (String)null, 0);
    }

    public X509Certificate(String string, String string2) {
        this.import_(string, string2, 0);
    }

    public X509Certificate(String string, String string2, int n2) {
        this.import_(string, string2, n2);
    }

    public String getIssuer() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        if (this.a == null) {
            this.a = h.a(this.c.getIssuerName(), true, ", ", true);
        }
        return this.a;
    }

    public String getSubject() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        if (this.b == null) {
            this.b = h.a(this.c.getSubjectName(), true, ", ", true);
        }
        return this.b;
    }

    public IntPtr getHandle() {
        return IntPtr.Zero;
    }

    public boolean equals(Object object) {
        X509Certificate x509Certificate = object instanceof X509Certificate ? (X509Certificate)object : null;
        return x509Certificate != null && this.equals(x509Certificate);
    }

    public byte[] export(int n2) {
        return this.a(n2, null);
    }

    public byte[] export(int n2, String string) {
        byte[] byArray = string == null ? null : Encoding.getUTF8().getBytes(string);
        return this.a(n2, byArray);
    }

    byte[] a(int n2, byte[] byArray) {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        try {
            switch (n2) {
                case 1: {
                    byte[] byArray2 = this.c.getRawData();
                    return byArray2;
                }
                case 3: {
                    throw new NotSupportedException();
                }
                case 2: {
                    throw new NotSupportedException();
                }
            }
            String string = StringExtensions.format("This certificate format '{0}' cannot be exported.", n2);
            throw new CryptographicException(string);
        }
        finally {
            if (byArray != null) {
                msArray.clear(byArray, 0, byArray.length);
            }
        }
    }

    public void import_(byte[] byArray) {
        this.import_(byArray, (String)null, 0);
    }

    public void import_(byte[] byArray, String string, int n2) {
        this.reset();
        if (string == null) {
            try {
                this.c = new com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate(byArray);
            }
            catch (Exception exception) {
                try {
                    com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate[] x509CertificateArray = PKCS7.loadCertificates(byArray);
                    this.c = x509CertificateArray.length > 0 ? x509CertificateArray[0] : null;
                }
                catch (Exception exception2) {
                    try {
                        c c2 = new c(byArray);
                        if (c2.d().size() > 0) {
                            this.c = c2.d().get_Item(0);
                        }
                        this.c = null;
                    }
                    catch (Exception exception3) {
                        String string2 = StringExtensions.format("Unable to decode certificate.", new Object[0]);
                        throw new CryptographicException(string2, exception3);
                    }
                }
            }
        } else {
            try {
                c c3 = new c(byArray, string);
                this.c = c3.d().size() > 0 ? c3.d().get_Item(0) : null;
            }
            catch (b b2) {
                String string3 = Win32ErrorCodes.getErrorMessage(86);
                throw new CryptographicException(string3);
            }
            catch (Exception exception) {
                this.c = this.getX509Certificate(byArray, string);
            }
        }
    }

    protected com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate getX509Certificate(byte[] byArray, String string) {
        com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate x509Certificate;
        block2: {
            try {
                x509Certificate = new com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate(byArray);
            }
            catch (Exception exception) {
                x509Certificate = X509Certificate.a(byArray, string);
                if (x509Certificate != null) break block2;
                throw new RuntimeException(exception);
            }
        }
        return x509Certificate;
    }

    private static com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate a(byte[] byArray, String string) {
        char[] cArray = string.toCharArray();
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string.toCharArray());
        try {
            java.security.cert.X509Certificate x509Certificate;
            PrivateKey privateKey;
            Object object;
            Object object2;
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new ByteArrayInputStream(byArray), cArray);
            Enumeration enumeration = keyStore.aliases();
            boolean bl2 = enumeration.hasMoreElements();
            if (!bl2) {
                object2 = new MSBC_PKCS12.BCPKCS12KeyStore3DES((BouncyCastleFipsProvider)BouncyCastleProviderHelper.getBCProvider());
                ((MSBC_PKCS12.BCPKCS12KeyStore3DES)object2).engineLoad(new ByteArrayInputStream(byArray), cArray);
                enumeration = ((MSBC_PKCS12.BCPKCS12KeyStore3DES)object2).engineAliases();
                bl2 = enumeration.hasMoreElements();
                String string2 = (String)enumeration.nextElement();
                object = (KeyStore.PrivateKeyEntry)((KeyStoreSpi)object2).engineGetEntry(string2, passwordProtection);
                privateKey = ((KeyStore.PrivateKeyEntry)object).getPrivateKey();
                x509Certificate = (java.security.cert.X509Certificate)((MSBC_PKCS12.BCPKCS12KeyStore3DES)object2).engineGetCertificate(string2);
            } else {
                String string3 = enumeration.nextElement();
                try {
                    object2 = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string3, passwordProtection);
                    privateKey = ((KeyStore.PrivateKeyEntry)object2).getPrivateKey();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    object = keyStore.getKey(string3, cArray);
                    privateKey = object instanceof PrivateKey ? (PrivateKey)object : null;
                }
                x509Certificate = (java.security.cert.X509Certificate)keyStore.getCertificate(string3);
            }
            object2 = com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate.fromJava(x509Certificate);
            object = new RSACryptoServiceProvider();
            RSAParameters rSAParameters = new RSAParameters();
            RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
            rSAParameters.Exponent = com.aspose.html.utils.ms.core.System.Security.Cryptography.a.a(rSAPublicKey.getPublicExponent());
            rSAParameters.Modulus = com.aspose.html.utils.ms.core.System.Security.Cryptography.a.a(rSAPublicKey.getModulus());
            ((RSACryptoServiceProvider)object).importParameters(rSAParameters);
            ((RSACryptoServiceProvider)object).setJavaPrivateKey(privateKey);
            ((com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate)object2).setRSA((RSA)object);
            return object2;
        }
        catch (Exception exception) {
            Console.write(exception.getMessage());
            return null;
        }
    }

    public void import_(String string) {
        byte[] byArray = X509Certificate.a(string);
        this.import_(byArray, (String)null, 0);
    }

    public void import_(String string, String string2, int n2) {
        byte[] byArray = X509Certificate.a(string);
        this.import_(byArray, string2, n2);
    }

    public void onDeserialization(Object object) {
    }

    public void reset() {
        this.c = null;
        this.a = null;
        this.b = null;
        this.d = false;
        this.e = null;
    }

    private String a(byte[] byArray) {
        if (byArray != null) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                msStringBuilder2.append(ByteExtensions.toString(byArray[i2], "X2"));
            }
            return msStringBuilder2.toString();
        }
        return null;
    }

    public static X509Certificate createFromCertFile(String string) {
        byte[] byArray = X509Certificate.a(string);
        return new X509Certificate(byArray);
    }

    public static X509Certificate createFromSignedFile(String string) {
        try {
            com.aspose.html.utils.ms.core._system.c.b b2 = new com.aspose.html.utils.ms.core._system.c.b(string);
            if (b2.n() != null) {
                return new X509Certificate(b2.n().getRawData());
            }
        }
        catch (Exception exception) {
            String string2 = StringExtensions.format("Couldn't extract digital signature from {0}.", string);
            throw new CryptographicException(string2, exception);
        }
        throw new CryptographicException(StringExtensions.format("{0} isn't signed.", string));
    }

    X509Certificate(byte[] byArray, boolean bl2) {
        if (byArray != null) {
            this.import_(byArray, (String)null, 0);
            this.d = !bl2;
        }
    }

    public X509Certificate(byte[] byArray) {
        this(byArray, true);
    }

    public X509Certificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new ArgumentNullException("cert");
        }
        if (x509Certificate != null) {
            byte[] byArray = x509Certificate.getRawCertData();
            if (byArray != null) {
                this.c = new com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate(byArray);
            }
            this.d = false;
        }
    }

    public boolean equals(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        if (x509Certificate.c == null) {
            if (this.c == null) {
                return true;
            }
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        byte[] byArray = x509Certificate.c.getRawData();
        if (byArray != null) {
            if (this.c == null) {
                return false;
            }
            if (this.c.getRawData() == null) {
                return false;
            }
            if (byArray.length == this.c.getRawData().length) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (byArray[i2] == this.c.getRawData()[i2]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.c == null || this.c.getRawData() == null;
    }

    public byte[] getCertHash() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        if (this.e == null && this.c != null) {
            SHA1 sHA1 = SHA1.create();
            this.e = sHA1.computeHash(this.c.getRawData());
        }
        return this.e;
    }

    public String getCertHashString() {
        return this.a(this.getCertHash());
    }

    public String getEffectiveDateString() {
        if (this.d) {
            return null;
        }
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getValidFrom().apJ().toString();
    }

    public String getExpirationDateString() {
        if (this.d) {
            return null;
        }
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getValidUntil().apJ().toString();
    }

    public String getFormat() {
        return "X509";
    }

    public int hashCode() {
        if (this.c == null) {
            return 0;
        }
        if (this.e == null) {
            this.getCertHash();
        }
        if (this.e != null && this.e.length >= 4) {
            return (this.e[0] & 0xFF) << 24 | (this.e[1] & 0xFF) << 16 | (this.e[2] & 0xFF) << 8 | this.e[3] & 0xFF;
        }
        return 0;
    }

    public String getIssuerName() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.get_IssuerName();
    }

    public String getKeyAlgorithm() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getKeyAlgorithm();
    }

    public byte[] getKeyAlgorithmParameters() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        byte[] byArray = this.c.getKeyAlgorithmParameters();
        if (byArray == null) {
            throw new CryptographicException(StringExtensions.format("Parameters not part of the certificate", new Object[0]));
        }
        return byArray;
    }

    public String getKeyAlgorithmParametersString() {
        return this.a(this.getKeyAlgorithmParameters());
    }

    public String getName() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.get_SubjectName();
    }

    public byte[] getPublicKey() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getPublicKey();
    }

    public String getPublicKeyString() {
        return this.a(this.getPublicKey());
    }

    public byte[] getRawCertData() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getRawData();
    }

    public String getRawCertDataString() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.a(this.c.getRawData());
    }

    public byte[] getSerialNumber() {
        if (this.c == null) {
            throw new CryptographicException(StringExtensions.format("Certificate instance is empty.", new Object[0]));
        }
        return this.c.getSerialNumber();
    }

    public String getSerialNumberString() {
        byte[] byArray = this.getSerialNumber();
        msArray.reverse(byArray);
        return this.a(byArray);
    }

    public String toString() {
        return super.toString();
    }

    public String toString(boolean bl2) {
        if (!bl2 || this.c == null) {
            return this.getClass().getName();
        }
        String string = Environment.NewLine;
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.appendFormat("[Subject]{0}  {1}{0}{0}", string, this.getSubject());
        msStringBuilder2.appendFormat("[Issuer]{0}  {1}{0}{0}", string, this.getIssuer());
        msStringBuilder2.appendFormat("[Not Before]{0}  {1}{0}{0}", string, this.getEffectiveDateString());
        msStringBuilder2.appendFormat("[Not After]{0}  {1}{0}{0}", string, this.getExpirationDateString());
        msStringBuilder2.appendFormat("[Thumbprint]{0}  {1}{0}", string, this.getCertHashString());
        msStringBuilder2.append(string);
        return msStringBuilder2.toString();
    }

    private static byte[] a(String string) {
        byte[] byArray = null;
        FileStream fileStream = File.openRead(string);
        try {
            byArray = new byte[(int)fileStream.getLength()];
            fileStream.read(byArray, 0, byArray.length);
            fileStream.close();
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
        return byArray;
    }

    static class CertificateContext
    extends Struct<CertificateContext> {
        public long a;
        public IntPtr b;
        public long c;
        public IntPtr d;
        public IntPtr e;

        public void a(CertificateContext certificateContext) {
            certificateContext.a = this.a;
            certificateContext.b = this.b;
            certificateContext.c = this.c;
            certificateContext.d = this.d;
            certificateContext.e = this.e;
        }

        public CertificateContext a() {
            CertificateContext certificateContext = new CertificateContext();
            this.a(certificateContext);
            return certificateContext;
        }

        public Object clone() {
            return this.a();
        }

        private boolean b(CertificateContext certificateContext) {
            return certificateContext.a == this.a && ObjectExtensions.equals(certificateContext.b, this.b) && certificateContext.c == this.c && ObjectExtensions.equals(certificateContext.d, this.d) && ObjectExtensions.equals(certificateContext.e, this.e);
        }

        public boolean equals(Object object) {
            assert (object != null);
            if (ObjectExtensions.referenceEquals(null, object)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, object)) {
                return true;
            }
            if (!(object instanceof CertificateContext)) {
                return false;
            }
            return this.b((CertificateContext)object);
        }

        public static boolean a(CertificateContext certificateContext, CertificateContext certificateContext2) {
            return certificateContext.equals(certificateContext2);
        }

        public int hashCode() {
            int n2 = (int)(this.a ^ this.a >>> 32);
            n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
            n2 = 31 * n2 + (int)(this.c ^ this.c >>> 32);
            n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
            n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
            return n2;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.a();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.a((CertificateContext)object);
        }
    }
}

