/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Xml.BaseIterator;
import com.aspose.html.utils.ms.System.Xml.ExprNumber;
import com.aspose.html.utils.ms.System.Xml.Expression;
import com.aspose.html.utils.ms.System.Xml.FunctionArguments;
import com.aspose.html.utils.ms.System.Xml.XPathException;
import com.aspose.html.utils.ms.System.Xml.XPathFunctions;
import com.aspose.html.utils.ms.System.Xml.XPathNumericFunction;

class XPathFunctionNumber
extends XPathNumericFunction {
    private Expression a;

    public XPathFunctionNumber(FunctionArguments functionArguments) {
        super(functionArguments);
        if (functionArguments != null) {
            this.a = functionArguments.getArg();
            if (functionArguments.getTail() != null) {
                throw new XPathException("number takes 1 or zero args");
            }
        }
    }

    @Override
    public Expression optimize() {
        if (this.a == null) {
            return this;
        }
        this.a = this.a.optimize();
        return !this.a.hasStaticValue() ? this : new ExprNumber(this.getStaticValueAsNumber());
    }

    @Override
    public boolean hasStaticValue() {
        return this.a != null && this.a.hasStaticValue();
    }

    @Override
    public double getStaticValueAsNumber() {
        return this.a != null ? this.a.getStaticValueAsNumber() : 0.0;
    }

    @Override
    boolean getPeer() {
        return this.a != null ? this.a.getPeer() : true;
    }

    @Override
    public Object evaluate(BaseIterator baseIterator) {
        if (this.a == null) {
            return XPathFunctions.toNumber(baseIterator.getCurrent().getValue());
        }
        return this.a.evaluateNumber(baseIterator);
    }

    public String toString() {
        return StringExtensions.concat("number(", this.a.toString(), ")");
    }
}

