/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cert.cmp;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.utils.ms.core.bc.asn1.DERSequence;
import com.aspose.html.utils.ms.core.bc.asn1.cmp.CertConfirmContent;
import com.aspose.html.utils.ms.core.bc.asn1.cmp.CertStatus;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cert.cmp.CMPException;
import com.aspose.html.utils.ms.core.bc.cert.cmp.CMPUtil;
import com.aspose.html.utils.ms.core.bc.cert.cmp.CertificateConfirmationContent;
import com.aspose.html.utils.ms.core.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.aspose.html.utils.ms.core.bc.operator.DigestAlgorithmIdentifierFinder;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.utils.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.utils.ms.core.bc.operator.OperatorCreationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List acceptedCerts = new ArrayList();
    private List acceptedReqIds = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, BigInteger bigInteger) {
        this.acceptedCerts.add(x509CertificateHolder);
        this.acceptedReqIds.add(bigInteger);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.acceptedCerts.size(); ++i2) {
            DigestCalculator digestCalculator;
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)this.acceptedCerts.get(i2);
            BigInteger bigInteger = (BigInteger)this.acceptedReqIds.get(i2);
            AlgorithmIdentifier algorithmIdentifier = this.digestAlgFinder.find(x509CertificateHolder.toASN1Structure().getSignatureAlgorithm());
            if (algorithmIdentifier == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMPException("unable to create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
            CMPUtil.derEncodeToStream(x509CertificateHolder.toASN1Structure(), digestCalculator.getOutputStream());
            aSN1EncodableVector.add(new CertStatus(digestCalculator.getDigest(), bigInteger));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(aSN1EncodableVector)), this.digestAlgFinder);
    }
}

