/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x509.DSAParameter;
import com.aspose.html.utils.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.utils.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricDSAKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import java.io.IOException;
import java.math.BigInteger;

public final class AsymmetricDSAPublicKey
extends AsymmetricDSAKey
implements AsymmetricPublicKey {
    private BigInteger y;

    public AsymmetricDSAPublicKey(Algorithm algorithm, DSADomainParameters dSADomainParameters, BigInteger bigInteger) {
        super(algorithm, dSADomainParameters);
        this.y = KeyUtils.validated(dSADomainParameters, bigInteger);
    }

    public AsymmetricDSAPublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricDSAPublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, subjectPublicKeyInfo.getAlgorithm());
        this.y = KeyUtils.validated(this.getDomainParameters(), AsymmetricDSAPublicKey.parsePublicKey(subjectPublicKeyInfo));
    }

    private static BigInteger parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1Integer aSN1Integer;
        try {
            aSN1Integer = ASN1Integer.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
        return aSN1Integer.getValue();
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded() {
        DSADomainParameters dSADomainParameters = this.getDomainParameters();
        if (this.getDomainParameters() == null) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new ASN1Integer(this.y));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG()).toASN1Primitive()), new ASN1Integer(this.y));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDSAPublicKey)) {
            return false;
        }
        AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)object;
        if (this.getDomainParameters() != null) {
            return this.y.equals(asymmetricDSAPublicKey.y) && this.getDomainParameters().equals(asymmetricDSAPublicKey.getDomainParameters());
        }
        return this.y.equals(asymmetricDSAPublicKey.y) && this.getDomainParameters() == asymmetricDSAPublicKey.getDomainParameters();
    }

    public int hashCode() {
        int n2 = this.y.hashCode();
        if (this.getDomainParameters() != null) {
            n2 = 31 * n2 + this.getDomainParameters().hashCode();
        }
        return n2;
    }
}

