/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import com.aspose.html.utils.ms.core.bc.jcajce.interfaces.EdDSAKey;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyUtil;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import javax.security.auth.Destroyable;

class ProvEdDSAPrivateKey
implements EdDSAKey,
PrivateKey,
Destroyable {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPrivateKey baseKey;

    ProvEdDSAPrivateKey(AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey) {
        this.baseKey = asymmetricEdDSAPrivateKey;
    }

    ProvEdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.baseKey = new AsymmetricEdDSAPrivateKey(privateKeyInfo);
    }

    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    public void destroy() {
        this.baseKey.destroy();
    }

    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public AsymmetricEdDSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("EdDSA");
        }
        AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey = new AsymmetricEdDSAPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), asymmetricEdDSAPublicKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvEdDSAPrivateKey)) {
            return false;
        }
        ProvEdDSAPrivateKey provEdDSAPrivateKey = (ProvEdDSAPrivateKey)object;
        return Arrays.areEqual(provEdDSAPrivateKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricEdDSAPrivateKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

