/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410NamedParameters;
import org.bouncycastle.asn1.cryptopro.GOST3410ParamSetParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GOST3410Parameters<T> {
    private final ASN1ObjectIdentifier publicKeyParamSet;
    private final ASN1ObjectIdentifier digestParamSet;
    private final ASN1ObjectIdentifier encryptionParamSet;
    private final T domainParameters;

    public GOST3410Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet, null, GOST3410Parameters.getDomainParameters(aSN1ObjectIdentifier));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this(aSN1ObjectIdentifier, aSN1ObjectIdentifier2, null, GOST3410Parameters.getDomainParameters(aSN1ObjectIdentifier));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2, ASN1ObjectIdentifier aSN1ObjectIdentifier3) {
        this(aSN1ObjectIdentifier, aSN1ObjectIdentifier2, aSN1ObjectIdentifier3, GOST3410Parameters.getDomainParameters(aSN1ObjectIdentifier));
    }

    public GOST3410Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2, T t2) {
        this(aSN1ObjectIdentifier, aSN1ObjectIdentifier2, null, t2);
    }

    public GOST3410Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2, ASN1ObjectIdentifier aSN1ObjectIdentifier3, T t2) {
        this.publicKeyParamSet = aSN1ObjectIdentifier;
        this.digestParamSet = aSN1ObjectIdentifier2;
        this.encryptionParamSet = aSN1ObjectIdentifier3;
        this.domainParameters = t2;
    }

    public ASN1ObjectIdentifier getPublicKeyParamSet() {
        return this.publicKeyParamSet;
    }

    public ASN1ObjectIdentifier getDigestParamSet() {
        return this.digestParamSet;
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.encryptionParamSet;
    }

    public T getDomainParameters() {
        return this.domainParameters;
    }

    private static Object getDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        GOST3410ParamSetParameters gOST3410ParamSetParameters = GOST3410NamedParameters.getByOID(aSN1ObjectIdentifier);
        if (gOST3410ParamSetParameters != null) {
            return new GOST3410DomainParameters(gOST3410ParamSetParameters.getKeySize(), gOST3410ParamSetParameters.getP(), gOST3410ParamSetParameters.getQ(), gOST3410ParamSetParameters.getA());
        }
        ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByOID(aSN1ObjectIdentifier);
        return new NamedECDomainParameters(aSN1ObjectIdentifier, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GOST3410Parameters)) {
            return false;
        }
        GOST3410Parameters gOST3410Parameters = (GOST3410Parameters)object;
        if (this.digestParamSet != null ? !this.digestParamSet.equals(gOST3410Parameters.digestParamSet) : gOST3410Parameters.digestParamSet != null) {
            return false;
        }
        if (this.domainParameters != null ? !this.domainParameters.equals(gOST3410Parameters.domainParameters) : gOST3410Parameters.domainParameters != null) {
            return false;
        }
        if (this.encryptionParamSet != null ? !this.encryptionParamSet.equals(gOST3410Parameters.encryptionParamSet) : gOST3410Parameters.encryptionParamSet != null) {
            return false;
        }
        return !(this.publicKeyParamSet != null ? !this.publicKeyParamSet.equals(gOST3410Parameters.publicKeyParamSet) : gOST3410Parameters.publicKeyParamSet != null);
    }

    public int hashCode() {
        int n2 = this.publicKeyParamSet != null ? this.publicKeyParamSet.hashCode() : 0;
        n2 = 31 * n2 + (this.digestParamSet != null ? this.digestParamSet.hashCode() : 0);
        n2 = 31 * n2 + (this.encryptionParamSet != null ? this.encryptionParamSet.hashCode() : 0);
        n2 = 31 * n2 + (this.domainParameters != null ? this.domainParameters.hashCode() : 0);
        return n2;
    }
}

