/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.util.EntropyUtil;

public final class FipsSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final DRBG drbg;
    private final boolean predictionResistant;

    FipsSecureRandom(SecureRandom secureRandom, DRBG dRBG, EntropySource entropySource, boolean bl2) {
        super(new RandomSpi(secureRandom, dRBG, entropySource, bl2), new RandomProvider());
        this.randomSource = secureRandom;
        this.drbg = dRBG;
        this.predictionResistant = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long l2) {
        if (this.drbg != null) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                this.randomSource.setSeed(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] byArray, byte[] byArray2) {
        DRBG dRBG = this.drbg;
        synchronized (dRBG) {
            if (this.drbg.generate(byArray, byArray2, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(byArray, byArray2, this.predictionResistant);
            }
        }
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    public int getSecurityStrength() {
        return this.drbg.getSecurityStrength();
    }

    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] byArray) {
        this.drbg.reseed(byArray);
    }

    static class RandomProvider
    extends Provider {
        RandomProvider() {
            super("BCFIPS_RNG", 1.0, "BCFIPS Secure Random Provider");
        }
    }

    static class RandomSpi
    extends SecureRandomSpi {
        private final SecureRandom randomSource;
        private final DRBG drbg;
        private final EntropySource entropySource;
        private final boolean predictionResistant;

        RandomSpi(SecureRandom secureRandom, DRBG dRBG, EntropySource entropySource, boolean bl2) {
            this.randomSource = secureRandom;
            this.drbg = dRBG;
            this.entropySource = entropySource;
            this.predictionResistant = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void engineSetSeed(byte[] byArray) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (this.randomSource != null) {
                    this.randomSource.setSeed(byArray);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void engineNextBytes(byte[] byArray) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (byArray == null) {
                    throw new NullPointerException("bytes cannot be null");
                }
                if (byArray.length != 0 && this.drbg.generate(byArray, null, this.predictionResistant) < 0) {
                    this.drbg.reseed(null);
                    this.drbg.generate(byArray, null, this.predictionResistant);
                }
            }
        }

        protected byte[] engineGenerateSeed(int n2) {
            return EntropyUtil.generateSeed(this.entropySource, n2);
        }
    }
}

