/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.DsaKeyPairGenerator;
import org.bouncycastle.crypto.general.DsaParametersGenerator;
import org.bouncycastle.crypto.general.DsaSigner;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorUsingSecureRandomFactory;
import org.bouncycastle.crypto.general.HMacDsaKCalculator;
import org.bouncycastle.crypto.general.NullDigest;
import org.bouncycastle.crypto.general.RandomDsaKCalculator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

public final class DSA {
    public static final Algorithm ALGORITHM = FipsDSA.ALGORITHM;
    public static final Parameters DSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DSA), FipsSHS.Algorithm.SHA1);
    public static final Parameters DDSA = new Parameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.DDSA), FipsSHS.Algorithm.SHA1);

    private DSA() {
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, (Object)asymmetricCipherKeyPair, (ConsistencyTest)new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                DsaSigner dsaSigner = new DsaSigner(new RandomDsaKCalculator());
                dsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = dsaSigner.generateSignature(byArray);
                dsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                return dsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    private static DsaParameters getDomainParams(DSADomainParameters dSADomainParameters) {
        return new DsaParameters(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG());
    }

    private static DsaPrivateKeyParameters getLwKey(final AsymmetricDSAPrivateKey asymmetricDSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<DsaPrivateKeyParameters>(){

            @Override
            public DsaPrivateKeyParameters run() {
                return new DsaPrivateKeyParameters(asymmetricDSAPrivateKey.getX(), org.bouncycastle.crypto.general.DSA.getDomainParams(asymmetricDSAPrivateKey.getDomainParameters()));
            }
        });
    }

    public static final class DomainGenParameters
    extends GeneralParameters {
        private final int strength;
        private final int certainty;

        public DomainGenParameters(int n2) {
            this(n2, PrimeCertaintyCalculator.getDefaultCertainty(n2));
        }

        public DomainGenParameters(int n2, int n3) {
            super(ALGORITHM);
            this.strength = n2;
            this.certainty = n3;
        }
    }

    public static final class DomainParametersGenerator {
        private final SecureRandom random;
        private final DomainGenParameters parameters;

        public DomainParametersGenerator(DomainGenParameters domainGenParameters, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved generator in approved only mode.");
            }
            this.parameters = domainGenParameters;
            this.random = secureRandom;
        }

        public DSADomainParameters generateDomainParameters() {
            DsaParametersGenerator dsaParametersGenerator = this.parameters.strength <= 1024 ? new DsaParametersGenerator() : new DsaParametersGenerator(Register.createDigest(FipsSHS.Algorithm.SHA256));
            if (this.parameters.strength == 1024) {
                if (Properties.isOverrideSet("org.bouncycastle.dsa.FIPS186-2for1024bits")) {
                    dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
                } else {
                    DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(1024, 160, this.parameters.certainty, this.random);
                    dsaParametersGenerator.init(dsaParameterGenerationParameters);
                }
            } else if (this.parameters.strength > 1024) {
                DsaParameterGenerationParameters dsaParameterGenerationParameters = new DsaParameterGenerationParameters(this.parameters.strength, 256, this.parameters.certainty, this.random);
                dsaParametersGenerator.init(dsaParameterGenerationParameters);
            } else {
                dsaParametersGenerator.init(this.parameters.strength, this.parameters.certainty, this.random);
            }
            DsaParameters dsaParameters = dsaParametersGenerator.generateParameters();
            DsaValidationParameters dsaValidationParameters = dsaParameters.getValidationParameters();
            return new DSADomainParameters(dsaParameters.getP(), dsaParameters.getQ(), dsaParameters.getG(), new DSAValidationParameters(dsaValidationParameters.getSeed(), dsaValidationParameters.getCounter(), dsaValidationParameters.getUsageIndex()));
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final DSADomainParameters domainParameters;

        public KeyGenParameters(Parameters parameters, DSADomainParameters dSADomainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = dSADomainParameters;
        }

        public KeyGenParameters(DSADomainParameters dSADomainParameters) {
            super(ALGORITHM);
            this.domainParameters = dSADomainParameters;
        }

        public DSADomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> {
        private final DsaKeyPairGenerator engine = new DsaKeyPairGenerator();
        private final DSADomainParameters domainParameters;
        private final DsaKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.param = new DsaKeyGenerationParameters(secureRandom, org.bouncycastle.crypto.general.DSA.getDomainParams(this.domainParameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            org.bouncycastle.crypto.general.DSA.validateKeyPair(asymmetricCipherKeyPair);
            DsaPublicKeyParameters dsaPublicKeyParameters = (DsaPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            DsaPrivateKeyParameters dsaPrivateKeyParameters = (DsaPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t2 = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricDSAPublicKey, AsymmetricDSAPrivateKey>(new AsymmetricDSAPublicKey((Algorithm)t2, this.domainParameters, dsaPublicKeyParameters.getY()), new AsymmetricDSAPrivateKey((Algorithm)t2, this.domainParameters, dsaPrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSignatureOperatorUsingSecureRandomFactory<Parameters> {
        @Override
        protected OutputSignerUsingSecureRandom<Parameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)asymmetricPrivateKey;
            final DsaPrivateKeyParameters dsaPrivateKeyParameters = org.bouncycastle.crypto.general.DSA.getLwKey(asymmetricDSAPrivateKey);
            return new DSAOutputSigner<Parameters>(dsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(org.bouncycastle.crypto.internal.DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(dsaPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, Parameters parameters) {
            Digest digest = parameters.digestAlgorithm != null ? Register.createDigest(parameters.digestAlgorithm) : new NullDigest();
            DsaSigner dsaSigner = parameters.getAlgorithm() == DSA.getAlgorithm() ? new DsaSigner(new RandomDsaKCalculator()) : new DsaSigner(new HMacDsaKCalculator(Register.createDigest(parameters.digestAlgorithm)));
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)asymmetricPublicKey;
            DsaPublicKeyParameters dsaPublicKeyParameters = new DsaPublicKeyParameters(asymmetricDSAPublicKey.getY(), org.bouncycastle.crypto.general.DSA.getDomainParams(asymmetricDSAPublicKey.getDomainParameters()));
            dsaSigner.init(false, dsaPublicKeyParameters);
            return new DSAOutputVerifier<Parameters>(dsaSigner, digest, parameters);
        }
    }

    public static final class Parameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        Parameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            if (generalAlgorithm.basicVariation() == Variations.DDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("DDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public Parameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        DSA,
        DDSA;

    }
}

