/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.Gost3410KeyParameters;
import org.bouncycastle.crypto.general.Gost3410Parameters;
import org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;

class Gost3410Signer
implements DSA {
    Gost3410KeyParameters key;
    SecureRandom random;

    Gost3410Signer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (!(cipherParameters instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            this.key = (Gost3410PrivateKeyParameters)parametersWithRandom.getParameters();
            return;
        } else {
            this.key = (Gost3410PublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray2.length - 1 - i2];
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        Gost3410Parameters gost3410Parameters = this.key.getParameters();
        while ((bigInteger = new BigInteger(gost3410Parameters.getQ().bitLength(), this.random)).compareTo(gost3410Parameters.getQ()) >= 0) {
        }
        BigInteger bigInteger3 = gost3410Parameters.getA().modPow(bigInteger, gost3410Parameters.getP()).mod(gost3410Parameters.getQ());
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger2).add(((Gost3410PrivateKeyParameters)this.key).getX().multiply(bigInteger3)).mod(gost3410Parameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray2.length - 1 - i2];
        }
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        Gost3410Parameters gost3410Parameters = this.key.getParameters();
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || gost3410Parameters.getQ().compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || gost3410Parameters.getQ().compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modPow(gost3410Parameters.getQ().subtract(new BigInteger("2")), gost3410Parameters.getQ());
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger5).mod(gost3410Parameters.getQ());
        BigInteger bigInteger7 = gost3410Parameters.getQ().subtract(bigInteger).multiply(bigInteger5).mod(gost3410Parameters.getQ());
        bigInteger6 = gost3410Parameters.getA().modPow(bigInteger6, gost3410Parameters.getP());
        bigInteger7 = ((Gost3410PublicKeyParameters)this.key).getY().modPow(bigInteger7, gost3410Parameters.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(gost3410Parameters.getP()).mod(gost3410Parameters.getQ());
        return bigInteger8.equals(bigInteger);
    }
}

