/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.MessageDigest;
import org.bouncycastle.crypto.OutputDigestCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;

final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    private final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters parameters) {
        this(fipsFactory.createOutputDigestCalculator(parameters));
    }

    BaseMessageDigest(OutputDigestCalculator outputDigestCalculator) {
        super(((Parameters)outputDigestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = outputDigestCalculator;
        this.digestStream = outputDigestCalculator.getDigestStream();
    }

    protected void engineReset() {
        this.digestCalculator.reset();
    }

    protected void engineUpdate(byte by2) {
        this.digestStream.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.digestStream.update(byArray, n2, n3);
    }

    protected byte[] engineDigest() {
        byte[] byArray = this.digestCalculator.getDigest();
        this.engineReset();
        return byArray;
    }

    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

