/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

public final class DisplayUnitsConverter {
    static final int PointsPerInch = 72;
    static final float MillimetersPerInch = 25.4f;
    static final int DIPPerInch = 96;

    public static int pointToPixel(float points, float dpi) {
        return (int)((double)(DisplayUnitsConverter.pointToInch(points) * dpi) + 0.5);
    }

    public static float pixelToPoint(int pixels, float dpi) {
        return DisplayUnitsConverter.inchToPoint((float)pixels / dpi);
    }

    public static float inchToPoint(float inches) {
        return inches * 72.0f;
    }

    public static float pointToInch(float points) {
        return points / 72.0f;
    }

    public static float millimeterToInch(float mm) {
        return mm / 25.4f;
    }

    public static float millimeterToPoint(float mm) {
        return DisplayUnitsConverter.inchToPoint(DisplayUnitsConverter.millimeterToInch(mm));
    }

    static float fromPointToDIP(float points) {
        return points / 72.0f * 96.0f;
    }

    static float fromDIPToPoint(float dips) {
        return dips / 96.0f * 72.0f;
    }

    static float halfInchToInch(float inches) {
        return inches / 2.0f;
    }

    static float pointToHalfInch(float points) {
        return points / 72.0f * 2.0f;
    }

    static float halfInchToPoint(float halfinches) {
        return DisplayUnitsConverter.inchToPoint(DisplayUnitsConverter.halfInchToInch(halfinches));
    }

    static int halfPointToPoint(int halfpoints) {
        return halfpoints / 2;
    }

    static int pointToHalfPoint(int points) {
        return points * 2;
    }

    static float indentPositionToPoint(byte indentPosition) {
        return (float)indentPosition * 26.7f;
    }

    private DisplayUnitsConverter() {
    }
}

