/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note;

import com.aspose.note.DisplayUnitsConverter;
import com.aspose.note.Document;
import com.aspose.note.DocumentVisitor;
import com.aspose.note.IOutlineElementChildNode;
import com.aspose.note.ITag;
import com.aspose.note.ITaggable;
import com.aspose.note.Node;
import com.aspose.note.ParagraphStyle;
import com.aspose.note.TextRun;
import com.aspose.note.TextStyle;
import com.aspose.note.cF;
import com.aspose.note.cQ;
import com.aspose.note.cZ;
import com.aspose.note.dl;
import com.aspose.note.internal.aq.aJ;
import com.aspose.note.internal.aq.au;
import com.aspose.note.internal.aq.e;
import com.aspose.note.internal.aq.z;
import com.aspose.note.internal.at.M;
import com.aspose.note.internal.b.m;
import com.aspose.note.q;
import com.aspose.note.system.collections.Generic.IGenericEnumerable;
import com.aspose.note.system.collections.Generic.IGenericEnumerator;
import com.aspose.note.system.collections.Generic.List;
import com.aspose.note.system.collections.Generic.SortedDictionary;
import com.aspose.note.system.exceptions.ArgumentOutOfRangeException;
import java.util.Date;

public class RichText
extends Node
implements IOutlineElementChildNode,
ITaggable,
IGenericEnumerable<Character> {
    private final List<TextRun> a = new List();
    private String b;
    private final SortedDictionary<Float, cF> c = new SortedDictionary();
    private z d = new z();
    private ParagraphStyle e;
    private int f;
    private Float g;
    private Float h;
    private Float i;
    private List<ITag> j;
    private boolean k;
    private boolean l;
    private boolean m;
    private int n;
    static final float MinParagraphSpace = DisplayUnitsConverter.halfInchToPoint(0.0f);
    static final float MaxParagraphSpace = DisplayUnitsConverter.halfInchToPoint(27777.777f);

    public RichText(Document document) {
        super(document, 8);
        this.setLastModifiedTimeInternal(z.o());
        this.j = new List();
    }

    public RichText() {
        this(null);
    }

    public Date getLastModifiedTime() {
        return z.d(this.getLastModifiedTimeInternal());
    }

    z getLastModifiedTimeInternal() {
        return this.d.H();
    }

    public void setLastModifiedTime(Date value) {
        this.setLastModifiedTimeInternal(z.a(value));
    }

    void setLastModifiedTimeInternal(z value) {
        this.d = value.H();
    }

    public final String getText() {
        if (this.b == null) {
            if (this.a.size() == 1) {
                this.b = com.aspose.note.internal.b.m.d(this.a).getText();
            } else if (this.a.size() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (TextRun textRun : this.getTextRuns()) {
                    stringBuilder.append(textRun.getText());
                }
                this.b = stringBuilder.toString();
            }
        }
        return this.b;
    }

    public final void setText(String value) {
        if (value == null) {
            value = au.a;
        }
        int n2 = 0;
        for (TextRun textRun : this.getTextRuns()) {
            if (value.length() - n2 >= textRun.getLength()) {
                textRun.setText(au.b(value, n2, textRun.getLength()));
            } else if (n2 < value.length()) {
                textRun.setText(au.e(value, n2));
            } else {
                textRun.setText(au.a);
            }
            n2 += textRun.getLength();
        }
        if (n2 < value.length()) {
            this.append(au.e(value, n2));
        }
        this.a();
        this.clearCachedValues();
    }

    public final int getLength() {
        String string = this.getText();
        return string != null ? string.length() : 0;
    }

    public final ParagraphStyle getParagraphStyle() {
        return this.e;
    }

    public final void setParagraphStyle(ParagraphStyle value) {
        this.e = value;
    }

    @Override
    public int getAlignment() {
        return this.f;
    }

    public void setAlignment(int value) {
        this.f = value;
    }

    public Float getSpaceBefore() {
        return this.g;
    }

    public void setSpaceBefore(Float value) {
        if (value != null) {
            RichText.a(value.floatValue(), "SpaceBefore");
        }
        this.g = value;
    }

    public void setSpaceBefore(float value) {
        this.setSpaceBefore(Float.valueOf(value));
    }

    public Float getSpaceAfter() {
        return this.h;
    }

    public void setSpaceAfter(Float value) {
        if (value != null) {
            RichText.a(value.floatValue(), "SpaceAfter");
        }
        this.h = value;
    }

    public void setSpaceAfter(float value) {
        this.setSpaceAfter(Float.valueOf(value));
    }

    public Float getLineSpacing() {
        return this.i;
    }

    public void setLineSpacing(Float value) {
        if (value != null) {
            RichText.a(value.floatValue(), "LineSpacing");
        }
        this.i = value;
    }

    public void setLineSpacing(float value) {
        this.setLineSpacing(Float.valueOf(value));
    }

    public IGenericEnumerable<TextStyle> getStyles() {
        if (this.a.size() > 0 && TextStyle.getDefault().equals(com.aspose.note.internal.b.m.d(this.a).getStyle())) {
            return com.aspose.note.internal.aq.e.a(new TextStyle[]{TextStyle.getDefault()});
        }
        List<TextStyle> list = new List<TextStyle>();
        for (TextRun textRun : this.getTextRuns()) {
            list.add(textRun.getStyle());
        }
        return list;
    }

    public final IGenericEnumerable<TextRun> getTextRuns() {
        return this.a;
    }

    @Override
    public final List<ITag> getTags() {
        return this.j;
    }

    boolean isTitleText() {
        return this.k;
    }

    void setTitleText(boolean value) {
        this.k = value;
    }

    boolean isTitleDate() {
        return this.l;
    }

    void setTitleDate(boolean value) {
        this.l = value;
    }

    boolean isTitleTime() {
        return this.m;
    }

    void setTitleTime(boolean value) {
        this.m = value;
    }

    int getLanguageId() {
        return this.n;
    }

    void setLanguageId(int value) {
        this.n = value;
    }

    final TextStyle getDefaultTextStyle() {
        ParagraphStyle paragraphStyle = this.getParagraphStyle();
        if (paragraphStyle == null) {
            paragraphStyle = ParagraphStyle.getDefault();
        }
        return TextStyle.fromParagraphStyle(paragraphStyle);
    }

    @Override
    public void accept(DocumentVisitor visitor) {
        visitor.visitRichTextStart(this);
        visitor.visitRichTextEnd(this);
    }

    public final RichText insert(int startIndex, String value) {
        int n2;
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        for (n2 = 0; n2 < this.a.size() && this.a.get_Item(n2).getLength() < startIndex; startIndex -= this.a.get_Item(n2).getLength(), ++n2) {
        }
        if (n2 == this.a.size() && startIndex > 0 || startIndex < 0) {
            throw new IllegalArgumentException("startIndex");
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        if (n2 == 0 && !com.aspose.note.internal.b.m.a(this.a)) {
            this.a.addItem(new TextRun(value).bind(this));
        } else {
            TextRun textRun = this.a.get_Item(n2);
            try {
                textRun.setText(au.a(textRun.getText(), startIndex, value));
            }
            catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
                throw new IllegalArgumentException(argumentOutOfRangeException.getParamName());
            }
        }
        this.clearCachedValues();
        return this;
    }

    public final RichText insert(int startIndex, String value, TextStyle style) {
        int n2;
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        for (n2 = 0; n2 < this.a.size() && this.a.get_Item(n2).getLength() < startIndex; startIndex -= this.a.get_Item(n2).getLength(), ++n2) {
        }
        if (n2 == this.a.size() && startIndex > 0 || startIndex < 0) {
            throw new IllegalArgumentException("startIndex");
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        TextRun textRun = this.a.get_Item(n2);
        if (startIndex == 0) {
            this.a.insertItem(n2, new TextRun(value, style).bind(this));
        } else if (startIndex == textRun.getLength()) {
            this.a.insertItem(n2 + 1, new TextRun(value, style).bind(this));
        } else {
            String string = au.e(textRun.getText(), startIndex);
            this.a.get_Item(n2).setText(au.b(textRun.getText(), 0, startIndex));
            this.a.insertItem(n2 + 1, new TextRun(value, style).bind(this));
            this.a.insertItem(n2 + 2, new TextRun(string, textRun.getStyle().deepClone()).bind(this));
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public RichText appendFront(String value) {
        if (value == null) {
            return this;
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        TextRun textRun = com.aspose.note.internal.b.m.e(this.a);
        if (textRun != null && !textRun.getStyle().isHyperlink()) {
            textRun.setText(au.a(new String[]{value, textRun.getText()}));
        } else {
            this.a.insertItem(0, new TextRun(value).bind(this));
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public RichText appendFront(String value, TextStyle style) {
        if (value == null) {
            return this;
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        if (style == null) {
            return this.appendFront(value);
        }
        this.a.insertItem(0, new TextRun(value, style).bind(this));
        this.a();
        this.clearCachedValues();
        return this;
    }

    public final RichText append(String value, TextStyle style) {
        if (value == null) {
            return this;
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        if (style == null) {
            return this.append(value);
        }
        this.a.addItem(new TextRun(value, style).bind(this));
        this.a();
        this.clearCachedValues();
        return this;
    }

    public RichText append(String value) {
        if (value == null) {
            return this;
        }
        if (au.b(value) && com.aspose.note.internal.b.m.a(this.a)) {
            return this;
        }
        TextRun textRun = com.aspose.note.internal.b.m.h(this.a);
        if (textRun != null && !textRun.getStyle().isHyperlink()) {
            textRun.setText(au.a(new String[]{textRun.getText(), value}));
        } else {
            this.a.addItem(new TextRun(value).bind(this));
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public final RichText remove(int startIndex, int count) {
        int n2;
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (startIndex + count > this.getLength()) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < this.a.size() && this.a.get_Item(n2).getLength() <= startIndex; startIndex -= this.a.get_Item(n2).getLength(), ++n2) {
        }
        this.a(n2, startIndex, count);
        this.clearCachedValues();
        return this;
    }

    public final RichText remove(int startIndex) {
        int n2;
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex");
        }
        if (startIndex > this.getLength()) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < this.a.size() && this.a.get_Item(n2).getLength() <= startIndex; startIndex -= this.a.get_Item(n2).getLength(), ++n2) {
        }
        this.a(n2, startIndex, this.getLength() - startIndex);
        this.clearCachedValues();
        return this;
    }

    public final RichText replace(char oldChar, char newChar) {
        for (TextRun textRun : this.a) {
            textRun.setText(au.a(textRun.getText(), oldChar, newChar));
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public final RichText replace(String oldValue, String newValue) {
        if (oldValue == null) {
            throw new IllegalArgumentException("oldValue");
        }
        if (au.b(oldValue)) {
            throw new IllegalArgumentException("oldValue cannot be empty");
        }
        String string = newValue;
        if (string == null) {
            string = au.a;
        }
        newValue = string;
        int n2 = 0;
        while (n2 < this.a.size()) {
            int n3;
            boolean bl2 = this.a.get_Item(n2).getStyle().isHyperlink();
            String string2 = this.a.get_Item(n2).getStyle().getHyperlinkAddress();
            for (n3 = n2; n3 < this.a.size() && this.a.get_Item(n3).getStyle().isHyperlink() == bl2 && au.e(this.a.get_Item(n3).getStyle().getHyperlinkAddress(), string2); ++n3) {
            }
            this.a(oldValue, newValue, n2, n3);
            n2 = n3;
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public final RichText replace(String oldValue, String newValue, TextStyle style) {
        if (oldValue == null) {
            throw new IllegalArgumentException("oldValue");
        }
        if (au.b(oldValue)) {
            throw new IllegalArgumentException("oldValue cannot be empty");
        }
        String string = newValue;
        if (string == null) {
            string = au.a;
        }
        newValue = string;
        int n2 = 0;
        while (n2 < this.a.size()) {
            int n3;
            boolean bl2 = this.a.get_Item(n2).getStyle().isHyperlink();
            String string2 = this.a.get_Item(n2).getStyle().getHyperlinkAddress();
            for (n3 = n2; n3 < this.a.size() && this.a.get_Item(n3).getStyle().isHyperlink() == bl2 && au.e(this.a.get_Item(n3).getStyle().getHyperlinkAddress(), string2); ++n3) {
            }
            this.a(oldValue, newValue, style, n2, n3);
            n2 = n3;
        }
        this.a();
        this.clearCachedValues();
        return this;
    }

    public final RichText trim(char ... trimChars) {
        return this.trimStart(trimChars).trimEnd(trimChars);
    }

    public final RichText trim(char trimChar) {
        return this.trimStart(trimChar).trimEnd(trimChar);
    }

    public final RichText trim() {
        return this.trimStart().trimEnd();
    }

    public final RichText trimStart(char ... trimChars) {
        for (TextRun textRun : this.getTextRuns()) {
            if (!au.b(textRun.getText())) {
                textRun.setText(au.d(textRun.getText(), trimChars));
            }
            if (au.b(textRun.getText())) continue;
            break;
        }
        this.a();
        return this;
    }

    public final RichText trimStart(char trimChar) {
        for (TextRun textRun : this.getTextRuns()) {
            if (!au.b(textRun.getText())) {
                textRun.setText(au.d(textRun.getText(), new char[]{trimChar}));
            }
            if (au.b(textRun.getText())) continue;
            break;
        }
        this.a();
        return this;
    }

    public final RichText trimStart() {
        for (TextRun textRun : this.getTextRuns()) {
            if (!au.b(textRun.getText())) {
                textRun.setText(au.d(textRun.getText()));
            }
            if (au.b(textRun.getText())) continue;
            break;
        }
        this.a();
        return this;
    }

    public final RichText trimEnd(char ... trimChars) {
        boolean bl2 = false;
        while (this.a.size() != 0) {
            TextRun textRun = this.a.get_Item(this.a.size() - 1);
            if (textRun.getText() != null) {
                bl2 = true;
            }
            if (!au.b(textRun.getText())) {
                textRun.setText(au.e(textRun.getText(), trimChars));
            }
            if (!au.b(textRun.getText())) break;
            this.a.removeAt(this.a.size() - 1);
        }
        if (this.a.size() == 0 && bl2) {
            this.append(au.a);
        }
        return this;
    }

    public final RichText trimEnd(char trimChar) {
        boolean bl2 = false;
        while (this.a.size() != 0) {
            TextRun textRun = this.a.get_Item(this.a.size() - 1);
            if (textRun.getText() != null) {
                bl2 = true;
            }
            if (!au.b(textRun.getText())) {
                textRun.setText(au.e(textRun.getText(), trimChar));
            }
            if (!au.b(textRun.getText())) break;
            this.a.removeAt(this.a.size() - 1);
        }
        if (this.a.size() == 0 && bl2) {
            this.append(au.a);
        }
        return this;
    }

    public final RichText trimEnd() {
        boolean bl2 = false;
        while (this.a.size() != 0) {
            TextRun textRun = this.a.get_Item(this.a.size() - 1);
            if (textRun.getText() != null) {
                bl2 = true;
            }
            if (!au.b(textRun.getText())) {
                textRun.setText(au.e(textRun.getText(), new char[0]));
            }
            if (!au.b(textRun.getText())) break;
            this.a.removeAt(this.a.size() - 1);
        }
        if (this.a.size() == 0 && bl2) {
            this.append(au.a);
        }
        return this;
    }

    public final int indexOf(String value, int startIndex, int count, short comparisonType) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex, count, comparisonType) : -1;
    }

    public final int indexOf_Rename_Namesake(String value, int startIndex, short comparisonType) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex, comparisonType) : -1;
    }

    public final int indexOf(char value, int startIndex, int count) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex, count) : -1;
    }

    public final int indexOf(String value, short comparisonType) {
        String string = this.getText();
        return string != null ? au.f(string, value, comparisonType) : -1;
    }

    public final int indexOf(String value, int startIndex, int count) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex, count) : -1;
    }

    public final int indexOf(char value, int startIndex) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex) : -1;
    }

    public final int indexOf(String value) {
        String string = this.getText();
        return string != null ? au.h(string, value) : -1;
    }

    public final int indexOf(char value) {
        String string = this.getText();
        return string != null ? au.d(string, value) : -1;
    }

    public final int indexOf(String value, int startIndex) {
        String string = this.getText();
        return string != null ? au.b(string, value, startIndex) : -1;
    }

    public final RichText clear() {
        if (this.a.size() > 0) {
            com.aspose.note.internal.b.m.d(this.getTextRuns()).setText(au.a);
            this.a.removeRange(1, this.a.size() - 1);
        }
        return this;
    }

    @Override
    float calculateTagsWidth() {
        float f2 = this.getParagraphStyle().getActualFontSize();
        if (com.aspose.note.internal.b.m.a(this.getTextRuns()) && com.aspose.note.internal.b.m.d(this.getTextRuns()).getStyle().getFontSize() != null) {
            f2 = com.aspose.note.internal.b.m.d(this.getTextRuns()).getStyle().getFontSize().intValue();
        }
        return dl.a(this.j, f2);
    }

    @Override
    void resetLayout() {
        super.resetLayout();
        this.c.clear();
    }

    @Override
    float getMinInnerWidth() {
        return 27.0f;
    }

    @Override
    M calculateInnerSize(M parentInnerSize) {
        return this.getPreparedTextForWidth(parentInnerSize.b()).c();
    }

    cF getPreparedTextForWidth(float width) {
        q q2 = null;
        if (this.getDocument() != null) {
            q2 = this.getDocument().getDocumentContext();
        }
        if (q2 == null) {
            q2 = q.a();
        }
        return cF.a(this.getTextRuns(), width + cZ.a, this.getParagraphStyle(), this.getAlignment(), this.getLineSpacing(), q2);
    }

    private static void a(float f2, String string) {
        if (MinParagraphSpace > f2) {
            throw new IllegalArgumentException(au.a("{0} MUST be greater or equal to {1} points", string, Float.valueOf(f2)));
        }
        if (MaxParagraphSpace < f2) {
            throw new IllegalArgumentException(au.a("{0} MUST be less or equal to {1} points", string, Float.valueOf(f2)));
        }
    }

    void clearCachedValues() {
        this.b = null;
    }

    private void a() {
        if (this.a.size() <= 1) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.set_Item(n2, this.a.get_Item(i2));
            if (this.a.get_Item(n2).getLength() != 0) {
                ++n2;
                continue;
            }
            this.a.get_Item(n2).unbind();
        }
        if (n2 == 0) {
            ++n2;
            this.a.get_Item(0).bind(this);
        }
        this.a.removeRange(n2, this.a.size() - n2);
    }

    private void a(int n2, int n3, int n4) {
        if (n2 == this.a.size()) {
            return;
        }
        int n5 = n2;
        int n6 = 0;
        while (n2 < this.a.size() && n6 + this.a.get_Item(n5).getLength() < n3 + n4) {
            n6 += this.a.get_Item(n5).getLength();
            ++n5;
        }
        if (n5 == n2) {
            TextRun textRun = this.a.get_Item(n2);
            if (textRun.getLength() == n4) {
                this.a.removeAt(n2);
            } else {
                textRun.setText(au.a(textRun.getText(), n3, n4));
            }
        } else {
            int n7 = n2;
            if (n3 != 0) {
                ++n7;
                TextRun textRun = this.a.get_Item(n2);
                textRun.setText(au.b(textRun.getText(), 0, n3));
            }
            int n8 = n5;
            if (n6 + this.a.get_Item(n5).getLength() != n3 + n4) {
                --n8;
                TextRun textRun = this.a.get_Item(n5);
                int n9 = n3 + n4 - n6;
                textRun.setText(au.e(textRun.getText(), n9));
            }
            if (n7 <= n8) {
                this.a.removeRange(n7, n8 - n7 + 1);
            }
        }
        this.append(au.a);
    }

    private void a(String string, String string2, int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuilder.append(this.a.get_Item(i2).getText());
        }
        String string3 = stringBuilder.toString();
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = 0;
        while ((n4 = au.b(string3, string, n5)) != -1) {
            int n9;
            int n10;
            int n11 = n4 - n6 * (string.length() - string2.length());
            while (n7 < n3 && n8 + this.a.get_Item(n7).getLength() <= n11) {
                n8 += this.a.get_Item(n7).getLength();
                ++n7;
            }
            if (n7 < n3 && n11 + string.length() <= n8 + this.a.get_Item(n7).getLength()) {
                TextRun textRun = this.a.get_Item(n7);
                n10 = n11 - n8;
                n9 = n10 + string.length();
                textRun.setText(au.a(new String[]{au.b(textRun.getText(), 0, n10), string2, au.e(textRun.getText(), n9)}));
            } else if (au.b(string2)) {
                this.b(n7, n11 - n8, string.length());
            } else {
                int n12;
                TextRun textRun;
                int n13 = 0;
                n10 = 0;
                n9 = 0;
                if (n11 != n8) {
                    textRun = this.a.get_Item(n7);
                    n12 = aJ.d(textRun.getLength() - (n11 - n8), string.length());
                    n12 = aJ.d(n12, string2.length());
                    String string4 = textRun.getText();
                    textRun.setText(au.a(new String[]{au.b(string4, 0, n11 - n8), au.b(string2, n10, n12)}));
                    n13 += string4.length() - (n11 - n8);
                    n10 += n12;
                    n9 = textRun.getLength();
                    n8 += textRun.getLength();
                    ++n7;
                }
                while (n7 < n3 && n13 < string.length() && n10 < string2.length()) {
                    textRun = this.a.get_Item(n7);
                    n12 = textRun.getLength();
                    int n14 = aJ.d(n12, string.length() - n13);
                    if (n14 == string.length() - n13) {
                        textRun.setText(au.a(new String[]{au.e(string2, n10), au.e(textRun.getText(), n14)}));
                        n10 = string2.length();
                        n9 = textRun.getLength();
                    } else if (n14 <= string2.length() - n10) {
                        textRun.setText(au.b(string2, n10, n14));
                        n10 += n14;
                        n9 = n14;
                    } else {
                        textRun.setText(au.e(string2, n10));
                        n10 = string2.length();
                        n9 = textRun.getLength();
                    }
                    n13 += n14;
                    n8 += textRun.getLength();
                    ++n7;
                }
                if (n13 < string.length()) {
                    this.b(n7 - 1, n9, string.length() - n13);
                }
                n8 -= this.a.get_Item(--n7).getLength();
            }
            n5 = n4 + string.length();
            ++n6;
        }
    }

    private void a(String string, String string2, TextStyle textStyle, int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuilder.append(this.a.get_Item(i2).getText());
        }
        String string3 = stringBuilder.toString();
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = 0;
        while ((n4 = au.b(string3, string, n5)) != -1) {
            Object object;
            int n9 = n4 - n6 * (string.length() - string2.length());
            while (n7 < n3 && n8 + this.a.get_Item(n7).getLength() <= n9) {
                n8 += this.a.get_Item(n7).getLength();
                ++n7;
            }
            if (n7 < n3 && n9 + string.length() <= n8 + this.a.get_Item(n7).getLength()) {
                TextRun textRun = this.a.get_Item(n7);
                if (textRun.getLength() == string.length()) {
                    this.a.set_Item(n7, new TextRun(string2, textStyle.deepClone()).bind(this));
                } else {
                    String string4 = textRun.getText();
                    object = new List(3);
                    if (n9 != n8) {
                        textRun.setText(au.b(string4, 0, n9 - n8));
                        ((List)object).addItem(textRun);
                    }
                    if (!au.b(string2)) {
                        ((List)object).addItem(new TextRun(string2, textStyle.deepClone()).bind(this));
                    }
                    if (n9 + string.length() < n8 + string4.length()) {
                        ((List)object).addItem(new TextRun(au.e(string4, n9 - n8 + string.length()), textRun.getStyle().deepClone()).bind(this));
                    }
                    this.a.set_Item(n7, (TextRun)com.aspose.note.internal.b.m.d(object));
                    this.a.insertRange(n7 + 1, com.aspose.note.internal.b.m.b(com.aspose.note.internal.b.m.b(object, 1)));
                    n3 += ((List)object).size() - 1;
                }
            } else {
                int n10;
                int n11 = n8;
                for (n10 = n7; n10 < n3 && n11 + this.a.get_Item(n10).getLength() - n9 < string.length(); ++n10) {
                    object = this.a.get_Item(n10);
                    n11 += ((TextRun)object).getLength();
                    if ((n10 != n7 || n9 != n8) && n10 == n7) continue;
                    ((TextRun)object).setText(au.a);
                }
                if (n9 != n8) {
                    object = this.a.get_Item(n7);
                    ((TextRun)object).setText(au.b(((TextRun)object).getText(), 0, n9 - n8));
                }
                if (n11 + this.a.get_Item(n10).getLength() != n9 + string.length()) {
                    object = this.a.get_Item(n10);
                    int n12 = n9 + string.length() - n11;
                    ((TextRun)object).setText(au.e(((TextRun)object).getText(), n12));
                } else {
                    this.a.get_Item(n10).setText(au.a);
                }
                if (!au.b(string2)) {
                    if (n7 + 1 != n10) {
                        this.a.set_Item(n7 + 1, new TextRun(string2, textStyle.deepClone()).bind(this));
                    } else {
                        this.a.insertItem(n7 + 1, new TextRun(string2, textStyle.deepClone()).bind(this));
                        ++n3;
                    }
                }
            }
            n5 = n4 + string.length();
            ++n6;
        }
    }

    private void b(int n2, int n3, int n4) {
        TextRun textRun;
        if (n2 == this.a.size()) {
            return;
        }
        int n5 = 0;
        int n6 = n4;
        if (n3 != 0) {
            textRun = this.a.get_Item(n2);
            n5 += textRun.getLength();
            ++n2;
            int n7 = aJ.d(textRun.getLength() - n3, n4);
            textRun.setText(au.a(textRun.getText(), n3, n7));
            n6 -= n7;
        }
        while (n2 < this.a.size() && n5 + this.a.get_Item(n2).getLength() < n3 + n4 && (textRun = this.a.get_Item(n2)).getLength() <= n6) {
            n6 -= textRun.getLength();
            textRun.setText(au.a);
            n5 += textRun.getLength();
            ++n2;
        }
        if (n6 > 0) {
            textRun = this.a.get_Item(n2);
            textRun.setText(au.e(textRun.getText(), n6));
        }
    }

    @Override
    public IGenericEnumerator<Character> iterator() {
        String string = this.getText() == null ? "" : this.getText();
        return new cQ(this, string);
    }
}

