/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.note.system.collections;

import com.aspose.note.internal.aq.S;
import com.aspose.note.internal.aq.aI;
import com.aspose.note.internal.aq.az;
import com.aspose.note.system.collections.Comparer;
import com.aspose.note.system.collections.ICollection;
import com.aspose.note.system.collections.IEnumerator;
import com.aspose.note.system.collections.IList;
import com.aspose.note.system.exceptions.ArgumentException;
import com.aspose.note.system.exceptions.ArgumentNullException;
import com.aspose.note.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.note.system.exceptions.InvalidOperationException;
import com.aspose.note.system.exceptions.NotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayList
implements IList,
List {
    private static final int a = 4;
    private Object[] b;
    private int c;
    private int d;
    private static Object[] e = new Object[0];

    protected int getVersion() {
        return this.d;
    }

    public ArrayList() {
        this.b = new Object[4];
    }

    public ArrayList(ICollection c2) {
        if (c2 == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.b = new Object[c2.size()];
        this.addRange(c2);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.a("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.b = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.b = null;
    }

    private ArrayList(com.aspose.note.internal.aq.e array, int index, int count) {
        this.b = count == 0 ? new Object[4] : new Object[count];
        com.aspose.note.internal.aq.e.b(array, index, com.aspose.note.internal.aq.e.a(this.b), 0, count);
        this.c = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.c) {
            ArrayList.a("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.b[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.c) {
            ArrayList.a("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.b[index] = value;
        ++this.d;
    }

    @Override
    public int size() {
        return this.c;
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int value) {
        if (value < this.c) {
            ArrayList.a("Capacity", (Object)value, "Must be more than count.");
        }
        this.b = value > 0 ? Arrays.copyOf(this.b, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void a(int n2) {
        int n3;
        if (n2 <= this.b.length) {
            return;
        }
        int n4 = n3 = this.b.length == 0 ? 4 : this.b.length * 2;
        if (n3 < n2) {
            n3 = n2;
        }
        this.setCapacity(n3);
    }

    private void a(int n2, int n3) {
        if (n3 > 0) {
            if (this.c + n3 > this.b.length) {
                int n4;
                int n5 = n4 = this.b.length > 0 ? this.b.length << 1 : 1;
                while (n4 < this.c + n3) {
                    n4 <<= 1;
                }
                Object[] objectArray = new Object[n4];
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), 0, com.aspose.note.internal.aq.e.a(objectArray), 0, n2);
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), n2, com.aspose.note.internal.aq.e.a(objectArray), n2 + n3, this.c - n2);
                this.b = objectArray;
            } else {
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), n2, com.aspose.note.internal.aq.e.a(this.b), n2 + n3, this.c - n2);
            }
        } else if (n3 < 0) {
            int n6 = n2 - n3;
            com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), n6, com.aspose.note.internal.aq.e.a(this.b), n2, this.c - n6);
            aI.b(this.b, this.c + n3, -n3);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.b.length <= this.c) {
            this.a(this.c + 1);
        }
        this.b[this.c] = value;
        ++this.d;
        return this.c++;
    }

    @Override
    public void clear() {
        aI.b(this.b, 0, this.c);
        this.c = 0;
        ++this.d;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.c) > -1;
    }

    boolean a(Object object, int n2, int n3) {
        return this.indexOf(object, n2, n3) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.c - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.c) {
            ArrayList.a("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.a("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.c - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return aI.a(this.b, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.c - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return aI.b(this.b, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.c) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.a(index, 1);
        this.b[index] = value;
        ++this.c;
        ++this.d;
    }

    public void insertRange(int index, ICollection c2) {
        int n2;
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.c) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n2 = c2.size()) > 0) {
            if (this.b.length < this.c + n2) {
                this.a(this.c + n2);
            }
            if (index < this.c) {
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), index, com.aspose.note.internal.aq.e.a(this.b), index + n2, this.c - index);
            }
            if (this == c2.getSyncRoot()) {
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), 0, com.aspose.note.internal.aq.e.a(this.b), index, index);
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), index + n2, com.aspose.note.internal.aq.e.a(this.b), index << 1, this.c - index);
            } else {
                c2.copyTo(com.aspose.note.internal.aq.e.a(this.b), index);
            }
            this.c += c2.size();
            ++this.d;
        }
    }

    public void insertRange(int index, Object[] c2) {
        int n2;
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.c) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n2 = c2.length) > 0) {
            if (this.b.length < this.c + n2) {
                this.a(this.c + n2);
            }
            if (index < this.c) {
                com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), index, com.aspose.note.internal.aq.e.a(this.b), index + n2, this.c - index);
            }
            com.aspose.note.internal.aq.e.a(c2).copyTo(com.aspose.note.internal.aq.e.a(this.b), index);
            this.c += c2.length;
            ++this.d;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n2 = this.indexOf(obj);
        if (n2 > -1) {
            this.removeAt(n2);
        }
        ++this.d;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.c) {
            ArrayList.a("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.a(index, -1);
        --this.c;
        ++this.d;
    }

    public void removeRange(int index, int count) {
        ArrayList.a(index, count, this.c);
        this.a(index, -count);
        this.c -= count;
        ++this.d;
    }

    public void reverse() {
        aI.a(this.b, 0, this.c);
        ++this.d;
    }

    public void reverse(int index, int count) {
        ArrayList.a(index, count, this.c);
        aI.a(this.b, index, count);
        ++this.d;
    }

    public void copyTo(com.aspose.note.internal.aq.e array) {
        com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), 0, array, 0, this.c);
    }

    @Override
    public void copyTo(com.aspose.note.internal.aq.e array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.c);
    }

    public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.e() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.b), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new m(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.a(index, count, this.c);
        return new b(this, index, count);
    }

    public void addRange(ICollection c2) {
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.c, c2);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.c, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return aI.a(this.b, 0, this.c, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return aI.a(this.b, 0, this.c, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return aI.a(this.b, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.a(index, count, this.c);
        if (this.isSynchronized()) {
            return ArrayList.sync(new j(this, index, count));
        }
        return new j(this, index, count);
    }

    public void setRange(int index, ICollection c2) {
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c2.size() > this.c) {
            throw new ArgumentOutOfRangeException("index");
        }
        c2.copyTo(com.aspose.note.internal.aq.e.a(this.b), index);
        ++this.d;
    }

    public void trimToSize() {
        this.setCapacity(this.c);
    }

    public void sort() {
        Arrays.sort(this.b, 0, this.c, Comparer.Default);
        ++this.d;
    }

    public void sort(Comparator comparer) {
        try {
            Arrays.sort(this.b, 0, this.c, comparer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            com.aspose.note.internal.aq.e.a(this.b, 0, this.c, comparer);
        }
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.a(index, count, this.c);
        Arrays.sort(this.b, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.c];
        this.copyTo(com.aspose.note.internal.aq.e.a(objectArray));
        return objectArray;
    }

    public com.aspose.note.internal.aq.e toArray(az type) {
        com.aspose.note.internal.aq.e e2 = com.aspose.note.internal.aq.e.a(type, this.c);
        this.copyTo(e2);
        return e2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.note.internal.aq.e.a(this.b), 0, this.c);
    }

    static void a(int n2, int n3, int n4) {
        if (n2 < 0) {
            ArrayList.a("index", (Object)n2, "Can't be less than 0.");
        }
        if (n3 < 0) {
            ArrayList.a("count", (Object)n3, "Can't be less than 0.");
        }
        if (n2 > n4 - n3) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void a(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new a(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new n(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new o(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new k(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new l(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new e(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new f(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i2 = 0; i2 < count; ++i2) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a2) {
        if (a2.length <= this.size()) {
            a2 = new Object[this.size()];
        }
        this.copyTo(com.aspose.note.internal.aq.e.a(a2));
        return a2;
    }

    @Override
    public boolean add(Object o2) {
        int n2 = this.size();
        this.addItem(o2);
        return this.size() != n2;
    }

    @Override
    public boolean remove(Object o2) {
        int n2 = this.size();
        this.removeItem(o2);
        return this.size() != n2;
    }

    @Override
    public boolean containsAll(Collection c2) {
        for (Object e2 : c2) {
            if (this.contains(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c2) {
        return this.addAll(this.c, c2);
    }

    public boolean addAll(int index, Collection c2) {
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        int n2 = index;
        int n3 = this.size();
        for (Object e2 : c2) {
            this.insertItem(n2++, e2);
        }
        return n3 != this.size();
    }

    @Override
    public boolean removeAll(Collection c2) {
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        int n2 = this.size();
        for (Object e2 : c2) {
            this.removeItem(e2);
        }
        return n2 != this.size();
    }

    @Override
    public boolean retainAll(Collection c2) {
        Object[] objectArray;
        if (c2 == null) {
            throw new ArgumentNullException("c");
        }
        int n2 = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c2.contains(object)) continue;
            this.remove(object);
        }
        return n2 != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new h(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new h(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n2 = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n2);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new c(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    /* synthetic */ ArrayList(int x0, boolean x1, com.aspose.note.system.collections.a x2) {
        this(x0, x1);
    }

    private static class c
    extends ArrayList {
        private List a;
        private int b;

        @Override
        protected int getVersion() {
            return this.a instanceof ArrayList ? ((ArrayList)this.a).getVersion() : this.b;
        }

        public c(List list) {
            this.a = list;
            if (list instanceof ArrayList) {
                this.b = ((ArrayList)list).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set(index, value);
            ++this.b;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.a.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.a.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i2 = 0; i2 < value - this.a.size(); ++i2) {
                this.a.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n2 = this.a.size();
            this.a.add(value);
            ++this.b;
            return n2;
        }

        @Override
        public void clear() {
            this.a.clear();
            ++this.b;
        }

        @Override
        public boolean contains(Object item) {
            return this.a.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.a.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.a.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.a.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return aI.a(this.a.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.a.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return aI.b(this.a.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.a.add(index, value);
            ++this.b;
        }

        @Override
        public void insertRange(int index, ICollection c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e2 : c2) {
                this.a.add(index++, e2);
            }
            ++this.b;
        }

        @Override
        public void insertRange(int index, Object[] c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c2) {
                this.a.add(index++, object);
            }
            ++this.b;
        }

        @Override
        public void removeItem(Object obj) {
            this.a.remove(obj);
            ++this.b;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.a.remove(index);
            ++this.b;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i2 = 0; i2 < count; ++i2) {
                this.a.remove(index);
            }
            ++this.b;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n2 = index;
            for (int i2 = index + this.a.size() - 1; n2 < i2; ++n2, --i2) {
                Object e2 = this.a.get(n2);
                this.a.set(n2, this.a.get(i2));
                this.a.set(i2, e2);
            }
            ++this.b;
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array) {
            com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.a.toArray()), 0, array, 0, this.a.size());
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.a.size());
        }

        @Override
        public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.e() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.a.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new m(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.a(index, count, this.a.size());
            return new b(this, index, count);
        }

        @Override
        public void addRange(ICollection c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c2);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.a.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return aI.a(this.a.toArray(), 0, this.a.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return aI.a(this.a.toArray(), 0, this.a.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return aI.a(this.a.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.a(index, count, this.a.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new j(this, index, count));
            }
            return new j(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c2.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e2 : c2) {
                this.a.set(index++, e2);
            }
            ++this.b;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.a, null);
            ++this.b;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.a, comparer);
            ++this.b;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.a.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i2 = index; i2 < count; ++i2) {
                this.a.set(i2, list.get(i2 - index));
            }
            ++this.b;
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public com.aspose.note.internal.aq.e toArray(az type) {
            com.aspose.note.internal.aq.e e2 = com.aspose.note.internal.aq.e.a(type, this.a.size());
            this.copyTo(e2);
            return e2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.a.size()];
            com.aspose.note.internal.aq.e.b(com.aspose.note.internal.aq.e.a(this.a.toArray()), 0, com.aspose.note.internal.aq.e.a(objectArray), 0, this.a.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e2 : arrayList) {
                arrayList.add(e2);
            }
            return new c(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.a.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a2) {
            return this.a.toArray(a2);
        }

        @Override
        public boolean add(Object o2) {
            ++this.b;
            return this.a.add(o2);
        }

        @Override
        public boolean remove(Object o2) {
            ++this.b;
            return this.a.remove(o2);
        }

        @Override
        public boolean containsAll(Collection c2) {
            return this.a.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection c2) {
            ++this.b;
            return this.a.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection c2) {
            ++this.b;
            return this.a.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection c2) {
            ++this.b;
            return this.a.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection c2) {
            ++this.b;
            return this.a.retainAll(c2);
        }

        @Override
        public Object get(int index) {
            return this.a.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.b;
            return this.a.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.a.add(index, element);
            ++this.b;
        }

        @Override
        public Object remove(int index) {
            ++this.b;
            return this.a.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.a.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.a.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.a.subList(fromIndex, toIndex);
        }
    }

    private class h
    extends g
    implements ListIterator {
        h(int n2) {
            super(null);
            this.a = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        public Object previous() {
            int n2 = this.a - 1;
            if (n2 < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2;
            this.b = n2;
            return objectArray[this.b];
        }

        public void set(Object e2) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).b[this.b] = e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e2) {
            try {
                int n2 = this.a;
                ArrayList.this.add(n2, e2);
                this.a = n2 + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class g
    implements Iterator {
        int a;
        int b = -1;

        private g() {
        }

        @Override
        public boolean hasNext() {
            return this.a != ArrayList.this.size();
        }

        public Object next() {
            int n2 = this.a;
            if (n2 >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2 + 1;
            this.b = n2;
            return objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ g(com.aspose.note.system.collections.a a2) {
            this();
        }
    }

    private static class i
    implements IList {
        protected IList a;

        public i(IList iList) {
            this.a = iList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }
    }

    private static final class l
    extends f {
        @Override
        protected String a() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public l(IList iList) {
            super(iList);
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.a());
        }
    }

    private static class f
    extends i {
        protected String a() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public f(IList iList) {
            super(iList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.a());
        }
    }

    private static final class o
    extends i {
        private Object b;

        public o(IList iList) {
            super(iList);
            this.b = iList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }
    }

    private static final class j
    extends d {
        private int b;
        private int c;
        private int d;

        public j(ArrayList arrayList, int n2, int n3) {
            super(arrayList);
            this.b = n2;
            this.c = n3;
            this.d = arrayList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.a.get_Item(this.b + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.a.set_Item(this.b + index, value);
        }

        @Override
        public int size() {
            this.a();
            return this.c;
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.c) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void a() {
            if (this.d != this.a.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.a();
            this.a.insertItem(this.b + this.c, value);
            this.d = this.a.getVersion();
            return ++this.c;
        }

        @Override
        public void clear() {
            this.a();
            this.a.removeRange(this.b, this.c);
            this.c = 0;
            this.d = this.a.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.a(value, this.b, this.c);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.c - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.c) {
                j.a("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                j.a("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.c - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n2 = this.a.indexOf(value, this.b + startIndex, count);
            if (n2 == -1) {
                return -1;
            }
            return n2 - this.b;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.c - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n2;
            if (startIndex < 0) {
                j.a("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                j.a("count", (Object)count, "count is negative.");
            }
            if ((n2 = this.a.lastIndexOf(value, this.b + startIndex, count)) == -1) {
                return -1;
            }
            return n2 - this.b;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a();
            if (index < 0 || index > this.c) {
                j.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.insertItem(this.b + index, value);
            ++this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c2) {
            this.a();
            if (index < 0 || index > this.c) {
                j.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.insertRange(this.b + index, c2);
            this.c += c2.size();
            this.d = this.a.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.a();
            int n2 = this.indexOf(value);
            if (n2 > -1) {
                this.removeAt(n2);
            }
            this.d = this.a.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.a();
            if (index < 0 || index > this.c) {
                j.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.removeAt(this.b + index);
            --this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.a();
            j.a(index, count, this.c);
            this.a.removeRange(this.b + index, count);
            this.c -= count;
            this.d = this.a.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.c);
        }

        @Override
        public void reverse(int index, int count) {
            this.a();
            j.a(index, count, this.c);
            this.a.reverse(this.b + index, count);
            this.d = this.a.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c2) {
            this.a();
            if (index < 0 || index > this.c) {
                j.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.setRange(this.b + index, c2);
            this.d = this.a.getVersion();
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            this.copyTo(0, array, index, this.c);
        }

        @Override
        public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
            j.a(index, count, this.c);
            this.a.copyTo(this.b + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.c);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            j.a(index, count, this.c);
            return this.a.iterator(this.b + index, count);
        }

        @Override
        public void addRange(ICollection c2) {
            this.a();
            this.a.insertRange(this.c, c2);
            this.c += c2.size();
            this.d = this.a.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.c, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.c, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            j.a(index, count, this.c);
            return this.a.binarySearch(this.b + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new j((ArrayList)this.a.deepClone(), this.b, this.c);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            j.a(index, count, this.c);
            return new j(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.c, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.a();
            j.a(index, count, this.c);
            this.a.sort(this.b + index, count, comparer);
            this.d = this.a.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.c];
            this.a.copyTo(this.b, com.aspose.note.internal.aq.e.a(objectArray), 0, this.c);
            return objectArray;
        }

        @Override
        public com.aspose.note.internal.aq.e toArray(az elementType) {
            com.aspose.note.internal.aq.e e2 = com.aspose.note.internal.aq.e.a(elementType, this.c);
            this.a.copyTo(this.b, e2, 0, this.c);
            return e2;
        }
    }

    private static final class k
    extends e {
        @Override
        protected String a() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public k(ArrayList arrayList) {
            super(arrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void setRange(int index, ICollection c2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.a());
        }
    }

    private static class e
    extends d {
        public e(ArrayList arrayList) {
            super(arrayList);
        }

        protected String a() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void addRange(ICollection c2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int index, ICollection c2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int index, Object[] c2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.a());
        }
    }

    private static final class n
    extends d {
        private Object b;

        n(ArrayList arrayList) {
            super(arrayList);
            this.b = arrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.b;
            synchronized (object) {
                this.a.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c2) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertRange(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(com.aspose.note.internal.aq.e array) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c2) {
            Object object = this.b;
            synchronized (object) {
                this.a.addRange(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.b;
            synchronized (object) {
                return this.a.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.b;
            synchronized (object) {
                this.a.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.b;
            synchronized (object) {
                this.a.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public com.aspose.note.internal.aq.e toArray(az elementType) {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray(elementType);
            }
        }
    }

    private static class d
    extends ArrayList {
        protected ArrayList a;

        public d(ArrayList arrayList) {
            this.a = arrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.a.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.a.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.a.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.a.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.a.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.a.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c2) {
            this.a.insertRange(index, c2);
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.a.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.a.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.a.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c2) {
            this.a.setRange(index, c2);
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array) {
            this.a.copyTo(array);
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
            this.a.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.a.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c2) {
            this.a.addRange(c2);
        }

        @Override
        public int binarySearch(Object value) {
            return this.a.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.a.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.a.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.a.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.a.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.a.trimToSize();
        }

        @Override
        public void sort() {
            this.a.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.a.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.a.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public com.aspose.note.internal.aq.e toArray(az elementType) {
            return this.a.toArray(elementType);
        }
    }

    private static final class com.aspose.note.system.collections.ArrayList$a
    extends ArrayList {
        private IList a;

        public com.aspose.note.system.collections.ArrayList$a(IList iList) {
            super(0, true, null);
            this.a = iList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.a.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.a.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.a.size()) {
                com.aspose.note.system.collections.ArrayList$a.a("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.a.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i2 = startIndex; i2 < startIndex + count; ++i2) {
                    if (this.a.get_Item(i2) != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = startIndex; i3 < startIndex + count; ++i3) {
                    if (!value.equals(this.a.get_Item(i3))) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.a.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i2 = startIndex; i2 > startIndex - count; --i2) {
                    if (this.a.get_Item(i2) != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = startIndex; i3 > startIndex - count; --i3) {
                    if (!value.equals(this.a.get_Item(i3))) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.a.size()) {
                com.aspose.note.system.collections.ArrayList$a.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e2 : c2) {
                this.a.insertItem(index++, e2);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            for (int i2 = 0; i2 < count; ++i2) {
                this.a.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int index, int count) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            for (int i2 = 0; i2 < count / 2; ++i2) {
                Object object = this.a.get_Item(i2 + index);
                this.a.set_Item(i2 + index, this.a.get_Item(index + count - i2 + index - 1));
                this.a.set_Item(index + count - i2 + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c2) {
            if (c2 == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c2.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n2 = index;
            for (Object e2 : c2) {
                this.a.set_Item(n2++, e2);
            }
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array) {
            this.a.copyTo(array, 0);
        }

        @Override
        public void copyTo(com.aspose.note.internal.aq.e array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, com.aspose.note.internal.aq.e array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                com.aspose.note.system.collections.ArrayList$a.a("index", (Object)index, "Can't be less than zero.");
            }
            if (array.e() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.f() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i2 = 0; i2 < count; ++i2) {
                array.c(this.a.get_Item(index + i2), arrayIndex + i2);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            return new a(this.a.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c2) {
            for (Object e2 : c2) {
                this.a.addItem(e2);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.a.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n2 = index;
            int n3 = index + count - 1;
            while (n2 <= n3) {
                int n4;
                int n5 = n2 + (n3 - n2) / 2;
                try {
                    n4 = comparer.compare(value, this.a.get_Item(n5));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n4 < 0) {
                    n3 = n5 - 1;
                    continue;
                }
                if (n4 > 0) {
                    n2 = n5 + 1;
                    continue;
                }
                return n5;
            }
            return ~n2;
        }

        @Override
        public Object deepClone() {
            return new com.aspose.note.system.collections.ArrayList$a(this.a);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            return new j(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.a.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            com.aspose.note.system.collections.ArrayList$a.a(index, count, this.a.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            com.aspose.note.system.collections.ArrayList$a.a(this.a, index, index + count - 1, comparer);
        }

        private static void a(IList iList, int n2, int n3) {
            Object object = iList.get_Item(n2);
            iList.set_Item(n2, iList.get_Item(n3));
            iList.set_Item(n3, object);
        }

        static void a(IList iList, int n2, int n3, Comparator comparator) {
            if (n2 >= n3) {
                return;
            }
            int n4 = n2 + (n3 - n2) / 2;
            if (comparator.compare(iList.get_Item(n4), iList.get_Item(n2)) < 0) {
                com.aspose.note.system.collections.ArrayList$a.a(iList, n4, n2);
            }
            if (comparator.compare(iList.get_Item(n3), iList.get_Item(n2)) < 0) {
                com.aspose.note.system.collections.ArrayList$a.a(iList, n3, n2);
            }
            if (comparator.compare(iList.get_Item(n3), iList.get_Item(n4)) < 0) {
                com.aspose.note.system.collections.ArrayList$a.a(iList, n3, n4);
            }
            if (n3 - n2 + 1 <= 3) {
                return;
            }
            com.aspose.note.system.collections.ArrayList$a.a(iList, n3 - 1, n4);
            Object object = iList.get_Item(n3 - 1);
            int n5 = n2;
            int n6 = n3 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n5), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n6), object) > 0) {
                }
                if (n5 >= n6) break;
                com.aspose.note.system.collections.ArrayList$a.a(iList, n5, n6);
            }
            com.aspose.note.system.collections.ArrayList$a.a(iList, n3 - 1, n5);
            com.aspose.note.system.collections.ArrayList$a.a(iList, n2, n5 - 1, comparator);
            com.aspose.note.system.collections.ArrayList$a.a(iList, n5 + 1, n3, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.a.size()];
            this.a.copyTo(com.aspose.note.internal.aq.e.a(objectArray), 0);
            return objectArray;
        }

        @Override
        public com.aspose.note.internal.aq.e toArray(az elementType) {
            com.aspose.note.internal.aq.e e2 = com.aspose.note.internal.aq.e.a(elementType, this.a.size());
            this.a.copyTo(e2, 0);
            return e2;
        }

        private static final class a
        implements S,
        IEnumerator,
        Cloneable {
            private int a;
            private int b;
            private int c;
            private IEnumerator d;

            private a() {
            }

            public a(IEnumerator iEnumerator, int n2, int n3) {
                this.b = 0;
                this.a = n2;
                this.c = n3;
                this.d = iEnumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.a();
            }

            @Override
            public Object next() {
                return this.d.next();
            }

            @Override
            public boolean hasNext() {
                if (this.b >= this.c) {
                    return false;
                }
                ++this.b;
                return this.d.hasNext();
            }

            @Override
            public void reset() {
                this.b = 0;
                this.d.reset();
                for (int i2 = 0; i2 < this.a; ++i2) {
                    this.d.hasNext();
                }
            }

            protected Object a() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                a a2 = new a();
                a2.a = this.a;
                a2.b = this.b;
                a2.c = this.c;
                a2.d = this.d;
                return a2;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class m
    implements S,
    IEnumerator,
    Cloneable {
        private ArrayList b;
        private Object c;
        private int d;
        private int e;
        static Object a = new Object();

        private m() {
        }

        public m(ArrayList arrayList) {
            this.b = arrayList;
            this.d = -1;
            this.e = arrayList.getVersion();
            this.c = a;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        @Override
        public boolean hasNext() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.d < this.b.size()) {
                this.c = this.b.get_Item(this.d);
                return true;
            }
            this.c = a;
            return false;
        }

        @Override
        public Object next() {
            if (this.c == a) {
                if (this.d == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.c;
        }

        @Override
        public void reset() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.c = a;
            this.d = -1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            m m2 = new m();
            m2.b = this.b;
            m2.c = this.c;
            m2.d = this.d;
            m2.e = this.e;
            return m2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class b
    implements S,
    IEnumerator,
    Cloneable {
        private Object a;
        private ArrayList b;
        private int c;
        private int d;
        private int e;
        private int f;

        private b() {
        }

        public b(ArrayList arrayList) {
            this(arrayList, 0, arrayList.size());
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        public b(ArrayList arrayList, int n2, int n3) {
            this.b = arrayList;
            this.d = n2;
            this.e = n3;
            this.c = this.d - 1;
            this.a = null;
            this.f = arrayList.getVersion();
        }

        @Override
        public Object next() {
            if (this.c == this.d - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.a;
        }

        @Override
        public boolean hasNext() {
            if (this.b.getVersion() != this.f) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.c;
            if (this.c - this.d < this.e) {
                this.a = this.b.get_Item(this.c);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.a = null;
            this.c = this.d - 1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            b b2 = new b();
            b2.a = this.a;
            b2.b = this.b;
            b2.c = this.c;
            b2.d = this.d;
            b2.e = this.e;
            b2.f = this.f;
            return b2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

