/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Font;
import com.aspose.pdf.FontStyles;
import com.aspose.pdf.exceptions.FontNotFoundException;
import com.aspose.pdf.internal.ms.System.Collections.Generic.z16;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.z1;
import com.aspose.pdf.internal.ms.System.IO.z14;
import com.aspose.pdf.internal.ms.System.IO.z34;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z64;
import com.aspose.pdf.internal.ms.System.z8;
import com.aspose.pdf.internal.p228.z142;
import com.aspose.pdf.internal.p228.z144;
import com.aspose.pdf.internal.p228.z150;
import com.aspose.pdf.internal.p228.z153;
import com.aspose.pdf.internal.p228.z208;
import com.aspose.pdf.internal.p228.z24;
import com.aspose.pdf.internal.p63.z17;
import com.aspose.pdf.internal.p77.z2;
import com.aspose.pdf.internal.p953.z9;
import com.aspose.pdf.text.FontSourceCollection;
import com.aspose.pdf.text.FontSubstitutionCollection;
import com.aspose.pdf.text.FontTypes;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FontRepository {
    private static final Logger m1 = Logger.getLogger(FontRepository.class.getName());
    private static final z9 m2;
    private static boolean m3;

    public static FontSubstitutionCollection getSubstitutions() {
        return z17.m1().m2();
    }

    public static FontSourceCollection getSources() {
        return z17.m1().m3();
    }

    public static Font findFont(String fontName) {
        z150 z1502 = z17.m1().m1(fontName);
        if (z1502 == null) {
            throw new FontNotFoundException(z133.m1("Font {0} was not found", new Object[]{fontName}));
        }
        z208 z2082 = z2.m1(z1502);
        return new Font(z2082);
    }

    public static Font findFont(String fontName, boolean ignoreCase) {
        z150 z1502 = z17.m1().m1(fontName, false, ignoreCase);
        if (z1502 == null) {
            throw new FontNotFoundException(z133.m1("Font {0} was not found", new Object[]{fontName}));
        }
        z208 z2082 = z2.m1(z1502);
        return new Font(z2082);
    }

    public static Font findFont(String fontFamilyName, int stl) {
        return FontRepository.findFont(fontFamilyName, stl, false);
    }

    public static Font findFont(String fontFamilyName, int stl, boolean ignoreCase) {
        int n = stl;
        String string = fontFamilyName;
        String string2 = z133.m1;
        z16<String> z1610 = new z16<String>();
        if (z133.m8(fontFamilyName, "Bold") != -1) {
            n |= 1;
            string = z133.m1(string, "Bold", z133.m1);
        }
        if (z133.m8(fontFamilyName, "Italic") != -1) {
            n |= 2;
            string = z133.m1(string, "Italic", z133.m1);
        }
        if (z133.m8(fontFamilyName, "Oblique") != -1) {
            n |= 2;
            string = z133.m1(string, "Oblique", z133.m1);
        }
        if ((n & 1) != 0) {
            string2 = "Bold";
        }
        if ((n & 2) != 0) {
            z1610.addItem(z133.m1(new String[]{string, string2, "Italic"}));
            z1610.addItem(z133.m1(new String[]{string, "Italic", string2}));
            z1610.addItem(z133.m1(new String[]{string, string2, "Oblique"}));
            z1610.addItem(z133.m1(new String[]{string, "Oblique", string2}));
        } else {
            z1610.addItem(z133.m1(new String[]{string, string2}));
            if (n == 0) {
                z1610.addItem(z133.m1(new String[]{string, "Regular"}));
            }
        }
        z150 z1502 = FontRepository.m1(z1610, ignoreCase);
        if (z1502 == null) {
            if (n != 0) {
                throw new z8(z133.m1("Font {0} with style {1} was not found", new Object[]{fontFamilyName, z64.m1(FontStyles.class, n)}));
            }
            throw new z8(z133.m1("Font {0} was not found", new Object[]{fontFamilyName}));
        }
        z208 z2082 = z2.m1(z1502);
        return new Font(z2082);
    }

    private static z150 m1(z16<String> z1610, boolean bl) {
        z150 z1502 = null;
        for (String string : z1610) {
            z1502 = z17.m1().m1(string, false, bl);
            if (z1502 == null) continue;
            return z1502;
        }
        return null;
    }

    public static Font openFont(InputStream fontStream, int fontType) {
        return FontRepository.m1(Stream.fromJava(fontStream), fontType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font m1(Stream stream, int n) {
        if (n == 0) {
            byte[] byArray;
            int n2 = 0;
            z1 z1100 = new z1(stream);
            try {
                byArray = z1100.m9((int)stream.getLength());
            }
            finally {
                if (z1100 != null) {
                    z1100.dispose();
                }
            }
            try {
                return new Font(z144.m1(new z150(n2, new z153[]{new z153(new z24(byArray))})));
            }
            catch (Exception exception) {
                m1.log(Level.INFO, "Exception occur", exception);
                return null;
            }
        }
        throw new IllegalStateException(z133.m1("font type {0} is not supported", new Object[]{z64.m1(FontTypes.class, n)}));
    }

    public static Font openFont(String fontFilePath) {
        return FontRepository.openFont(fontFilePath, null);
    }

    public static Font openFont(String fontFilePath, String metricsFilePath) {
        int n;
        if (!z14.m5(fontFilePath)) {
            throw new z8("Specified font file was not found" + fontFilePath);
        }
        String string = z133.m1(z133.m7(z34.m5(fontFilePath)), ".", z133.m1);
        switch (m2.m1(string)) {
            case 0: 
            case 1: 
            case 2: {
                n = 0;
                break;
            }
            case 3: 
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new z8("Could not determine font type of font file specified");
            }
        }
        z16<z153> z1610 = new z16<z153>(2);
        z1610.addItem(new z153(string, new z142(fontFilePath)));
        if (metricsFilePath != null && !z133.m5(metricsFilePath, z133.m1)) {
            if (!z14.m5(metricsFilePath)) {
                throw new IllegalStateException("Specified font metrics file was not found");
            }
            z1610.addItem(new z153(z133.m7(z34.m5(metricsFilePath)), new z142(fontFilePath)));
        }
        try {
            return new Font(z144.m1(new z150(n, z1610.toArray(new z153[0]))));
        }
        catch (Exception exception) {
            m1.log(Level.INFO, "Exception occur", exception);
            throw new z8("The font object can't be created from the file: " + fontFilePath);
        }
    }

    public static void loadFonts() {
        z17.m1().m6();
    }

    public static boolean isReplaceNotFoundFonts() {
        return m3;
    }

    public static void setReplaceNotFoundFonts(boolean value) {
        m3 = value;
    }

    static {
        m1.setUseParentHandlers(false);
        m2 = new z9("ttf", "ttc", "otf", "pfb", "pfa");
    }
}

