/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.AppearanceDictionary;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.Operator;
import com.aspose.pdf.OperatorCollection;
import com.aspose.pdf.PDF3DArtwork;
import com.aspose.pdf.PDF3DContent;
import com.aspose.pdf.PDF3DLightingScheme;
import com.aspose.pdf.PDF3DRenderMode;
import com.aspose.pdf.PDF3DView;
import com.aspose.pdf.PDF3DViewArray;
import com.aspose.pdf.Page;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.z32;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.p73.z14;
import com.aspose.pdf.internal.p73.z16;
import com.aspose.pdf.internal.p73.z21;
import com.aspose.pdf.internal.p73.z26;
import com.aspose.pdf.internal.p73.z28;
import com.aspose.pdf.internal.p73.z31;
import com.aspose.pdf.internal.p73.z37;
import com.aspose.pdf.internal.p77.z2;
import com.aspose.pdf.internal.p953.z5;
import java.io.InputStream;

public final class PDF3DAnnotation
extends Annotation {
    private XForm m7;
    PDF3DView m5;
    private z21 m8;
    private PDF3DArtwork m9;
    int m6 = 1;
    private Stream m10;

    public PDF3DArtwork getPdf3DArtwork() {
        return this.m9;
    }

    public PDF3DLightingScheme getLightingScheme() {
        return this.m9.getLightingScheme();
    }

    public PDF3DContent getContent() {
        return this.m9.m1.getContent();
    }

    public void setContent(PDF3DContent value) {
        this.m9.m1.setContent(value);
    }

    public PDF3DRenderMode getRenderMode() {
        return this.m9.getRenderMode();
    }

    public void setDefaultViewIndex(int index) {
        this.m6 = index;
        if (this.m9.getViewArray().getCount() > 0) {
            int n = this.m5.m3;
            this.m5 = this.m9.getViewArray().m1(this.m6);
            this.m5.m3 = n;
            this.m5.m4 = z2.m1(this.m8, this.m5.m3, 0, (z16)this.m5.m1);
            this.getEngineDict().m1("3DV", (z16)this.m5.m4);
        }
    }

    public PDF3DViewArray getViewArray() {
        return this.m9.getViewArray();
    }

    public PDF3DAnnotation(Page page, Rectangle rect, PDF3DArtwork pdf3DArtwork) {
        this(page, rect, pdf3DArtwork, 2);
    }

    public PDF3DAnnotation(Page page, Rectangle rect, PDF3DArtwork pdf3DArtwork, int activation) {
        super(page, rect);
        if (pdf3DArtwork.m1.m3.size() != 0 && pdf3DArtwork.m1.m3.containsKey(this.getEngineObj().m48())) {
            throw new z72("3D Stream is already added to current 3D Artwork");
        }
        pdf3DArtwork.m1.m3.addItem(this.getEngineObj().m48(), this.getEngineObj().m48());
        pdf3DArtwork.m4 = true;
        pdf3DArtwork.m3 = this;
        this.m9 = pdf3DArtwork;
        this.m9.m3 = this;
        this.getEngineDict().m2("Subtype", (z16)new z28("3D"));
        IDocument iDocument = this.m3;
        this.m8 = (z21)((Object)z5.m1(iDocument.getEngineDoc().m2(), z21.class));
        this.getEngineDict().m2("Content", (z16)new z37(this.m8, "3D Model"));
        z26 z2610 = new z26(this.m8);
        switch (activation) {
            case 0: {
                z2610.m1("A", (z16)new z28("PO"));
                break;
            }
            case 1: {
                z2610.m1("A", (z16)new z28("PV"));
                break;
            }
            case 2: {
                z2610.m1("A", (z16)new z28("XA"));
            }
        }
        z2610.m1("D", (z16)new z28("XD"));
        z2610.m1("DIS", (z16)new z28("I"));
        z2610.m1("Style", (z16)new z28("Embedded"));
        this.getEngineDict().m2("3DA", (z16)new z26(z2610));
        this.getEngineDict().m1("3DD", (z16)this.m9.m1.m2);
        if (this.m9.getViewArray().getCount() > 0) {
            this.m5 = this.m9.getViewArray().m1(this.m6);
            this.m5.m3 = this.m8.m75().m5();
            this.m5.m4 = new z31(this.m8, this.m5.m3, 0, this.m5.m1);
            this.getEngineDict().m1("3DV", (z16)this.m5.m4);
        }
    }

    PDF3DAnnotation(z14 obj, IDocument doc) {
        super(obj, doc);
        this.m9 = new PDF3DArtwork(obj, doc, this);
        this.m9.m3 = this;
        if (this.getAppearance().containsKey("N")) {
            if (this.getNormalAppearance().getResources().getImages().size() == 1) {
                this.m10 = new z32();
                this.getNormalAppearance().getResources().getImages().get_Item(1).m1(this.m10);
            } else if (this.getNormalAppearance().getResources().getImages().size() != 0) {
                OperatorCollection operatorCollection = this.m7.getContents();
                String string = operatorCollection.m4().m1("Do").m1(0).m5().toString();
                for (int i = 0; i < this.getNormalAppearance().getResources().getImages().size(); ++i) {
                    if (!z133.m5(this.getNormalAppearance().getResources().getImages().get_Item(i).getName(), string)) continue;
                    this.m10 = this.getNormalAppearance().getResources().getImages().get_Item((int)i).m1.m28().m5();
                }
            }
        }
    }

    @Override
    public int getAnnotationType() {
        return 27;
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    public void setImagePreview(String filename) {
        com.aspose.pdf.internal.ms.System.IO.z28 z2810 = new com.aspose.pdf.internal.ms.System.IO.z28(filename, 3, 1);
        try {
            this.m2(z2810);
        }
        finally {
            if (z2810 != null) {
                z2810.dispose();
            }
        }
    }

    public void setImagePreview(InputStream image) {
        this.m2(Stream.fromJava(image));
    }

    void m2(Stream stream) {
        AppearanceDictionary appearanceDictionary = this.getAppearance();
        this.m7 = appearanceDictionary.m1("N");
        stream.seek(0L, 0);
        if (this.m7.getResources().getImages().size() != 0) {
            this.m7.getResources().getImages().delete();
        }
        this.m10 = stream;
        this.m7.getResources().getImages().m2(stream);
        this.m7.setBBox(new Rectangle(0.0, 0.0, this.m7.getResources().getImages().get_Item(1).getWidth(), this.m7.getResources().getImages().get_Item(1).getHeight()));
        OperatorCollection operatorCollection = this.m7.getContents();
        operatorCollection.add(new Operator.GSave());
        operatorCollection.add(new Operator.ConcatenateMatrix(this.m7.getResources().getImages().get_Item(1).getWidth(), 0.0, 0.0, this.m7.getResources().getImages().get_Item(1).getHeight(), 0.0, 0.0));
        operatorCollection.add(new Operator.Do(this.m7.getResources().getImages().get_Item(1).getName()));
        operatorCollection.add(new Operator.GRestore());
    }

    public void clearImagePreview() {
        AppearanceDictionary appearanceDictionary = this.getAppearance();
        this.m7 = appearanceDictionary.m1("N");
        if (this.m7 != null && this.m7.getResources().getImages().size() != 0) {
            this.m7.getResources().getImages().delete();
        }
        this.getAppearance().clear();
    }

    public InputStream getImagePreview() {
        return Stream.toJava(this.m17());
    }

    Stream m17() {
        if (this.m10 != null) {
            return this.m10;
        }
        return null;
    }

    @Override
    void m1() {
        z14 z1410 = this.getNormalAppearance().m3;
        this.getNormalAppearance().getResources().getImages().delete();
        z1410.m75().m3(z1410);
        this.m9.m1();
    }
}

