/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationType;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Page;
import com.aspose.pdf.PopupAnnotation;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.Redaction;
import com.aspose.pdf.TextAnnotation;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.XfdfWriter;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.z14;
import com.aspose.pdf.internal.ms.System.IO.z28;
import com.aspose.pdf.internal.ms.System.IO.z32;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z63;
import com.aspose.pdf.internal.p17.z11;
import com.aspose.pdf.internal.p779.z6;
import com.aspose.pdf.internal.p953.z5;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfAnnotationEditor
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfAnnotationEditor.class.getName());

    private int[] m1() {
        int[] nArray = new int[this.getDocument().getPages().size()];
        int n = 0;
        for (Page page : this.getDocument().getPages()) {
            nArray[n] = page.getAnnotations().size();
            ++n;
        }
        return nArray;
    }

    private void m1(int[] nArray, int[] nArray2) {
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            Page page = this.getDocument().getPages().get_Item(i);
            for (int j = page.getAnnotations().size(); j > nArray[i - 1]; --j) {
                Annotation annotation = page.getAnnotations().get_Item(j);
                boolean bl = false;
                for (int n : nArray2) {
                    if (annotation.getAnnotationType() != n) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                page.getAnnotations().delete(annotation);
            }
        }
    }

    private void m1(int[] nArray) {
        int[] nArray2 = new int[this.getDocument().getPages().size()];
        this.m1(nArray2, nArray);
    }

    private static int[] m1(String[] stringArray) {
        int n = 0;
        int[] nArray = new int[stringArray.length];
        for (String string : stringArray) {
            nArray[n++] = (int)z63.parse(z5.m1(AnnotationType.class), string);
        }
        return nArray;
    }

    public void importAnnotationFromXfdf(String xfdfFile) {
        this.m4();
        z28 z2810 = z14.m6(xfdfFile);
        try {
            XfdfReader.readAnnotations(z2810.toInputStream(), this.getDocument());
        }
        finally {
            if (z2810 != null) {
                z2810.dispose();
            }
        }
        this.getDocument().afterImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAnnotationFromXfdf(String xfdfFile, int[] annotType) {
        this.m4();
        int[] nArray = this.m1();
        z28 z2810 = z14.m6(xfdfFile);
        try {
            XfdfReader.readAnnotations(z2810.toInputStream(), this.getDocument());
        }
        finally {
            if (z2810 != null) {
                z2810.dispose();
            }
        }
        this.m1(nArray, annotType);
        this.getDocument().afterImport();
    }

    public void importAnnotationFromXfdf(InputStream xfdfStream, int[] annotType) {
        this.m1(Stream.fromJava(xfdfStream), annotType);
    }

    void m1(Stream stream, int[] nArray) {
        this.m4();
        int[] nArray2 = this.m1();
        XfdfReader.readAnnotations(stream.toInputStream(), this.getDocument());
        this.m1(nArray2, nArray);
        this.getDocument().afterImport();
    }

    public void importAnnotationFromXfdf(InputStream xfdfSteam) {
        this.m2(Stream.fromJava(xfdfSteam));
    }

    void m2(Stream stream) {
        this.m4();
        XfdfReader.readAnnotations(stream.toInputStream(), this.getDocument());
        this.getDocument().afterImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAnnotations(String[] annotFile, int[] annotType) {
        this.m4();
        int[] nArray = this.m1();
        for (String string : annotFile) {
            z28 z2810 = z14.m6(string);
            try {
                z32 z3210 = new z32();
                try {
                    XfdfWriter.writeAnnotations(z3210, new Document(z2810));
                    ((Stream)z3210).seek(0L, 0);
                    XfdfReader.readAnnotations(z3210.toInputStream(), this.getDocument());
                    this.m1(nArray, annotType);
                }
                finally {
                    if (z3210 != null) {
                        z3210.dispose();
                    }
                }
            }
            finally {
                if (z2810 != null) {
                    z2810.dispose();
                }
            }
        }
        this.getDocument().afterImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAnnotations(String[] annotFile) {
        this.m4();
        for (String string : annotFile) {
            z32 z3210 = new z32();
            try {
                XfdfWriter.writeAnnotations(z3210, new Document(string));
                ((Stream)z3210).seek(0L, 0);
                XfdfReader.readAnnotations(z3210.toInputStream(), this.getDocument());
            }
            finally {
                if (z3210 != null) {
                    z3210.dispose();
                }
            }
        }
        this.getDocument().afterImport();
    }

    public void importAnnotations(InputStream[] annotFileInputStream, int[] annotType) {
        Stream[] streamArray = new Stream[annotFileInputStream.length];
        for (int i = 0; i < annotFileInputStream.length; ++i) {
            streamArray[i] = Stream.fromJava(annotFileInputStream[i]);
        }
        this.m1(streamArray, annotType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m1(Stream[] streamArray, int[] nArray) {
        this.m4();
        int[] nArray2 = this.m1();
        for (Stream stream : streamArray) {
            z32 z3210 = new z32();
            try {
                XfdfWriter.writeAnnotations(z3210, new Document(stream));
                ((Stream)z3210).seek(0L, 0);
                XfdfReader.readAnnotations(z3210.toInputStream(), this.getDocument());
                this.m1(nArray2, nArray);
            }
            finally {
                if (z3210 != null) {
                    z3210.dispose();
                }
            }
        }
        this.getDocument().afterImport();
    }

    public void importAnnotations(InputStream[] annotFileInputStream) {
        Stream[] streamArray = new Stream[annotFileInputStream.length];
        for (int i = 0; i < annotFileInputStream.length; ++i) {
            streamArray[i] = Stream.fromJava(annotFileInputStream[i]);
        }
        this.m1(streamArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m1(Stream[] streamArray) {
        this.m4();
        for (Stream stream : streamArray) {
            z32 z3210 = new z32();
            try {
                XfdfWriter.writeAnnotations(z3210, new Document(stream));
                ((Stream)z3210).seek(0L, 0);
                XfdfReader.readAnnotations(z3210.toInputStream(), this.getDocument());
            }
            finally {
                if (z3210 != null) {
                    z3210.dispose();
                }
            }
        }
        this.getDocument().afterImport();
    }

    @Deprecated
    public void modifyAnnotations(int start, int end, int annotType, Annotation annotation) {
        this.modifyAnnotations(start, end, annotation);
    }

    public void modifyAnnotationsAuthor(int start, int end, String srcAuthor, String desAuthor) {
        for (int i = start; i <= end; ++i) {
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                if (!z5.m2((Object)annotation, z11.class) || !z133.m5(((z11)((Object)z5.m1(annotation, z11.class))).getTitle(), srcAuthor)) continue;
                ((z11)((Object)z5.m1(annotation, z11.class))).setTitle(desAuthor);
            }
        }
    }

    public void flatteningAnnotations() {
        this.m4();
        this.getDocument().flatten();
    }

    public void flatteningAnnotations(int start, int end, int[] annotType) {
        List<Annotation> list = this.extractAnnotations(start, end, annotType);
        for (Annotation annotation : list) {
            annotation.flatten();
        }
    }

    public void deleteAnnotations() {
        this.m4();
        for (Page page : this.getDocument().getPages()) {
            page.getAnnotations().delete();
        }
    }

    public void deleteAnnotations(String annotType) {
        this.m4();
        int n = (int)z63.parse(z5.m1(AnnotationType.class), annotType);
        for (Page page : this.getDocument().getPages()) {
            for (int i = page.getAnnotations().size(); i >= 1; --i) {
                Annotation annotation = page.getAnnotations().get_Item(i);
                if (annotation.getAnnotationType() != n) continue;
                page.getAnnotations().delete(annotation);
            }
        }
    }

    public void deleteAnnotation(String annotName) {
        this.m4();
        for (Page page : this.getDocument().getPages()) {
            for (Annotation annotation : page.getAnnotations()) {
                if (!z133.m5(annotation.getName(), annotName)) continue;
                page.getAnnotations().delete(annotation);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAnnotationsXfdf(OutputStream xmlOutputStream, int start, int end, String[] annotTypes) {
        z32 z3210 = new z32();
        this.m1((Stream)z3210, start, end, annotTypes);
        try {
            if (((Stream)z3210).canSeek()) {
                ((Stream)z3210).seek(0L, 0);
            }
            byte[] byArray = new byte[z3210.toInputStream().available()];
            z3210.toInputStream().read(byArray);
            xmlOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.close();
            }
        }
    }

    void m1(Stream stream, int n, int n2, String[] stringArray) {
        this.m4();
        this.m1(PdfAnnotationEditor.m1(stringArray));
        XfdfWriter.writeAnnotations(stream, this.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAnnotationsXfdf(OutputStream xmlOutputStream, int start, int end, int[] annotTypes) {
        z32 z3210 = new z32();
        this.m1((Stream)z3210, start, end, annotTypes);
        try {
            if (((Stream)z3210).canSeek()) {
                ((Stream)z3210).seek(0L, 0);
            }
            byte[] byArray = new byte[z3210.toInputStream().available()];
            z3210.toInputStream().read(byArray);
            xmlOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.close();
            }
        }
    }

    void m1(Stream stream, int n, int n2, int[] nArray) {
        this.m4();
        this.m1(nArray);
        XfdfWriter.writeAnnotations(stream, this.getDocument());
    }

    public Iterable extractAnnotations(int start, int end, String[] annotTypes) {
        return this.extractAnnotations(start, end, PdfAnnotationEditor.m1(annotTypes));
    }

    public List<Annotation> extractAnnotations(int start, int end, int[] annotTypes) {
        this.m4();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (int i = start; i <= end; ++i) {
            block1: for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                for (int n : annotTypes) {
                    if (annotation.getAnnotationType() != n) continue;
                    arrayList.add(annotation);
                    continue block1;
                }
            }
        }
        return arrayList;
    }

    @Override
    public void save(String outputFile) {
        this.m4();
        this.getDocument().save(outputFile);
    }

    @Override
    public void save(OutputStream outputStream) {
        this.m4();
        this.getDocument().save(outputStream);
    }

    public PdfAnnotationEditor() {
    }

    public PdfAnnotationEditor(IDocument document) {
        this.bindPdf(document);
    }

    public void modifyAnnotations(int start, int end, Annotation annotation) {
        this.m4();
        int n = annotation.getAnnotationType();
        for (int i = start; i <= end; ++i) {
            for (Annotation annotation2 : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                int n2 = annotation2.getAnnotationType();
                if (n2 != n) continue;
                annotation2.setModifiedInternal(annotation.getModifiedInternal());
                annotation2.setColor(annotation.getColor());
                annotation2.setContents(annotation.getContents());
                if (z5.m2((Object)annotation, z11.class) && z5.m2((Object)annotation2, z11.class)) {
                    ((z11)((Object)z5.m1(annotation2, z11.class))).setTitle(((z11)((Object)z5.m1(annotation, z11.class))).getTitle());
                }
                if (z5.m2((Object)annotation, MarkupAnnotation.class) && z5.m2((Object)annotation2, MarkupAnnotation.class)) {
                    ((MarkupAnnotation)((Object)z5.m1(annotation2, MarkupAnnotation.class))).setSubject(((MarkupAnnotation)((Object)z5.m1(annotation, MarkupAnnotation.class))).getSubject());
                }
                if (z5.m2((Object)annotation, TextAnnotation.class) && z5.m2((Object)annotation2, TextAnnotation.class)) {
                    ((TextAnnotation)((Object)z5.m1(annotation2, TextAnnotation.class))).setOpen(((TextAnnotation)((Object)z5.m1(annotation, TextAnnotation.class))).getOpen());
                }
                if (!z5.m2((Object)annotation, PopupAnnotation.class) || !z5.m2((Object)annotation2, PopupAnnotation.class)) continue;
                ((PopupAnnotation)((Object)z5.m1(annotation2, PopupAnnotation.class))).setOpen(((PopupAnnotation)((Object)z5.m1(annotation, PopupAnnotation.class))).getOpen());
            }
        }
    }

    void m1(int n, Rectangle rectangle, z6 z6100) {
        this.m4();
        Page page = this.getDocument().getPages().get_Item(n);
        if (page.getRotate() != 0) {
            Matrix matrix = page.getRotationMatrix().reverse();
            rectangle = matrix.transform(rectangle);
        }
        Redaction.redactAreaInternal(page, rectangle, z6100.m158());
        page.getContents().add(Redaction.getRedactionAppearanceInternal(rectangle, z6100.m158()));
    }

    public void redactArea(int pageIndex, Rectangle rect, Color color) {
        this.m1(pageIndex, rect, z6.m1(color));
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

