/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Document;
import com.aspose.pdf.ExplicitDestination;
import com.aspose.pdf.ExplicitDestinationTypeConverter;
import com.aspose.pdf.ExtendedBoolean;
import com.aspose.pdf.FitHExplicitDestination;
import com.aspose.pdf.GoToAction;
import com.aspose.pdf.GoToRemoteAction;
import com.aspose.pdf.GoToURIAction;
import com.aspose.pdf.IAppointment;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.LaunchAction;
import com.aspose.pdf.NamedDestination;
import com.aspose.pdf.OutlineItemCollection;
import com.aspose.pdf.Page;
import com.aspose.pdf.facades.Bookmark;
import com.aspose.pdf.facades.Bookmarks;
import com.aspose.pdf.facades.PdfContentEditor;
import com.aspose.pdf.facades.SaveableFacade;
import com.aspose.pdf.internal.ms.System.IO.Stream;
import com.aspose.pdf.internal.ms.System.IO.z14;
import com.aspose.pdf.internal.ms.System.IO.z32;
import com.aspose.pdf.internal.ms.System.IO.z34;
import com.aspose.pdf.internal.ms.System.z105;
import com.aspose.pdf.internal.ms.System.z129;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z30;
import com.aspose.pdf.internal.ms.System.z61;
import com.aspose.pdf.internal.ms.System.z64;
import com.aspose.pdf.internal.ms.System.z75;
import com.aspose.pdf.internal.ms.System.z85;
import com.aspose.pdf.internal.ms.System.z89;
import com.aspose.pdf.internal.p810.z18;
import com.aspose.pdf.internal.p815.z557;
import com.aspose.pdf.internal.p815.z561;
import com.aspose.pdf.internal.p953.z5;
import com.aspose.pdf.internal.p953.z9;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfBookmarkEditor
extends SaveableFacade {
    private static final Logger m1 = Logger.getLogger(PdfBookmarkEditor.class.getName());
    private static final z9 m2;

    private static void m1(OutlineItemCollection outlineItemCollection, String string, String string2) {
        while (outlineItemCollection != null) {
            if (z133.m5(z133.m3(outlineItemCollection.getTitle()), z133.m3(string))) {
                outlineItemCollection.setTitle(string2);
            }
            if (outlineItemCollection.getFirst() != null) {
                PdfBookmarkEditor.m1(outlineItemCollection.getFirst(), string, string2);
            }
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void m1(z561 z5612, OutlineItemCollection outlineItemCollection, String string) {
        if (outlineItemCollection == null) {
            return;
        }
        z5612.m16("ul");
        while (outlineItemCollection != null) {
            Object object;
            z5612.m16("li");
            z5612.m1(0);
            z5612.m16("a");
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.m1(z5612, outlineItemCollection.getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToRemoteAction.class));
                String string2 = string;
                if (((GoToRemoteAction)object).getFile().getName() != null) {
                    string2 = ((GoToRemoteAction)object).getFile().getName();
                }
                PdfBookmarkEditor.m1(z5612, ((GoToRemoteAction)object).getDestination(), string2);
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.m1(z5612, ((GoToAction)object).getDestination(), string);
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                z5612.m3("href", ((GoToURIAction)outlineItemCollection.getAction()).getURI());
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                z5612.m3("href", ((LaunchAction)outlineItemCollection.getAction()).getFile());
            }
            object = new StringBuilder();
            if (outlineItemCollection.getBold()) {
                ((StringBuilder)object).append("font-weight: bold;");
            }
            if (outlineItemCollection.getItalic()) {
                ((StringBuilder)object).append("font-style: italic;");
            }
            if (((StringBuilder)object).length() != 0) {
                z5612.m3("style", ((StringBuilder)object).toString());
            }
            z5612.m5(z133.m3(outlineItemCollection.getTitle()));
            z5612.m10();
            if (outlineItemCollection.getFirst() != null) {
                z5612.m1(1);
                PdfBookmarkEditor.m1(z5612, outlineItemCollection.getFirst(), string);
            }
            z5612.m10();
            z5612.m1(1);
            outlineItemCollection = outlineItemCollection.getNext();
        }
        z5612.m10();
    }

    private static void m1(z561 z5612, IAppointment iAppointment, String string) {
        if (iAppointment instanceof ExplicitDestination) {
            z5612.m3("href", z133.m1(new Object[]{string, "#page=", ((ExplicitDestination)iAppointment).getPage().getNumber()}));
        } else if (iAppointment instanceof NamedDestination) {
            z5612.m3("href", z133.m1(new String[]{string, "#nameddest=", ((NamedDestination)iAppointment).getName()}));
        }
    }

    private static void m1(z561 z5612, OutlineItemCollection outlineItemCollection) {
        while (outlineItemCollection != null) {
            boolean bl;
            Object object;
            z5612.m16("Title");
            if (outlineItemCollection.getItalic() || outlineItemCollection.getBold()) {
                object = new StringBuilder();
                if (outlineItemCollection.getItalic() && !outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("italic");
                } else if (!outlineItemCollection.getItalic() && outlineItemCollection.getBold()) {
                    ((StringBuilder)object).append("bold");
                } else {
                    ((StringBuilder)object).append("italic bold");
                }
                z5612.m3("Style", ((StringBuilder)object).toString());
            }
            if (outlineItemCollection.getColor() instanceof Color) {
                object = outlineItemCollection.getColor();
                String string = z133.m1(com.aspose.pdf.internal.p785.z9.m4(), "{0} {1} {2}", Float.valueOf((float)(((Color)object).getRed() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getGreen() & 0xFF) / 255.0f), Float.valueOf((float)(((Color)object).getBlue() & 0xFF) / 255.0f));
                z5612.m3("Color", string);
            }
            if (outlineItemCollection.getDestination() != null) {
                PdfBookmarkEditor.m1(z5612, outlineItemCollection.getDestination());
                z5612.m3("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToRemoteAction) {
                object = (GoToRemoteAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToRemoteAction.class));
                z5612.m3("NewWindow", z64.m1(ExtendedBoolean.class, ((GoToRemoteAction)object).getNewWindow()));
                z5612.m3("File", ((GoToRemoteAction)object).getFile().getName());
                PdfBookmarkEditor.m1(z5612, ((GoToRemoteAction)object).getDestination());
                z5612.m3("Action", "GoToR");
            } else if (outlineItemCollection.getAction() instanceof GoToAction) {
                object = (GoToAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToAction.class));
                PdfBookmarkEditor.m1(z5612, ((GoToAction)object).getDestination());
                z5612.m3("Action", "GoTo");
            } else if (outlineItemCollection.getAction() instanceof GoToURIAction) {
                z5612.m3("URI", ((GoToURIAction)((Object)z5.m1(outlineItemCollection.getAction(), GoToURIAction.class))).getURI());
                z5612.m3("Action", "URI");
            } else if (outlineItemCollection.getAction() instanceof LaunchAction) {
                z5612.m3("File", ((LaunchAction)((Object)z5.m1(outlineItemCollection.getAction(), LaunchAction.class))).getFile());
                z5612.m3("Action", "Launch");
            }
            boolean bl2 = bl = outlineItemCollection.getFirst() != null;
            if (bl) {
                z5612.m3("Open", z30.m2(outlineItemCollection.getOpen()));
            }
            PdfBookmarkEditor.m1(z5612, z133.m3(outlineItemCollection.getTitle()));
            if (bl) {
                PdfBookmarkEditor.m1(z5612, outlineItemCollection.getFirst());
            }
            z5612.m10();
            outlineItemCollection = outlineItemCollection.getNext();
        }
    }

    private static void m1(z561 z5612, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '\u007f') {
                z5612.m6(z133.m1(new Object[]{"&#", (int)c, Character.valueOf(';')}));
                continue;
            }
            z5612.m5(com.aspose.pdf.internal.ms.System.z34.m20(c));
        }
    }

    private static void m1(z561 z5612, IAppointment iAppointment) {
        if (iAppointment instanceof ExplicitDestination) {
            z5612.m3("Page", iAppointment.toString());
        } else if (iAppointment instanceof NamedDestination) {
            z5612.m3("Named", iAppointment.toString());
        }
    }

    private static void m1(z557 z5572, IDocument iDocument, OutlineItemCollection outlineItemCollection) {
        do {
            if (!"Title".equals(z5572.m23())) continue;
            if (z5572.m26() == 1) {
                String[] stringArray;
                String string;
                OutlineItemCollection outlineItemCollection2 = new OutlineItemCollection(iDocument.getOutlines());
                String string2 = z5572.m3("Style");
                if (string2 != null) {
                    switch (m2.m1(string2)) {
                        case 0: {
                            outlineItemCollection2.setItalic(true);
                            break;
                        }
                        case 1: {
                            outlineItemCollection2.setBold(true);
                            break;
                        }
                        case 2: 
                        case 3: {
                            outlineItemCollection2.setItalic(true);
                            outlineItemCollection2.setBold(true);
                        }
                    }
                }
                if ((string = z5572.m3("Color")) != null && (stringArray = z133.m6(string, ' ')).length == 3) {
                    int n = (int)((double)(z129.m1(stringArray[0], (z85)com.aspose.pdf.internal.p785.z9.m4()) * 255.0f) + 0.5);
                    int n2 = (int)((double)(z129.m1(stringArray[1], (z85)com.aspose.pdf.internal.p785.z9.m4()) * 255.0f) + 0.5);
                    int n3 = (int)((double)(z129.m1(stringArray[2], (z85)com.aspose.pdf.internal.p785.z9.m4()) * 255.0f) + 0.5);
                    outlineItemCollection2.setColor(new Color(n, n2, n3));
                }
                if (z5572.m4("Action")) {
                    stringArray = z5572.m3("Action");
                    switch (m2.m1((String)stringArray)) {
                        case 4: {
                            outlineItemCollection2.setDestination(PdfBookmarkEditor.m1(z5572, iDocument));
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 6: {
                            throw new z105();
                        }
                        case 7: {
                            throw new z105();
                        }
                    }
                }
                if (z5572.m4("Open")) {
                    outlineItemCollection2.setOpen(z30.m1(z5572.m3("Open")));
                }
                if (z5572.m21()) {
                    if (outlineItemCollection == null) {
                        iDocument.getOutlines().add(outlineItemCollection2);
                        continue;
                    }
                    outlineItemCollection.add(outlineItemCollection2);
                    continue;
                }
                z5572.m8();
                if (z5572.m26() != 3) continue;
                outlineItemCollection2.setTitle(z5572.m32());
                if (outlineItemCollection == null) {
                    iDocument.getOutlines().add(outlineItemCollection2);
                } else {
                    outlineItemCollection.add(outlineItemCollection2);
                }
                z5572.m8();
                if (!"Title".equals(z5572.m23()) || z5572.m26() != 1) continue;
                PdfBookmarkEditor.m1(z5572, iDocument, outlineItemCollection2);
                continue;
            }
            if (z5572.m26() != 15) continue;
            return;
        } while (z5572.m8());
    }

    private static IAppointment m1(z557 z5572, IDocument iDocument) {
        if (z5572.m4("Page")) {
            int n;
            String[] stringArray = z133.m1(z5572.m3("Page"), ' ');
            int n2 = stringArray.length > 1 ? ExplicitDestinationTypeConverter.toEnum(stringArray[1]) : 1;
            double[] dArray = null;
            try {
                n = z89.m1(stringArray[0], (z85)com.aspose.pdf.internal.p785.z9.m4());
                if (stringArray.length > 2) {
                    dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = z61.m1(stringArray[i], (z85)com.aspose.pdf.internal.p785.z9.m4());
                    }
                }
            }
            catch (z75 z752) {
                m1.log(Level.INFO, "Exception occur", z752);
                n = 1;
            }
            return ExplicitDestination.createDestination(iDocument.getPages().get_Item(n < 1 ? 1 : n), n2, dArray);
        }
        if (z5572.m4("Named")) {
            throw new z105();
        }
        return null;
    }

    private static void m1(Bookmarks bookmarks, Bookmarks bookmarks2) {
        for (Bookmark bookmark : bookmarks2) {
            bookmarks.add(bookmark);
            if (bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.m1(bookmarks, bookmark.getChildItem());
        }
    }

    public void createBookmarks() {
        this.createBookmarks(Color.BLACK, false, false);
    }

    public void createBookmarkOfPage(String bookmarkName, int pageNumber) {
        this.m4();
        OutlineItemCollection outlineItemCollection = new OutlineItemCollection(this.getDocument().getOutlines());
        outlineItemCollection.setTitle(bookmarkName);
        Page page = this.getDocument().getPages().get_Item(1);
        if (pageNumber <= this.getDocument().getPages().size()) {
            page = this.getDocument().getPages().get_Item(pageNumber);
        }
        outlineItemCollection.setDestination(new FitHExplicitDestination(page, page.getRect().getHeight()));
        this.getDocument().getOutlines().add(outlineItemCollection);
    }

    public void createBookmarks(Bookmark bookmark) {
        this.m4();
        this.getDocument().getOutlines().add(bookmark.toOutlineItemCollection(this.getDocument()));
    }

    public void createBookmarks(Color color, boolean boldFlag, boolean italicFlag) {
        this.m4();
        PdfContentEditor pdfContentEditor = new PdfContentEditor();
        pdfContentEditor.bindPdf(this.getDocument());
        for (int i = 1; i <= this.getDocument().getPages().size(); ++i) {
            pdfContentEditor.createBookmarksAction(z133.m1("Page{0}", new Object[]{i}), color, boldFlag, italicFlag, null, "GoTo", z89.m2(i));
        }
    }

    public void createBookmarkOfPage(String[] bookmarkName, int[] pageNumber) {
        this.m4();
        if (bookmarkName.length != pageNumber.length) {
            throw new com.aspose.pdf.internal.ms.System.z9("Each bookmark must have name, but bookmarkName.Length != pageNumber.Length");
        }
        for (int i = 0; i < bookmarkName.length; ++i) {
            this.createBookmarkOfPage(bookmarkName[i], pageNumber[i]);
        }
    }

    public void deleteBookmarks() {
        this.m4();
        this.getDocument().getOutlines().delete();
    }

    public void deleteBookmarks(String title) {
        this.m4();
        this.getDocument().getOutlines().delete(title);
    }

    public void modifyBookmarks(String sTitle, String dTitle) {
        this.m4();
        if (this.getDocument().getOutlines().size() > 0) {
            PdfBookmarkEditor.m1(this.getDocument().getOutlines().getFirst(), sTitle, dTitle);
        }
    }

    public Bookmarks extractBookmarks() {
        return this.extractBookmarks(false);
    }

    public Bookmarks extractBookmarks(boolean upperLevel) {
        Bookmarks bookmarks = new Bookmarks();
        for (OutlineItemCollection outlineItemCollection : this.getDocument().getOutlines()) {
            Bookmark bookmark = Bookmark.m1(outlineItemCollection);
            bookmarks.add(bookmark);
            if (upperLevel || bookmark.getChildItem().size() == 0) continue;
            PdfBookmarkEditor.m1(bookmarks, bookmark.getChildItem());
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(String title) {
        Bookmarks bookmarks = new Bookmarks();
        for (Bookmark bookmark : this.extractBookmarks()) {
            if (!z133.m5(z133.m3(bookmark.getTitle()), z133.m3(title))) continue;
            bookmarks.add(bookmark);
        }
        return bookmarks;
    }

    public Bookmarks extractBookmarks(Bookmark bookmark) {
        Bookmarks bookmarks = this.extractBookmarks();
        for (Bookmark bookmark2 : bookmarks) {
            if (!z133.m5(z133.m3(bookmark2.getTitle()), z133.m3(bookmark.getTitle()))) continue;
            return bookmark2.getChildItem();
        }
        return new Bookmarks();
    }

    @Deprecated
    public void extractBookmarksToHTML(String pdfFile, String cssFile) {
        String string = z34.m2(z34.m6(pdfFile), z34.m2(pdfFile));
        PdfBookmarkEditor.exportBookmarksToHtml(pdfFile, z133.m1(new String[]{string, "-index.html"}));
    }

    public void exportBookmarksToXML(String xmlFile) {
        z561 z5612 = new z561(xmlFile, z18.m4("iso_8859_1"));
        z5612.m1(1);
        z5612.m6("<?xml version=\"1.0\" encoding=\"iso_8859_1\"?>");
        z5612.m16("Bookmark");
        PdfBookmarkEditor.m1(z5612, this.getDocument().getOutlines().getFirst());
        z5612.m10();
        z5612.m6();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportBookmarksToXML(OutputStream output) {
        z32 z3210 = new z32();
        this.m2(z3210);
        try {
            if (((Stream)z3210).canSeek()) {
                ((Stream)z3210).seek(0L, 0);
            }
            byte[] byArray = new byte[z3210.toInputStream().available()];
            z3210.toInputStream().read(byArray);
            output.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.close();
            }
        }
    }

    void m2(Stream stream) {
        z561 z5612 = new z561(stream, z18.m4("iso-8859-1"));
        z5612.m1(1);
        z5612.m6("<?xml version=\"1.0\" encoding=\"ISO8859-1\"?>");
        z5612.m16("Bookmark");
        PdfBookmarkEditor.m1(z5612, this.getDocument().getOutlines().getFirst());
        z5612.m10();
        z5612.m7();
    }

    public void importBookmarksWithXML(String xmlFile) {
        z557 z5572 = new z557(z14.m6(xmlFile));
        z5572.m7(2);
        PdfBookmarkEditor.m1(z5572, this.getDocument(), null);
        z5572.m4();
    }

    void m3(Stream stream) {
        z557 z5572 = new z557(stream);
        z5572.m7(2);
        PdfBookmarkEditor.m1(z5572, this.getDocument(), null);
        z5572.m4();
    }

    public void importBookmarksWithXML(InputStream stream) {
        this.m3(Stream.fromJava(stream));
    }

    public PdfBookmarkEditor() {
    }

    public PdfBookmarkEditor(IDocument document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBookmarksToHtml(String inPdfFile, String outHtmlFile) {
        Document document = new Document(inPdfFile);
        try {
            z18 z1810 = z18.m24();
            z561 z5612 = new z561(outHtmlFile, z1810);
            z5612.m1(1);
            z5612.m1("html", null, null, null);
            z5612.m16("html");
            z5612.m16("head");
            z5612.m16("title");
            z5612.m5(z34.m2(outHtmlFile));
            z5612.m10();
            z5612.m16("meta");
            z5612.m3("charset", z1810.m18());
            z5612.m10();
            z5612.m16("style");
            z5612.m3("type", "text/css");
            z5612.m5("ul { list-style-type: none; }");
            z5612.m10();
            z5612.m10();
            z5612.m16("body");
            if (document.getOutlines().size() != 0) {
                PdfBookmarkEditor.m1(z5612, document.getOutlines().getFirst(), z34.m1(inPdfFile));
            } else {
                z5612.m5("This document has no bookmarks.");
            }
            z5612.m10();
            z5612.m10();
            z5612.m6();
        }
        finally {
            if (document != null) {
                document.dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    static {
        m1.setUseParentHandlers(false);
        m2 = new z9("italic", "bold", "italic bold", "bold italic", "GoTo", "GoToR", "URI", "Launch");
    }
}

